/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.IntComparator;
import com.devexperts.util.LongComparator;
import com.devexperts.util.QuickSort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class QuickSortTest {
    private static final int REPEAT = 20;
    private static final int SIZE = 500;
    private final Random random = new Random(20160915L);
    private int unstable;

    @Test
    public void testInteger() {
        this.unstable = 0;
        for (int i = 0; i < 3; ++i) {
            Comparator comparator = i == 0 ? null : (i == 1 ? Comparator.naturalOrder() : Comparator.comparing(Integer::intValue));
            this.checkWhole(comparator, this::toIntegerList, (a, c) -> QuickSort.sort((List)a));
            this.checkRange(comparator, this::toIntegerList, (a, f, t, c) -> QuickSort.sort((List)a, (int)f, (int)t));
            this.checkWhole(comparator, this::toIntegerList, QuickSort::sort);
            this.checkRange(comparator, this::toIntegerList, QuickSort::sort);
            this.checkWhole(comparator, this::toIntegerArray, (a, c) -> QuickSort.sort((Object[])a));
            this.checkRange(comparator, this::toIntegerArray, (a, f, t, c) -> QuickSort.sort((Object[])a, (int)f, (int)t));
            this.checkWhole(comparator, this::toIntegerArray, QuickSort::sort);
            this.checkRange(comparator, this::toIntegerArray, QuickSort::sort);
        }
    }

    @Test
    public void testValue() {
        this.unstable = 0;
        while (this.unstable < 5) {
            this.checkWhole(this::compareValue, this::toValueList, QuickSort::sort);
            this.checkRange(this::compareValue, this::toValueList, QuickSort::sort);
            this.checkWhole(this::compareValue, this::toValueArray, QuickSort::sort);
            this.checkRange(this::compareValue, this::toValueArray, QuickSort::sort);
            ++this.unstable;
        }
    }

    @Test
    public void testInt() {
        this.unstable = 0;
        while (this.unstable < 5) {
            IntComparator comparator = this::compareInt;
            this.checkWhole(comparator, this::toIntArray, QuickSort::sort);
            this.checkRange(comparator, this::toIntArray, QuickSort::sort);
            comparator = IntComparator.comparingInt(i -> -i).reversed();
            this.checkWhole(comparator, this::toIntArray, QuickSort::sort);
            this.checkRange(comparator, this::toIntArray, QuickSort::sort);
            comparator = IntComparator.comparing(Value::new, this::compareValue);
            this.checkWhole(comparator, this::toIntArray, QuickSort::sort);
            this.checkRange(comparator, this::toIntArray, QuickSort::sort);
            ++this.unstable;
        }
    }

    @Test
    public void testLong() {
        this.unstable = 0;
        while (this.unstable < 5) {
            LongComparator comparator = this::compareLong;
            this.checkWhole(comparator, this::toLongArray, QuickSort::sort);
            this.checkRange(comparator, this::toLongArray, QuickSort::sort);
            comparator = LongComparator.comparingLong(i -> -i).reversed();
            this.checkWhole(comparator, this::toLongArray, QuickSort::sort);
            this.checkRange(comparator, this::toLongArray, QuickSort::sort);
            comparator = LongComparator.comparing(i -> new Value((int)i), this::compareValue);
            this.checkWhole(comparator, this::toLongArray, QuickSort::sort);
            this.checkRange(comparator, this::toLongArray, QuickSort::sort);
            ++this.unstable;
        }
    }

    private List<Integer> toIntegerList(int[] x) {
        return new ArrayList<Integer>(Arrays.asList(this.toIntegerArray(x)));
    }

    private List<Value> toValueList(int[] x) {
        return new ArrayList<Value>(Arrays.asList(this.toValueArray(x)));
    }

    private Integer[] toIntegerArray(int[] x) {
        Integer[] r = new Integer[x.length];
        for (int i = 0; i < x.length; ++i) {
            r[i] = x[i];
        }
        return r;
    }

    private Value[] toValueArray(int[] x) {
        Value[] r = new Value[x.length];
        for (int i = 0; i < x.length; ++i) {
            r[i] = new Value(x[i]);
        }
        return r;
    }

    private int[] toIntArray(int[] x) {
        return (int[])x.clone();
    }

    private long[] toLongArray(int[] x) {
        long[] r = new long[x.length];
        for (int i = 0; i < x.length; ++i) {
            r[i] = x[i];
        }
        return r;
    }

    private int[] generate() {
        int[] x = new int[500];
        for (int i = 0; i < 500; ++i) {
            x[i] = this.random.nextInt(450);
        }
        return x;
    }

    private int compareValue(Value v1, Value v2) {
        return this.compareLong(v1.value, v2.value);
    }

    private int compareInt(int v1, int v2) {
        return this.compareLong(v1, v2);
    }

    private int compareLong(long v1, long v2) {
        switch (this.unstable) {
            case 0: {
                return Long.compare(v1, v2);
            }
            case 1: {
                return -1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return this.random.nextInt(3) - 1;
            }
        }
        throw new IllegalArgumentException();
    }

    private <A, C> void checkWhole(C c, Function<int[], A> f, WholeSorter<A, C> s) {
        for (int rep = 0; rep < 20; ++rep) {
            int[] x = this.generate();
            A actual = f.apply(x);
            s.sort(actual, c);
            if (this.unstable != 0) {
                this.sort(actual, 0, x.length);
            }
            Arrays.sort(x);
            A expected = f.apply(x);
            this.checkEquals(expected, actual);
        }
    }

    private <A, C> void checkRange(C c, Function<int[], A> f, RangeSorter<A, C> s) {
        for (int rep = 0; rep < 20; ++rep) {
            int fromIndex = this.random.nextInt(500);
            int toIndex = this.random.nextInt(500 - fromIndex) + fromIndex;
            int[] x = this.generate();
            A actual = f.apply(x);
            s.sort(actual, fromIndex, toIndex, c);
            if (this.unstable != 0) {
                this.sort(actual, fromIndex, toIndex);
            }
            Arrays.sort(x, fromIndex, toIndex);
            A expected = f.apply(x);
            this.checkEquals(expected, actual);
        }
    }

    private <A> void sort(A a, int fromIndex, int toIndex) {
        if (a instanceof List) {
            ((List)a).subList(fromIndex, toIndex).sort(Comparator.comparing(Number::intValue));
        } else if (a instanceof Number[]) {
            Arrays.sort((Number[])a, fromIndex, toIndex, Comparator.comparing(Number::intValue));
        } else if (a instanceof int[]) {
            Arrays.sort((int[])a, fromIndex, toIndex);
        } else if (a instanceof long[]) {
            Arrays.sort((long[])a, fromIndex, toIndex);
        } else {
            Assert.fail((String)"unknown container type");
        }
    }

    private <A> void checkEquals(A expected, A actual) {
        if (expected instanceof List) {
            Assert.assertEquals(expected, actual);
        } else if (expected instanceof Number[]) {
            Assert.assertArrayEquals((Object[])((Number[])expected), (Object[])((Number[])actual));
        } else if (expected instanceof int[]) {
            Assert.assertArrayEquals((int[])((int[])expected), (int[])((int[])actual));
        } else if (expected instanceof long[]) {
            Assert.assertArrayEquals((long[])((long[])expected), (long[])((long[])actual));
        } else {
            Assert.fail((String)"unknown container type");
        }
    }

    private static class Value
    extends Number {
        final int value;

        Value(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            return obj instanceof Value && ((Value)obj).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static interface RangeSorter<A, C> {
        public void sort(A var1, int var2, int var3, C var4);
    }

    private static interface WholeSorter<A, C> {
        public void sort(A var1, C var2);
    }
}

