/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.LongHashMap;
import com.devexperts.util.LongMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongHashMapTest {
    private static final Object NO_VALUE = new Object(){

        public String toString() {
            return "NO_VALUE";
        }
    };
    private static final String DEFAULT_INIT = "INIT";
    public Map<Long, String> map;
    public LongMap<String> longMap;

    @Before
    public void setUp() throws Exception {
        this.map = new HashMap<Long, String>();
        this.longMap = new LongHashMap();
    }

    @Test
    public void testGetOrDefault() {
        this.standardChecks("getOrDefault", k -> this.map.getOrDefault(k, "B"), k -> (String)this.longMap.getOrDefault(k, (Object)"B"));
        this.standardChecks("getOrDefault", k -> this.map.getOrDefault(k, "B"), k -> (String)this.longMap.getOrDefault((Object)k, (Object)"B"));
    }

    @Test
    public void testRemoveByKey() {
        this.standardChecks("remove", k -> this.map.remove(k), k -> (String)this.longMap.remove(k));
        this.standardChecks("remove", k -> this.map.remove(k), k -> (String)this.longMap.remove((Object)k));
    }

    @Test
    public void testComputeIfAbsent() {
        this.standardChecks("computeIfAbsent", k -> this.map.computeIfAbsent((Long)k, lk -> "B"), k -> (String)this.longMap.computeIfAbsent(k, lk -> "B"));
        this.standardChecks("computeIfAbsent", k -> this.map.computeIfAbsent((Long)k, lk -> "B"), k -> (String)this.longMap.computeIfAbsent((Object)k, lk -> "B"));
        this.standardChecks("computeIfAbsent", k -> this.map.computeIfAbsent((Long)k, lk -> null), k -> (String)this.longMap.computeIfAbsent(k, lk -> null));
        this.standardChecks("computeIfAbsent", k -> this.map.computeIfAbsent((Long)k, lk -> null), k -> (String)this.longMap.computeIfAbsent((Object)k, lk -> null));
    }

    @Test
    public void testPutIfAbsent() {
        this.standardChecks("putIfAbsent", k -> this.map.putIfAbsent((Long)k, "B"), k -> (String)this.longMap.putIfAbsent(k, (Object)"B"));
        this.standardChecks("putIfAbsent", k -> this.map.putIfAbsent((Long)k, "B"), k -> (String)this.longMap.putIfAbsent((Object)k, (Object)"B"));
    }

    @Test
    public void testReplace() {
        this.standardChecks("replace", k -> this.map.replace((Long)k, "B"), k -> (String)this.longMap.replace(k, (Object)"B"));
        this.standardChecks("replace", k -> this.map.replace((Long)k, "B"), k -> (String)this.longMap.replace((Object)k, (Object)"B"));
    }

    @Test
    public void testReplaceWithCheck() {
        this.checkMethod("replace", 1L, "A", k -> this.map.replace((Long)k, "A", "B"), k -> this.longMap.replace(k, (Object)"A", (Object)"B"));
        this.checkMethod("replace", 1L, "A", k -> this.map.replace((Long)k, "A", "B"), k -> this.longMap.replace((Object)k, (Object)"A", (Object)"B"));
        this.checkMethod("replace", 2L, null, k -> this.map.replace((Long)k, (String)null, "B"), k -> this.longMap.replace(k, null, (Object)"B"));
        this.checkMethod("replace", 2L, null, k -> this.map.replace((Long)k, (String)null, "B"), k -> this.longMap.replace((Object)k, null, (Object)"B"));
        Assert.assertNotEquals((Object)DEFAULT_INIT, (Object)"A");
        this.standardChecks("replace", k -> this.map.replace((Long)k, "A", "B"), k -> this.longMap.replace(k, (Object)"A", (Object)"B"));
        this.standardChecks("replace", k -> this.map.replace((Long)k, "A", "B"), k -> this.longMap.replace((Object)k, (Object)"A", (Object)"B"));
        this.standardChecksNoNull("replace", k -> this.map.replace((Long)k, (String)null, "B"), k -> this.longMap.replace(k, null, (Object)"B"));
        this.standardChecksNoNull("replace", k -> this.map.replace((Long)k, (String)null, "B"), k -> this.longMap.replace((Object)k, null, (Object)"B"));
    }

    @Test
    public void testRemoveWithCheck() {
        this.checkMethod("remove", 1L, "A", k -> this.map.remove(k, "A"), k -> this.longMap.remove(k, (Object)"A"));
        this.checkMethod("remove", 1L, "A", k -> this.map.remove(k, "A"), k -> this.longMap.remove((Object)k, (Object)"A"));
        this.checkMethod("remove", 2L, null, k -> this.map.remove(k, null), k -> this.longMap.remove(k, null));
        this.checkMethod("remove", 2L, null, k -> this.map.remove(k, null), k -> this.longMap.remove((Object)k, null));
        Assert.assertNotEquals((Object)DEFAULT_INIT, (Object)"A");
        this.standardChecks("remove", k -> this.map.remove(k, "A"), k -> this.longMap.remove(k, (Object)"A"));
        this.standardChecks("remove", k -> this.map.remove(k, "A"), k -> this.longMap.remove((Object)k, (Object)"A"));
        this.standardChecksNoNull("remove", k -> this.map.remove(k, null), k -> this.longMap.remove(k, null));
        this.standardChecksNoNull("remove", k -> this.map.remove(k, null), k -> this.longMap.remove((Object)k, null));
    }

    @Test
    public void testCompute() {
        this.standardChecks("compute", k -> this.map.compute((Long)k, (lk, o) -> "B"), k -> (String)this.longMap.compute(k, (lk, o) -> "B"));
        this.standardChecks("compute", k -> this.map.compute((Long)k, (lk, o) -> "B"), k -> (String)this.longMap.compute((Object)k, (lk, o) -> "B"));
        this.standardChecks("compute", k -> this.map.compute((Long)k, (lk, o) -> null), k -> (String)this.longMap.compute(k, (lk, o) -> null));
        this.standardChecks("compute", k -> this.map.compute((Long)k, (lk, o) -> null), k -> (String)this.longMap.compute((Object)k, (lk, o) -> null));
    }

    @Test
    public void testMerge() {
        this.standardChecks("compute", k -> this.map.merge((Long)k, "B", String::concat), k -> (String)this.longMap.merge(k, (Object)"B", String::concat));
        this.standardChecks("compute", k -> this.map.merge((Long)k, "B", String::concat), k -> (String)this.longMap.merge((Object)k, (Object)"B", String::concat));
        this.standardChecks("compute", k -> this.map.merge((Long)k, "B", (a, b) -> null), k -> (String)this.longMap.merge(k, (Object)"B", (a, b) -> null));
        this.standardChecks("compute", k -> this.map.merge((Long)k, "B", (a, b) -> null), k -> (String)this.longMap.merge((Object)k, (Object)"B", (a, b) -> null));
    }

    @Test
    public void testComputeIfPresent() {
        this.standardChecks("computeIfPresent", k -> this.map.computeIfPresent((Long)k, (lk, o) -> "B"), k -> (String)this.longMap.computeIfPresent(k, (lk, o) -> "B"));
        this.standardChecks("computeIfPresent", k -> this.map.computeIfPresent((Long)k, (lk, o) -> "B"), k -> (String)this.longMap.computeIfPresent((Object)k, (lk, o) -> "B"));
        this.standardChecks("computeIfPresent", k -> this.map.computeIfPresent((Long)k, (lk, o) -> null), k -> (String)this.longMap.computeIfPresent(k, (lk, o) -> null));
        this.standardChecks("computeIfPresent", k -> this.map.computeIfPresent((Long)k, (lk, o) -> null), k -> (String)this.longMap.computeIfPresent((Object)k, (lk, o) -> null));
    }

    @Test
    public void testForEach() {
        LongHashMap map = new LongHashMap();
        Object first = new Object();
        map.put(1L, first);
        Object second = new Object();
        map.put(2L, second);
        map.forEach((key, value) -> {
            if (first.equals(value)) {
                Assert.assertEquals((long)1L, (long)key);
            } else if (second.equals(value)) {
                Assert.assertEquals((long)2L, (long)key);
            } else {
                Assert.fail((String)("Valid key-value pair not found: key = '" + key + "', value = '" + value + "'"));
            }
        });
    }

    private void standardChecks(String op, Function<Long, Object> mapOp, LongFunction<Object> longMapOp) {
        this.standardChecks(op, mapOp, longMapOp, true);
    }

    private void standardChecksNoNull(String op, Function<Long, Object> mapOp, LongFunction<Object> longMapOp) {
        this.standardChecks(op, mapOp, longMapOp, false);
    }

    private void standardChecks(String op, Function<Long, Object> mapOp, LongFunction<Object> longMapOp, boolean checkNull) {
        this.checkMethod(op, 1L, DEFAULT_INIT, mapOp, longMapOp);
        if (!checkNull) {
            this.checkMethod(op, 2L, null, mapOp, longMapOp);
        }
        this.checkMethod(op, 3L, NO_VALUE, mapOp, longMapOp);
    }

    private void checkMethod(String op, long key, Object init, Function<Long, Object> mapOp, LongFunction<Object> longMapOp) {
        if (init == NO_VALUE) {
            this.map.remove(key);
            this.longMap.remove(key);
        } else {
            this.map.put(key, (String)init);
            this.longMap.put(key, (Object)((String)init));
        }
        String desc = op + "[key=" + key + ", init=" + init + "]: ";
        Assert.assertEquals((String)(desc + "setup"), (Object)this.map.containsKey(key), (Object)this.longMap.containsKey(key));
        Assert.assertEquals((String)(desc + "setup"), (Object)this.map.get(key), (Object)this.longMap.get(key));
        Object mapResult = mapOp.apply(key);
        Object longMapResult = longMapOp.apply(key);
        Assert.assertEquals((String)(desc + "result"), (Object)mapResult, (Object)longMapResult);
        Assert.assertEquals((String)(desc + "containsKey"), (Object)this.map.containsKey(key), (Object)this.longMap.containsKey(key));
        Assert.assertEquals((String)(desc + "get"), (Object)this.map.get(key), (Object)this.longMap.get(key));
    }
}

