/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.application;

import com.devexperts.logging.Logging;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.dxlink.websocket.application.Delegates;
import com.devexperts.qd.dxlink.websocket.application.DxLinkClientReceiver;
import com.devexperts.qd.ng.RecordBuffer;
import com.dxfeed.event.EventType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

class ChannelEventsParser
implements DxLinkClientReceiver.EventsParser {
    private static final Logging log = Logging.getLogging(ChannelEventsParser.class);
    private final QDContract contract;
    private final Delegates delegates;
    private final DataParser compactDataParser;
    private final DataParser fullDataParser;
    private DataParser dataParser;
    private JsonParser json;

    ChannelEventsParser(QDContract contract, Delegates delegates) {
        this.contract = contract;
        this.delegates = delegates;
        this.compactDataParser = new CompactDataParser();
        this.fullDataParser = new FullDataParser();
    }

    void updateConfig(String dataFormat, Map<String, List<String>> eventFields) {
        if ("COMPACT".equals(dataFormat)) {
            this.dataParser = this.compactDataParser;
        } else if ("FULL".equals(dataFormat)) {
            this.dataParser = this.fullDataParser;
        } else {
            throw new IllegalArgumentException("Unsupported dataFormat: '" + dataFormat + "'");
        }
        this.dataParser.updateConfig(eventFields);
    }

    DxLinkClientReceiver.EventsParser init(JsonParser json) {
        this.json = json;
        return this;
    }

    @Override
    public void parse(RecordBuffer recordBuffer) throws IOException {
        this.dataParser.parse(this.json, this.contract, recordBuffer);
    }

    @Override
    public QDContract getContract() {
        return this.contract;
    }

    private static void skipToken(JsonParser json, JsonToken token) throws IOException {
        if (!json.hasToken(token)) {
            throw new IllegalStateException(String.format("Expected token '%s', but was '%s'.", token, json.currentToken()));
        }
        json.nextToken();
    }

    private static void expectedToken(JsonParser json, JsonToken token) {
        if (!json.hasToken(token)) {
            throw new IllegalStateException(String.format("Expected token '%s', but was '%s'.", token, json.currentToken()));
        }
    }

    private static void expectedValue(JsonParser json, String fieldName, JsonToken token) throws IOException {
        if (!fieldName.equals(json.currentName())) {
            throw new IllegalStateException(String.format("Expected field name '%s', but was '%s'.", fieldName, json.currentName()));
        }
        if (!json.hasToken(token)) {
            throw new IllegalStateException(String.format("Expected token '%s', but was '%s'.", token, json.currentToken()));
        }
    }

    private static void expectedValue(JsonParser json) {
        if (json.currentToken() == null) {
            throw new IllegalStateException("Unexpected end of json.");
        }
        if (!json.currentToken().isScalarValue()) {
            throw new IllegalStateException(String.format("Expected scalar value token, but was '%s'.", json.currentToken()));
        }
    }

    private class FullDataParser
    extends DataParser {
        private final Map<String, Buffer> buffers;

        private FullDataParser() {
            this.buffers = new HashMap<String, Buffer>();
        }

        @Override
        protected void extractEvents(JsonParser json, Consumer<EventType<?>> recordBuffer) throws IOException {
            ChannelEventsParser.skipToken(json, JsonToken.START_ARRAY);
            while (json.currentToken() != JsonToken.END_ARRAY) {
                ChannelEventsParser.skipToken(json, JsonToken.START_OBJECT);
                json.nextValue();
                ChannelEventsParser.expectedValue(json, "eventType", JsonToken.VALUE_STRING);
                String eventType = json.getValueAsString();
                this.buffers.computeIfAbsent(eventType, x$0 -> new EmptyBuffer((String)x$0)).readEvent(recordBuffer);
                ChannelEventsParser.skipToken(json, JsonToken.END_OBJECT);
            }
            ChannelEventsParser.skipToken(json, JsonToken.END_ARRAY);
        }

        @Override
        void updateConfig(Map<String, List<String>> eventFields) {
            eventFields.forEach((eventType, fields) -> this.buffers.put((String)eventType, new BufferImpl((String)eventType, ChannelEventsParser.this.delegates.getEventBuilder((String)eventType, (List<String>)fields))));
        }

        private class EmptyBuffer
        implements Buffer {
            private final String eventType;

            private EmptyBuffer(String eventType) {
                this.eventType = eventType;
            }

            @Override
            public void readEvent(Consumer<EventType<?>> recordBuffer) throws IOException {
                log.warn(String.format("Unknown event type: '%s'.", this.eventType));
                while (ChannelEventsParser.this.json.currentToken() != JsonToken.END_OBJECT) {
                    ChannelEventsParser.expectedValue(ChannelEventsParser.this.json);
                    ChannelEventsParser.this.json.nextValue();
                }
            }
        }

        private class BufferImpl
        implements Buffer {
            private final String eventType;
            private final Supplier<EventType<?>> factory;
            private final LinkedHashMap<String, Delegates.Setter> setters;

            private BufferImpl(String eventType, Delegates.EventBuilder eventBuilder) {
                this.eventType = eventType;
                this.factory = eventBuilder.factory;
                this.setters = eventBuilder.setters;
            }

            @Override
            public void readEvent(Consumer<EventType<?>> recordBuffer) throws IOException {
                EventType<?> event = this.factory.get();
                ChannelEventsParser.this.json.nextValue();
                while (ChannelEventsParser.this.json.currentToken() != JsonToken.END_OBJECT) {
                    ChannelEventsParser.expectedValue(ChannelEventsParser.this.json);
                    String fieldName = ChannelEventsParser.this.json.currentName();
                    Delegates.Setter setter = this.setters.get(fieldName);
                    if (setter != null) {
                        setter.setValue(event, ChannelEventsParser.this.json);
                    } else {
                        log.warn(String.format("Unknown field: '%s' for event type '%s'.", fieldName, this.eventType));
                    }
                    ChannelEventsParser.this.json.nextValue();
                }
                if (event != null) {
                    recordBuffer.accept(event);
                }
            }
        }
    }

    private class CompactDataParser
    extends DataParser {
        private final Map<String, Buffer> buffers;

        private CompactDataParser() {
            this.buffers = new HashMap<String, Buffer>();
        }

        @Override
        protected void extractEvents(JsonParser json, Consumer<EventType<?>> recordBuffer) throws IOException {
            ChannelEventsParser.skipToken(json, JsonToken.START_ARRAY);
            while (json.currentToken() != JsonToken.END_ARRAY) {
                ChannelEventsParser.expectedToken(json, JsonToken.VALUE_STRING);
                String eventType = json.getValueAsString();
                json.nextToken();
                ChannelEventsParser.skipToken(json, JsonToken.START_ARRAY);
                this.buffers.computeIfAbsent(eventType, x$0 -> new EmptyBuffer((String)x$0)).readEvent(recordBuffer);
                ChannelEventsParser.skipToken(json, JsonToken.END_ARRAY);
            }
            ChannelEventsParser.skipToken(json, JsonToken.END_ARRAY);
        }

        @Override
        void updateConfig(Map<String, List<String>> eventFields) {
            eventFields.forEach((eventType, fieldNames) -> this.buffers.put((String)eventType, new BufferImpl(ChannelEventsParser.this.delegates.getEventBuilder((String)eventType, (List<String>)fieldNames))));
        }

        private class EmptyBuffer
        implements Buffer {
            private final String eventType;

            private EmptyBuffer(String eventType) {
                this.eventType = eventType;
            }

            @Override
            public void readEvent(Consumer<EventType<?>> recordBuffer) throws IOException {
                log.warn(String.format("Unknown event type: '%s'.", this.eventType));
                while (ChannelEventsParser.this.json.currentToken() != JsonToken.END_ARRAY) {
                    ChannelEventsParser.expectedValue(ChannelEventsParser.this.json);
                    ChannelEventsParser.this.json.nextToken();
                }
            }
        }

        private class BufferImpl
        implements Buffer {
            private final EventType<?> event;
            private final LinkedHashMap<String, Delegates.Setter> setters;

            private BufferImpl(Delegates.EventBuilder eventBuilder) {
                this.event = eventBuilder.factory.get();
                this.setters = eventBuilder.setters;
            }

            @Override
            public void readEvent(Consumer<EventType<?>> recordBuffer) throws IOException {
                while (ChannelEventsParser.this.json.currentToken() != JsonToken.END_ARRAY) {
                    ChannelEventsParser.expectedValue(ChannelEventsParser.this.json);
                    for (Delegates.Setter setter : this.setters.values()) {
                        setter.setValue(this.event, ChannelEventsParser.this.json);
                        ChannelEventsParser.this.json.nextToken();
                    }
                    if (this.event == null) continue;
                    recordBuffer.accept(this.event);
                }
            }
        }
    }

    private static interface Buffer {
        public void readEvent(Consumer<EventType<?>> var1) throws IOException;
    }

    private abstract class DataParser {
        private DataParser() {
        }

        void parse(JsonParser json, QDContract qdContract, RecordBuffer recordBuffer) throws IOException {
            this.extractEvents(json, event -> ChannelEventsParser.this.delegates.putEventToRecordBuffer((EventType<?>)event, qdContract, recordBuffer));
        }

        protected abstract void extractEvents(JsonParser var1, Consumer<EventType<?>> var2) throws IOException;

        abstract void updateConfig(Map<String, List<String>> var1);
    }
}

