/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.application;

import com.devexperts.io.ByteArrayOutput;
import com.devexperts.qd.dxlink.websocket.application.DxLinkSubscription;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class DxLinkJsonMessageFactory {
    public static final String FIELD_NAME_TYPE = "type";
    public static final String FIELD_NAME_CHANNEL = "channel";
    private final JsonGenerator generator;
    private final ByteArrayOutput buffer;

    public DxLinkJsonMessageFactory() {
        try {
            this.buffer = new ByteArrayOutput();
            this.generator = JsonFactory.builder().build().createGenerator((DataOutput)this.buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    ByteBuf createSetup(int channel, String version, Long keepaliveTimeout, Long acceptKeepaliveTimeout, Map<String, String> agent) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeStringField(FIELD_NAME_TYPE, "SETUP");
        this.generator.writeNumberField(FIELD_NAME_CHANNEL, channel);
        this.generator.writeStringField("version", version);
        if (keepaliveTimeout != null) {
            this.generator.writeNumberField("keepaliveTimeout", (double)keepaliveTimeout.longValue() / 1000.0);
        }
        if (acceptKeepaliveTimeout != null) {
            this.generator.writeNumberField("acceptKeepaliveTimeout", (double)acceptKeepaliveTimeout.longValue() / 1000.0);
        }
        if (agent != null && !agent.isEmpty()) {
            this.generator.writeObjectFieldStart("agent");
            for (Map.Entry<String, String> entry : agent.entrySet()) {
                this.generator.writeStringField(entry.getKey(), entry.getValue());
            }
            this.generator.writeEndObject();
        }
        this.generator.writeEndObject();
        return this.getStringFromBufferAndClear();
    }

    ByteBuf createAuth(int channel, String token) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeStringField(FIELD_NAME_TYPE, "AUTH");
        this.generator.writeNumberField(FIELD_NAME_CHANNEL, channel);
        this.generator.writeStringField("token", token);
        this.generator.writeEndObject();
        return this.getStringFromBufferAndClear();
    }

    ByteBuf createKeepalive(int channel) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeStringField(FIELD_NAME_TYPE, "KEEPALIVE");
        this.generator.writeNumberField(FIELD_NAME_CHANNEL, channel);
        this.generator.writeEndObject();
        return this.getStringFromBufferAndClear();
    }

    ByteBuf createChannelRequest(int channel, String service, String contract) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeStringField(FIELD_NAME_TYPE, "CHANNEL_REQUEST");
        this.generator.writeNumberField(FIELD_NAME_CHANNEL, channel);
        this.generator.writeStringField("service", service);
        this.generator.writeObjectFieldStart("parameters");
        this.generator.writeStringField("contract", contract);
        this.generator.writeEndObject();
        this.generator.writeEndObject();
        return this.getStringFromBufferAndClear();
    }

    ByteBuf createFeedSetup(int channel, Long acceptAggregationPeriod, String acceptDataFormat, Map<String, Collection<String>> acceptEventFields) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeStringField(FIELD_NAME_TYPE, "FEED_SETUP");
        this.generator.writeNumberField(FIELD_NAME_CHANNEL, channel);
        if (acceptAggregationPeriod != null) {
            this.generator.writeNumberField("acceptAggregationPeriod", (double)acceptAggregationPeriod.longValue() / 1000.0);
        }
        if (acceptDataFormat != null) {
            this.generator.writeStringField("acceptDataFormat", acceptDataFormat);
        }
        this.generator.writeFieldName("acceptEventFields");
        this.generator.writeStartObject();
        for (Map.Entry<String, Collection<String>> eventType : acceptEventFields.entrySet()) {
            this.generator.writeArrayFieldStart(eventType.getKey());
            for (String s : eventType.getValue()) {
                this.generator.writeString(s);
            }
            this.generator.writeEndArray();
        }
        this.generator.writeEndObject();
        this.generator.writeEndObject();
        return this.getStringFromBufferAndClear();
    }

    ByteBuf createFeedSubscription(int channel, List<DxLinkSubscription> add, List<DxLinkSubscription> remove, Boolean reset) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeStringField(FIELD_NAME_TYPE, "FEED_SUBSCRIPTION");
        this.generator.writeNumberField(FIELD_NAME_CHANNEL, channel);
        this.writeSubscriptions("add", add);
        this.writeSubscriptions("remove", remove);
        if (reset != null) {
            this.generator.writeBooleanField("reset", reset.booleanValue());
        }
        this.generator.writeEndObject();
        return this.getStringFromBufferAndClear();
    }

    private void writeSubscriptions(String nameField, List<DxLinkSubscription> add) throws IOException {
        this.generator.writeArrayFieldStart(nameField);
        for (DxLinkSubscription subscription : add) {
            this.generator.writeStartObject();
            this.generator.writeStringField(FIELD_NAME_TYPE, subscription.type);
            this.generator.writeStringField("symbol", subscription.symbol);
            if (subscription.source != null) {
                this.generator.writeStringField("source", subscription.source);
            } else if (subscription.fromTime != null) {
                this.generator.writeNumberField("fromTime", subscription.fromTime.longValue());
            }
            this.generator.writeEndObject();
        }
        this.generator.writeEndArray();
    }

    private ByteBuf getStringFromBufferAndClear() throws IOException {
        this.generator.flush();
        ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])this.buffer.getBuffer(), (int)0, (int)this.buffer.getPosition());
        this.buffer.clear();
        return byteBuf;
    }
}

