/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.transport;

import com.devexperts.connector.proto.AbstractTransportConnection;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.dxlink.websocket.transport.DxLinkClientWebSocketConnectorMBean;
import com.devexperts.qd.dxlink.websocket.transport.WebSocketTransportConnection;
import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorState;
import com.devexperts.qd.qtp.ReconnectHelper;
import com.devexperts.qd.qtp.help.MessageConnectorProperty;
import com.devexperts.qd.qtp.help.MessageConnectorSummary;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.transport.stats.ConnectionStats;
import com.devexperts.transport.stats.EndpointStats;
import com.devexperts.util.LogUtil;
import com.devexperts.util.SystemProperties;

@MessageConnectorSummary(info="Connects to some host using the dxLink protocol and the WebSocket client.", addressFormat="<ws or wss>://<host>[:<port>]/<path>?<query>")
public class DxLinkClientWebSocketConnector
extends AbstractMessageConnector
implements WebSocketTransportConnection.CloseListener,
DxLinkClientWebSocketConnectorMBean {
    protected String address;
    protected String proxyHost = SystemProperties.getProperty((String)"https.proxyHost", (String)"");
    protected int proxyPort = SystemProperties.getIntProperty((String)"https.proxyPort", (int)80);
    private volatile WebSocketTransportConnection transportConnection;
    private final ReconnectHelper reconnectHelper;

    public DxLinkClientWebSocketConnector(ApplicationConnectionFactory factory, String url) {
        super(factory);
        if (url == null) {
            throw new NullPointerException();
        }
        QDConfig.setDefaultProperties((Object)this, DxLinkClientWebSocketConnectorMBean.class, (String)MessageConnector.class.getName());
        QDConfig.setDefaultProperties((Object)this, DxLinkClientWebSocketConnectorMBean.class, (String)DxLinkClientWebSocketConnector.class.getName());
        this.reconnectHelper = new ReconnectHelper(this.getReconnectDelay());
        this.address = url;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        if (!address.equals(this.address)) {
            this.log.info("Setting address=" + LogUtil.hideCredentials((Object)address));
            this.address = address;
            this.reconfigure();
        }
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    @MessageConnectorProperty(value="HTTP proxy host name")
    public synchronized void setProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.proxyHost)) {
            this.log.info("Setting proxyHost=" + LogUtil.hideCredentials((Object)proxyHost));
            this.proxyHost = proxyHost;
            this.reconfigure();
        }
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    @MessageConnectorProperty(value="HTTP proxy port")
    public synchronized void setProxyPort(int proxyPort) {
        if (proxyPort != this.proxyPort) {
            this.log.info("Setting proxyPort=" + proxyPort);
            this.proxyPort = proxyPort;
            this.reconfigure();
        }
    }

    public void setStats(QDStats stats) {
        super.setStats(stats);
        stats.addMBean("DxLinkClientWebSocketConnector", (Object)this);
    }

    public boolean isActive() {
        return this.transportConnection != null;
    }

    public MessageConnectorState getState() {
        WebSocketTransportConnection handler = this.transportConnection;
        return handler != null ? handler.getHandlerState() : MessageConnectorState.DISCONNECTED;
    }

    public int getConnectionCount() {
        WebSocketTransportConnection handler = this.transportConnection;
        return handler != null && handler.isConnected() ? 1 : 0;
    }

    public EndpointStats retrieveCompleteEndpointStats() {
        ConnectionStats connectionStats;
        EndpointStats stats = super.retrieveCompleteEndpointStats();
        WebSocketTransportConnection handler = this.transportConnection;
        if (handler != null && (connectionStats = handler.getActiveConnectionStats()) != null) {
            stats.addActiveConnectionCount(1L);
            stats.addConnectionStats(connectionStats);
        }
        return stats;
    }

    public synchronized void start() {
        if (this.transportConnection != null || this.isClosed()) {
            return;
        }
        this.log.info("Starting DxLinkClientWebSocketConnector to " + LogUtil.hideCredentials((Object)this.getAddress()));
        if (this.getStats() == null) {
            QDFactory.getDefaultFactory();
            this.setStats(QDFactory.createStats((QDStats.SType)QDStats.SType.CLIENT_SOCKET_CONNECTOR, null));
        }
        this.reconnectHelper.setReconnectDelay(this.getReconnectDelay());
        this.transportConnection = new WebSocketTransportConnection(this, this.address);
        this.transportConnection.setCloseListener(this);
        this.transportConnection.start();
    }

    protected synchronized AbstractMessageConnector.Joinable stopImpl() {
        return this.stopImpl(true);
    }

    protected synchronized void restartImpl(boolean fullStop) {
        this.stopImpl(fullStop);
        this.start();
    }

    @Override
    public synchronized void handlerClosed(AbstractTransportConnection transportConnection) {
        if (transportConnection != this.transportConnection) {
            return;
        }
        this.transportConnection = null;
        this.start();
    }

    private AbstractMessageConnector.Joinable stopImpl(boolean fullStop) {
        if (fullStop) {
            this.reconnectHelper.reset();
        }
        WebSocketTransportConnection transportConnection = this.transportConnection;
        this.transportConnection = null;
        if (transportConnection != null) {
            this.log.info("Stopping DxLinkClientWebSocketConnector");
            transportConnection.close();
        }
        return transportConnection;
    }

    public ReconnectHelper getReconnectHelper() {
        return this.reconnectHelper;
    }
}

