/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.application;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.dxlink.websocket.application.DxLinkSubscription;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.dxfeed.event.market.MarketEventSymbols;

final class DxLinkSubscriptionFactory {
    private static final String SOURCE_SEPARATOR = "#";
    private static final String EXCHANGE_SEPARATOR = "&";
    private static final String DEFAULT_SOURCE = "DEFAULT";

    DxLinkSubscriptionFactory() {
    }

    public DxLinkSubscription createSubscription(QDContract contract, DataRecord record, int cipher, String symbol, long fromTime) {
        int sourceIndex;
        if (contract != QDContract.HISTORY && fromTime != 0L) {
            return null;
        }
        char exchangeCode = MarketEventSymbols.getExchangeCode((String)record.getName());
        boolean isRegionalRecord = exchangeCode != '\u0000';
        symbol = this.decodeSymbol(record, cipher, symbol);
        if (isRegionalRecord) {
            if (this.isWildcardSymbol(symbol)) {
                return null;
            }
            symbol = MarketEventSymbols.changeExchangeCode((String)symbol, (char)exchangeCode);
        }
        int exchangeIndex = isRegionalRecord ? record.getName().lastIndexOf(EXCHANGE_SEPARATOR) : -1;
        int n = sourceIndex = exchangeIndex == -1 ? record.getName().lastIndexOf(SOURCE_SEPARATOR) : -1;
        if (sourceIndex != -1 && fromTime != 0L) {
            return null;
        }
        String eventType = this.extractEventType(record, Math.max(exchangeIndex, sourceIndex));
        return contract == QDContract.HISTORY && (fromTime != 0L || this.isTimeSeriesRecord(record)) ? DxLinkSubscription.createTimeSeriesSubscription(eventType, symbol, this.getEventTimeByQDTime(fromTime)) : DxLinkSubscription.createSubscription(eventType, symbol, this.extractSource(record, sourceIndex));
    }

    private String decodeSymbol(DataRecord record, int cipher, String symbol) {
        return record.getScheme().getCodec().decode(cipher, symbol);
    }

    private String extractEventType(DataRecord record, int separatorIndex) {
        return separatorIndex != -1 ? record.getName().substring(0, separatorIndex) : record.getName();
    }

    private String extractSource(DataRecord record, int sourceIndex) {
        String source = sourceIndex != -1 ? record.getName().substring(sourceIndex + 1) : null;
        return source == null && this.isIndexedRecord(record) ? DEFAULT_SOURCE : source;
    }

    private long getEventTimeByQDTime(long time) {
        return time == Long.MAX_VALUE ? Long.MAX_VALUE : TimeSequenceUtil.getTimeMillisFromTimeSequence((long)time);
    }

    private boolean isWildcardSymbol(String symbol) {
        return "*".equals(symbol);
    }

    private boolean isIndexedRecord(DataRecord record) {
        return record.hasTime() && !this.isTimeBasedSerialType(record.getIntField(0).getSerialType());
    }

    private boolean isTimeSeriesRecord(DataRecord record) {
        return record.hasTime() && this.isTimeBasedSerialType(record.getIntField(0).getSerialType());
    }

    private boolean isTimeBasedSerialType(SerialFieldType type) {
        return type.hasSameSerialTypeAs(SerialFieldType.TIME_SECONDS) || type.hasSameSerialTypeAs(SerialFieldType.TIME_MILLIS) || type.hasSameSerialTypeAs(SerialFieldType.DATE) || type.hasSameSerialTypeAs(SerialFieldType.TIME_NANOS);
    }
}

