/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.dxlink.websocket.application;

import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.io.ChunkList;
import com.devexperts.qd.dxlink.websocket.application.DxLinkWebSocketApplicationConnectionFactory;
import com.devexperts.qd.dxlink.websocket.application.DxLinkWebSocketQTPComposer;
import com.devexperts.qd.dxlink.websocket.application.DxLinkWebSocketQTPParser;
import com.devexperts.qd.dxlink.websocket.application.HeartbeatProcessor;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.MessageConsumer;
import com.devexperts.qd.qtp.MessageListener;
import com.devexperts.qd.qtp.MessageProvider;
import com.devexperts.qd.stats.QDStats;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class DxLinkWebSocketApplicationConnection
extends ApplicationConnection<DxLinkWebSocketApplicationConnectionFactory>
implements MessageListener,
MessageAdapter.CloseListener {
    private final MessageAdapter adapter;
    private final DxLinkWebSocketQTPParser parser;
    private final DxLinkWebSocketQTPComposer composer;
    private final HeartbeatProcessor heartbeatProcessor;
    private volatile long nextHeartbeatTime;
    private volatile long nextDisconnectTime;

    DxLinkWebSocketApplicationConnection(MessageAdapter adapter, DxLinkWebSocketApplicationConnectionFactory factory, TransportConnection transportConnection, DxLinkWebSocketQTPParser parser, DxLinkWebSocketQTPComposer composer, HeartbeatProcessor heartbeatProcessor) {
        super((ApplicationConnectionFactory)factory, transportConnection);
        this.adapter = adapter;
        adapter.setMessageListener((MessageListener)this);
        adapter.setCloseListener((MessageAdapter.CloseListener)this);
        this.heartbeatProcessor = heartbeatProcessor;
        this.parser = parser;
        this.composer = composer;
        this.nextHeartbeatTime = this.heartbeatProcessor.calculateNextHeartbeatTime();
        this.nextDisconnectTime = this.heartbeatProcessor.calculateNextDisconnectTime();
    }

    protected void startImpl() {
        QDStats stats = (QDStats)this.transportConnection.variables().get(MessageConnectors.STATS_KEY);
        if (stats != null) {
            stats.addMBean(QDStats.SType.CONNECTION.getName(), (Object)this.adapter);
            this.composer.setStats(stats);
            this.parser.setStats(stats);
        }
        this.adapter.start();
    }

    protected void closeImpl() {
        this.adapter.close();
    }

    public long examine(long currentTime) {
        if (currentTime >= this.nextDisconnectTime) {
            throw new RuntimeException(this.adapter + " heartbeat timeout exceeded: disconnecting");
        }
        long nextRetrieveTime = Math.min(this.adapter.nextRetrieveTime(currentTime), this.nextHeartbeatTime);
        if (currentTime >= nextRetrieveTime) {
            this.notifyChunksAvailable();
            nextRetrieveTime = currentTime + 10L;
        }
        return Math.min(nextRetrieveTime, this.nextDisconnectTime);
    }

    public ChunkList retrieveChunks(Object owner) {
        throw new IllegalStateException();
    }

    public List<ByteBuf> retrieveMessages() {
        if (this.composer.composeMessage((MessageProvider)this.adapter)) {
            this.notifyChunksAvailable();
        }
        if (System.currentTimeMillis() >= this.nextHeartbeatTime) {
            this.nextHeartbeatTime = this.heartbeatProcessor.calculateNextHeartbeatTime();
            this.composer.composeKeepalive();
        }
        return this.composer.retrieveMessages();
    }

    public boolean processChunks(ChunkList chunks, Object owner) {
        throw new IllegalStateException();
    }

    public void processMessage(String message) {
        this.parser.parse(message, (MessageConsumer)this.adapter);
        this.nextDisconnectTime = this.heartbeatProcessor.calculateNextDisconnectTime();
    }

    public void messagesAvailable(MessageProvider provider) {
        this.notifyChunksAvailable();
    }

    public void adapterClosed(MessageAdapter adapter) {
        if (adapter.isMarkedForImmediateRestart()) {
            this.markForImmediateRestart();
        }
        this.close();
    }
}

