/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common.net;

import com.devexperts.connector.ConnectionAdapter;
import com.devexperts.connector.Connector;
import com.devexperts.mars.common.MARS;
import com.devexperts.mars.common.MARSAgent;
import com.devexperts.mars.common.net.MARSConnectionAdapter;
import java.net.Socket;

public class MARSConnector
extends Connector {
    private final MARS mars;
    private final boolean receive;
    private final boolean send;
    private int read_buffer_limit;

    public MARSConnector(MARS mars, boolean receive, boolean send) {
        this.mars = mars;
        this.receive = receive;
        this.send = send;
        this.setHeartbeatPeriod(60000);
        if (send && !receive) {
            this.setHeartbeatTimeout(21600000);
        } else {
            this.setHeartbeatTimeout(5 * this.getHeartbeatPeriod());
        }
        this.setReconnectionPeriod(10000);
        this.setReadBufferLimit(1000000);
    }

    public int getReadBufferLimit() {
        return this.read_buffer_limit;
    }

    public void setReadBufferLimit(int read_buffer_limit) {
        if (read_buffer_limit < 256) {
            throw new IllegalArgumentException("Read buffer limit is too low.");
        }
        this.read_buffer_limit = read_buffer_limit;
    }

    @Override
    protected ConnectionAdapter createConnectionAdapter(Socket socket) throws Throwable {
        return new MARSConnectionAdapter(this.receive ? this.mars : null, this.send ? new MARSAgent(this.mars) : null, this.read_buffer_limit, socket.getInputStream(), socket.getOutputStream());
    }
}

