/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common.net;

import com.devexperts.logging.Logging;
import com.devexperts.mars.common.MARSEvent;
import com.devexperts.mars.common.MARSEventFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MARSBuffer {
    private static final Logging log = Logging.getLogging(MARSBuffer.class);
    private char[] buffer;
    private int size;
    private final MARSEventFactory marsEventFactory = MARSEventFactory.getInstance();

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size < 0 || size > (this.buffer == null ? 0 : this.buffer.length)) {
            throw new IllegalArgumentException("Size is out of limits.");
        }
        this.size = size;
    }

    public void ensureCapacity(int required_capacity) {
        int capacity;
        int n = capacity = this.buffer == null ? 0 : this.buffer.length;
        if (required_capacity <= capacity) {
            return;
        }
        int new_capacity = Math.max(Math.max(1024, capacity << 1), required_capacity);
        char[] new_buffer = new char[new_capacity];
        if (this.buffer != null && capacity > 0) {
            System.arraycopy(this.buffer, 0, new_buffer, 0, capacity);
        }
        this.buffer = new_buffer;
    }

    public void clear() {
        this.size = 0;
    }

    public void removeChars(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0) {
            return;
        }
        System.arraycopy(this.buffer, n, this.buffer, 0, this.size - n);
        this.size -= n;
    }

    public void writeString(String s) {
        int length = s.length();
        this.ensureCapacity(this.size + length);
        s.getChars(0, length, this.buffer, this.size);
        this.size += length;
    }

    public void writeChars(char[] chars, int offset, int length) {
        if (offset < 0 || offset > chars.length || length < 0 || length > chars.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + length);
        System.arraycopy(chars, offset, this.buffer, this.size, length);
        this.size += length;
    }

    public Collection<MARSEvent> readEvents() {
        ArrayList<MARSEvent> events = null;
        int parsed = 0;
        int crlf = this.indexOfCRLF(parsed);
        while (crlf >= parsed) {
            block11: {
                try {
                    int count;
                    int assignment;
                    if (crlf - parsed <= 1 || (assignment = this.indexOfSign(parsed, '=')) < parsed || assignment >= crlf) break block11;
                    int timestampSeparator = this.indexOfSign(parsed, '|');
                    String name = this.trimString(parsed, assignment);
                    long timestamp = -1L;
                    String value = "";
                    if (timestampSeparator >= 0 && timestampSeparator < crlf && (count = timestampSeparator - 1 - assignment) >= 0) {
                        try {
                            String timestampString = new String(this.buffer, assignment + 1, count);
                            timestamp = Long.parseLong(timestampString);
                            value = this.trimString(timestampSeparator + 1, crlf);
                        }
                        catch (IndexOutOfBoundsException e) {
                            timestamp = -1L;
                        }
                        catch (NumberFormatException e) {
                            timestamp = -1L;
                        }
                    }
                    if (!name.isEmpty()) {
                        if (events == null) {
                            events = new ArrayList<MARSEvent>();
                        }
                        if (timestamp < 0L) {
                            value = this.trimString(assignment + 1, crlf);
                            events.add(this.marsEventFactory.createMARSEvent(name, value));
                        } else {
                            events.add(this.marsEventFactory.createMARSEvent(name, value, timestamp));
                        }
                    }
                }
                catch (Exception e) {
                    log.error("readEvents() crlf=" + crlf + " parsed=" + parsed, (Throwable)e);
                }
            }
            parsed = crlf + 1;
            crlf = this.indexOfCRLF(parsed);
        }
        this.removeChars(parsed);
        return events == null ? Collections.EMPTY_LIST : events;
    }

    public void writeEvents(Collection<MARSEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        for (MARSEvent event : events) {
            this.writeString(event.getName());
            this.writeString("=");
            if (event.getTimestamp() != 0L) {
                this.writeString(event.getTimestamp() + "|");
            }
            this.writeString(event.getValue());
            this.writeString("\r\n");
        }
    }

    private int indexOfCRLF(int from_index) {
        while (from_index < this.size) {
            if (this.buffer[from_index] == '\n' || this.buffer[from_index] == '\r') {
                return from_index;
            }
            ++from_index;
        }
        return -1;
    }

    private int indexOfSign(int from_index, char sign) {
        while (from_index < this.size) {
            if (this.buffer[from_index] == sign) {
                return from_index;
            }
            ++from_index;
        }
        return -1;
    }

    private String trimString(int from_index, int to_index) {
        while (from_index < to_index && this.buffer[from_index] <= ' ') {
            ++from_index;
        }
        while (from_index < to_index && this.buffer[to_index - 1] <= ' ') {
            --to_index;
        }
        return from_index == to_index ? "" : new String(this.buffer, from_index, to_index - from_index);
    }
}

