/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector;

import com.devexperts.connector.Connector;
import com.devexperts.connector.SocketAddress;
import com.devexperts.connector.SocketController;
import com.devexperts.connector.SocketHandler;
import com.devexperts.util.LogUtil;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class SocketAcceptor
extends SocketController {
    private final SocketAddress address;
    private final Set<SocketHandler> handlers = new HashSet<SocketHandler>();
    private ServerSocket server_socket;

    SocketAcceptor(Connector connector, String address) throws ParseException {
        super(connector);
        this.address = SocketAddress.valueOf(address);
        if (this.address.getHost().length() != 0) {
            throw new ParseException("Host name is present.", 0);
        }
    }

    public String toString() {
        return "SocketAcceptor-" + LogUtil.hideCredentials((Object)this.address) + ": " + STATE_NAMES[this.state];
    }

    @Override
    synchronized void start() {
        if (this.state == 3) {
            return;
        }
        if (this.state != 0) {
            throw new IllegalStateException("Acceptor may be started only once.");
        }
        this.state = 1;
        this.createNewSocket();
    }

    private synchronized boolean isClosed() {
        return this.state == 3;
    }

    private synchronized boolean makeClosed() {
        if (this.state == 3) {
            return false;
        }
        this.state = 3;
        Iterator<SocketHandler> it = this.handlers.iterator();
        while (it.hasNext()) {
            SocketHandler handler = it.next();
            it.remove();
            handler.close();
        }
        return true;
    }

    @Override
    void close() {
        if (!this.makeClosed()) {
            return;
        }
        this.cleanup(this.server_socket);
    }

    @Override
    synchronized void handlerClosed(SocketHandler handler) {
        this.handlers.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Socket acquireSocket() {
        if (!this.ensureConnected()) {
            return null;
        }
        while (!Thread.interrupted()) {
            try {
                SocketAcceptor socketAcceptor = this;
                synchronized (socketAcceptor) {
                    if (this.state == 3) {
                        return null;
                    }
                }
                Socket socket = this.server_socket.accept();
                SocketAcceptor socketAcceptor2 = this;
                synchronized (socketAcceptor2) {
                    this.createNewSocket();
                }
                this.connector.log("Connection accepted " + LogUtil.hideCredentials((Object)this.connector.getSocketAddress(socket)), null, null);
                return socket;
            }
            catch (SocketException e) {
                if (this.isClosed()) continue;
                if ("socket closed".equalsIgnoreCase(e.getMessage())) {
                    this.connector.log("Accepting failed " + LogUtil.hideCredentials((Object)this.address), e, false, null);
                    continue;
                }
                this.connector.log("Accepting failed " + LogUtil.hideCredentials((Object)this.address), e, null);
            }
            catch (Throwable t) {
                this.connector.log("Accepting failed " + LogUtil.hideCredentials((Object)this.address), t, null);
            }
        }
        return null;
    }

    private void createNewSocket() {
        SocketHandler handler = this.createNewSocket(this.address.getAddress());
        this.handlers.add(handler);
        handler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ensureConnected() {
        is_reconnection = false;
        while (true) {
            if (Thread.interrupted()) {
                return false;
            }
            var2_2 = this;
            synchronized (var2_2) {
                if (this.state == 3) {
                    return false;
                }
                if (this.state == 2) {
                    return true;
                }
            }
            server_socket = null;
            connected = false;
            error = null;
            if (is_reconnection) {
                Thread.sleep(this.connector.getSkewedPeriod(this.connector.getReconnectionPeriod()));
            }
            is_reconnection = true;
            this.connector.log("Listening " + LogUtil.hideCredentials((Object)this.address), null, null);
            bindAddress = this.address.getBind() == null || this.address.getBind().isEmpty() != false ? null : InetAddress.getByName(this.address.getBind());
            server_socket = new ServerSocket(this.address.getPort(), 50, bindAddress);
            var6_7 = this;
            synchronized (var6_7) {
                if (this.state == 3) {
                    var7_8 = false;
                    // MONITOREXIT @DISABLED, blocks:[1, 7, 11, 14] lbl28 : MonitorExitStatement: MONITOREXIT : var6_7
                    if (!connected) {
                        this.cleanup(server_socket);
                        this.connector.log("Listening failed " + LogUtil.hideCredentials((Object)this.address), error, null);
                    }
                    return var7_8;
                }
                this.state = 2;
                this.server_socket = server_socket;
                connected = true;
                var7_9 = true;
                ** if (connected) goto lbl37
            }
lbl-1000:
            // 1 sources

            {
                this.cleanup(server_socket);
                this.connector.log("Listening failed " + LogUtil.hideCredentials((Object)this.address), error, null);
            }
lbl37:
            // 2 sources

            return var7_9;
            {
                catch (Throwable t) {
                    error = t;
                    continue;
                }
            }
            finally {
                if (connected) continue;
                this.cleanup(server_socket);
                this.connector.log("Listening failed " + LogUtil.hideCredentials((Object)this.address), error, null);
                continue;
            }
            break;
        }
    }

    private void cleanup(ServerSocket server_socket) {
        if (server_socket != null) {
            try {
                server_socket.close();
            }
            catch (Throwable t) {
                this.connector.log("Cleanup failed " + LogUtil.hideCredentials((Object)this.address), t, null);
            }
        }
    }
}

