/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.jvm;

import com.devexperts.logging.Logging;
import com.devexperts.management.Management;
import com.devexperts.mars.common.MARSEndpoint;
import com.devexperts.mars.common.MARSNode;
import com.devexperts.mars.common.MARSPlugin;
import com.devexperts.mars.common.MARSScheduler;
import com.devexperts.mars.jvm.CpuCounter;
import com.devexperts.mars.jvm.JVMSelfMonitoringMXBean;
import com.devexperts.mars.jvm.ThreadDumper;
import com.devexperts.services.ServiceProvider;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimePeriod;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class JVMSelfMonitoring
implements MARSPlugin,
Runnable,
JVMSelfMonitoringMXBean {
    private static final String MBEAN_NAME = "com.devexperts.mars:type=JVMSelfMonitoring";
    private static final long FIND_DEADLOCK_PERIOD = SystemProperties.getLongProperty(JVMSelfMonitoring.class, (String)"findDeadlockPeriod", (long)10L) * 1000L;
    private static final int THREAD_DUMPS_COUNT = SystemProperties.getIntProperty(JVMSelfMonitoring.class, (String)"threadDumpsCount", (int)0);
    private static final String THREAD_DUMPS_FILE = SystemProperties.getProperty(JVMSelfMonitoring.class, (String)"threadDumpsFile", (String)"");
    private static final TimePeriod THREAD_DUMPS_PERIOD = TimePeriod.valueOf((String)SystemProperties.getProperty(JVMSelfMonitoring.class, (String)"threadDumpsPeriod", (String)"1s"));
    private static final long THREAD_DUMPS_SCHEDULED_AT = TimeFormat.DEFAULT.parse(SystemProperties.getProperty(JVMSelfMonitoring.class, (String)"threadDumpsScheduledAt", (String)"0")).getTime();
    private static final int STATE_NEW = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_STOPPED = 2;
    private static final Set<String> CONCURRENT_GCS = new HashSet<String>(Arrays.asList("G1 Concurrent GC", "Shenandoah Cycles", "ZGC Cycles", "ZGC Minor Cycles", "ZGC Major Cycles"));
    private int state = 0;
    private Management.Registration registration;
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final MARSNode root;
    private final MARSNode uptimeNode;
    private final MARSNode cpuTimeNode;
    private final MARSNode cpuUsageNode;
    private final MARSNode memHeapMaxNode;
    private final MARSNode memHeapSizeNode;
    private final MARSNode memHeapUsedNode;
    private final MARSNode memHeapUsageNode;
    private final MARSNode memNonHeapMaxNode;
    private final MARSNode memNonHeapSizeNode;
    private final MARSNode memNonHeapUsedNode;
    private final MARSNode memNonHeapUsageNode;
    private final MARSNode threadsCurrentNode;
    private final MARSNode threadsPeakNode;
    private final MARSNode threadsDeadlockedNode;
    private final MARSNode gcTimeNode;
    private final MARSNode gcRatioNode;
    private final MARSNode gcAverageNode;
    private final CpuCounter cpu = new CpuCounter();
    private final Map<String, GCBean> gcBeans = new HashMap<String, GCBean>();
    private final long[] lastGCReports = new long[62];
    private long lastCollectionTime;
    private long lastReportingTime = System.currentTimeMillis();
    private long lastFindDeadlockTime;
    private int threadDumpsCount = THREAD_DUMPS_COUNT;
    private String threadDumpsFile = THREAD_DUMPS_FILE;
    private TimePeriod threadDumpsPeriod = THREAD_DUMPS_PERIOD;
    private long threadDumpsScheduledAt = THREAD_DUMPS_SCHEDULED_AT;
    private ThreadDumper threadDumper;

    public JVMSelfMonitoring(MARSNode root) {
        this.root = root;
        root.subNode("jvm").setValue(System.getProperty("java.vm.name") + " " + System.getProperty("java.version"));
        root.subNode("jvm.props.OS").setValue(SystemProperties.getProperty((String)"os.name", (String)"<unknown>") + " " + SystemProperties.getProperty((String)"os.version", (String)"<unknown>") + " " + SystemProperties.getProperty((String)"os.arch", (String)"<unknown>"));
        root.subNode("jvm.props.dir").setValue(SystemProperties.getProperty((String)"user.dir", (String)""));
        root.subNode("jvm.props.java").setValue(SystemProperties.getProperty((String)"java.vm.name", (String)"<unknown>") + " " + SystemProperties.getProperty((String)"java.version", (String)"<unknown>") + ", home " + SystemProperties.getProperty((String)"java.home", (String)"<unknown>"));
        root.subNode("jvm.props.startTime").setTimeValue(this.runtimeMXBean.getStartTime());
        root.subNode("jvm.props.timezone").setValue(TimeZone.getDefault().getID());
        try {
            root.subNode("jvm.props.host").setValue(InetAddress.getLocalHost().toString());
        }
        catch (Exception e) {
            JVMSelfMonitoring.log().warn("Cannot get host address: " + e);
        }
        this.uptimeNode = root.subNode("jvm.uptime", "Uptime in days, hours, mins, secs.");
        this.cpuTimeNode = root.subNode("jvm.cpu.time", "The amount of consumed CPU time.");
        this.cpuUsageNode = root.subNode("jvm.cpu.usage", "CPU consumption as percent of total CPU capacity, %.");
        this.memHeapMaxNode = root.subNode("jvm.mem.heap_max", "Configured maximum heap size, Kb.");
        this.memHeapSizeNode = root.subNode("jvm.mem.heap_size", "The amount of allocated heap memory, Kb.");
        this.memHeapUsedNode = root.subNode("jvm.mem.heap_used", "The amount of used heap memory, Kb.");
        this.memHeapUsageNode = root.subNode("jvm.mem.heap_usage", "The amount of used heap memory as percent of maximum heap size, %.");
        this.memNonHeapMaxNode = root.subNode("jvm.mem.non-heap_max", "Configured maximum non-heap size, Kb.");
        this.memNonHeapSizeNode = root.subNode("jvm.mem.non-heap_size", "The amount of allocated non-heap memory, Kb.");
        this.memNonHeapUsedNode = root.subNode("jvm.mem.non-heap_used", "The amount of used non-heap memory, Kb.");
        this.memNonHeapUsageNode = root.subNode("jvm.mem.non-heap_usage", "The amount of used non-heap memory as percent of maximum non-heap size, %.");
        this.threadsCurrentNode = root.subNode("jvm.threads.current", "The current number of live threads.");
        this.threadsPeakNode = root.subNode("jvm.threads.peak", "The peak live thread count since the JVM started or peak was reset.");
        this.threadsDeadlockedNode = root.subNode("jvm.threads.deadlocked", "The current number of deadlocked threads.");
        this.gcTimeNode = root.subNode("jvm.GC.time", "Net accumulated paused GC time.");
        this.gcRatioNode = root.subNode("jvm.GC.ratio", "Net ratio of time spent in paused GCs, %.");
        this.gcAverageNode = root.subNode("jvm.GC.average_5min", "Net ratio of time spent in paused GCs during last 5 minutes, %.");
    }

    @Override
    public synchronized void start() {
        if (this.state == 1) {
            return;
        }
        this.state = 1;
        this.registration = Management.registerMBean((Object)this, JVMSelfMonitoringMXBean.class, (String)MBEAN_NAME);
        MARSScheduler.schedule(this);
        this.run();
        this.checkThreadDumper();
    }

    @Override
    public synchronized void stop() {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        this.registration.unregister();
        MARSScheduler.cancel(this);
        this.cpu.close();
        this.checkThreadDumper();
    }

    private void checkThreadDumper() {
        if (!(this.threadDumper == null || this.threadDumpsCount > 0 && this.state == 1 && this.threadDumper.getFile().equals(this.threadDumpsFile))) {
            this.threadDumper.interrupt();
            this.threadDumper = null;
        }
        if (this.threadDumper == null && this.threadDumpsCount > 0 && this.state == 1) {
            this.threadDumper = new ThreadDumper(this, this.threadDumpsFile);
            this.threadDumper.start();
        }
    }

    synchronized long getThreadDumpsPeriodTime() {
        return this.threadDumpsPeriod.getTime();
    }

    synchronized long getThreadDumpsScheduledAtTime() {
        return this.threadDumpsScheduledAt;
    }

    synchronized void threadDumperTerminated(ThreadDumper threadDumper) {
        if (threadDumper == this.threadDumper) {
            this.threadDumper = null;
            this.checkThreadDumper();
        }
    }

    synchronized void countThreadDump() {
        if (this.threadDumpsCount > 0) {
            --this.threadDumpsCount;
        }
    }

    ThreadMXBean getThreadMXBean() {
        return this.threadMXBean;
    }

    @Override
    public void run() {
        block4: {
            block5: {
                long currentTime = System.currentTimeMillis();
                this.uptimeNode.setValue(JVMSelfMonitoring.timeToString(this.runtimeMXBean.getUptime() / 1000L));
                this.cpuTimeNode.setValue(JVMSelfMonitoring.timeToString(this.cpu.getCpuTime() / 1000000000L));
                this.cpuUsageNode.setDoubleValue((double)((long)(this.cpu.getCpuUsage() * 10000.0)) / 100.0);
                JVMSelfMonitoring.setMemoryUsage(this.memoryMXBean.getHeapMemoryUsage(), this.memHeapMaxNode, this.memHeapSizeNode, this.memHeapUsedNode, this.memHeapUsageNode);
                JVMSelfMonitoring.setMemoryUsage(this.memoryMXBean.getNonHeapMemoryUsage(), this.memNonHeapMaxNode, this.memNonHeapSizeNode, this.memNonHeapUsedNode, this.memNonHeapUsageNode);
                this.threadsCurrentNode.setIntValue(this.threadMXBean.getThreadCount());
                this.threadsPeakNode.setIntValue(this.threadMXBean.getPeakThreadCount());
                if (FIND_DEADLOCK_PERIOD > 0L && currentTime >= this.lastFindDeadlockTime + FIND_DEADLOCK_PERIOD) {
                    this.threadsDeadlockedNode.setIntValue(this.getThreadDeadlockedCount());
                    this.lastFindDeadlockTime = currentTime;
                }
                long delta = 0L;
                long interval = currentTime - this.lastReportingTime;
                for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                    String gcName = gc.getName();
                    if (CONCURRENT_GCS.contains(gcName)) continue;
                    GCBean bean = this.gcBeans.computeIfAbsent(gcName, k -> new GCBean(gc, this.root));
                    delta += bean.update(gc, interval);
                }
                this.lastCollectionTime += delta;
                this.lastReportingTime += interval;
                this.gcTimeNode.setValue(JVMSelfMonitoring.timeToString(this.lastCollectionTime / 1000L));
                this.gcRatioNode.setDoubleValue(interval <= 0L ? 0.0 : (double)(delta * 10000L / interval) / 100.0);
                if (interval >= 0L) break block5;
                for (int i = 0; i < this.lastGCReports.length; i += 2) {
                    if (this.lastGCReports[i + 1] == 0L) continue;
                    int n = i + 1;
                    this.lastGCReports[n] = this.lastGCReports[n] + interval;
                }
                break block4;
            }
            if (this.lastReportingTime < this.lastGCReports[this.lastGCReports.length - 1] + 9900L) break block4;
            System.arraycopy(this.lastGCReports, 2, this.lastGCReports, 0, this.lastGCReports.length - 2);
            this.lastGCReports[this.lastGCReports.length - 2] = this.lastCollectionTime;
            this.lastGCReports[this.lastGCReports.length - 1] = this.lastReportingTime;
            for (int i = 0; i < this.lastGCReports.length - 2; i += 2) {
                if (this.lastGCReports[i + 1] == 0L || this.lastGCReports[i + 3] <= this.lastReportingTime - 300000L) continue;
                this.gcAverageNode.setDoubleValue((double)((this.lastCollectionTime - this.lastGCReports[i]) * 10000L / (this.lastReportingTime - this.lastGCReports[i + 1])) / 100.0);
                break;
            }
        }
    }

    static String timeToString(long seconds) {
        StringBuilder sb = new StringBuilder(32);
        JVMSelfMonitoring.append(sb, seconds / 86400L, " days ");
        JVMSelfMonitoring.append(sb, seconds % 86400L / 3600L, " hours ");
        JVMSelfMonitoring.append(sb, seconds % 3600L / 60L, " min ");
        sb.append(seconds % 60L).append(" sec");
        return sb.toString();
    }

    private static void append(StringBuilder sb, long v, String s) {
        if (v > 0L) {
            sb.append(v).append(s);
        }
    }

    private static void setMemoryUsage(MemoryUsage memory, MARSNode maxNode, MARSNode sizeNode, MARSNode usedNode, MARSNode usageNode) {
        maxNode.setDoubleValue(memory.getMax() >> 10);
        sizeNode.setDoubleValue(memory.getCommitted() >> 10);
        usedNode.setDoubleValue(memory.getUsed() >> 10);
        usageNode.setDoubleValue(JVMSelfMonitoring.getUsage(memory));
    }

    private static double getUsage(MemoryUsage memory) {
        long maxMemory = Math.max(memory.getMax(), memory.getCommitted());
        if (maxMemory <= 0L) {
            return 100.0;
        }
        return (double)(memory.getUsed() * 10000L / maxMemory) / 100.0;
    }

    private static String getUsageString(MemoryUsage memory) {
        return JVMSelfMonitoring.getUsage(memory) + "%: " + (memory.getUsed() >> 20) + "M of " + (Math.max(memory.getMax(), memory.getCommitted()) >> 20) + "M";
    }

    private static Logging log() {
        return Logging.getLogging(JVMSelfMonitoring.class);
    }

    @Override
    public String getUptime() {
        return this.uptimeNode.getValue() + " (cpuTime = " + this.cpuTimeNode.getValue() + ")";
    }

    @Override
    public String getCpuUsage() {
        return this.cpuUsageNode.getValue() + "%";
    }

    @Override
    public String getHeapSize() {
        return (this.memoryMXBean.getHeapMemoryUsage().getCommitted() >> 20) + "M";
    }

    @Override
    public String getHeapUsage() {
        return JVMSelfMonitoring.getUsageString(this.memoryMXBean.getHeapMemoryUsage());
    }

    @Override
    public String getNonHeapSize() {
        return (this.memoryMXBean.getNonHeapMemoryUsage().getCommitted() >> 20) + "M";
    }

    @Override
    public String getNonHeapUsage() {
        return JVMSelfMonitoring.getUsageString(this.memoryMXBean.getNonHeapMemoryUsage());
    }

    @Override
    public String getThreadCount() {
        return this.threadMXBean.getThreadCount() + " (peak = " + this.threadMXBean.getPeakThreadCount() + ")";
    }

    @Override
    public int getThreadDeadlockedCount() {
        try {
            long[] t = this.threadMXBean.findMonitorDeadlockedThreads();
            return t == null ? 0 : t.length;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    @Override
    public String getTimeZone() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getID() + " (" + tz.getDisplayName() + ")";
    }

    @Override
    public synchronized int getThreadDumpsCount() {
        return this.threadDumpsCount;
    }

    @Override
    public synchronized String getThreadDumpsFile() {
        return this.threadDumpsFile;
    }

    @Override
    public synchronized String getThreadDumpsPeriod() {
        return this.threadDumpsPeriod.toString();
    }

    @Override
    public synchronized String getThreadDumpsScheduledAt() {
        return this.threadDumpsScheduledAt == 0L ? "" : TimeFormat.DEFAULT.format(this.threadDumpsScheduledAt);
    }

    @Override
    public synchronized void makeThreadDumps(int count, String file, String period, String scheduledAt) {
        if (period != null && period.length() > 0) {
            this.threadDumpsPeriod = TimePeriod.valueOf((String)period);
        }
        this.threadDumpsCount = count;
        this.threadDumpsFile = file == null ? "" : file;
        this.threadDumpsScheduledAt = scheduledAt == null || scheduledAt.isEmpty() ? 0L : TimeFormat.DEFAULT.parse(scheduledAt).getTime();
        this.checkThreadDumper();
    }

    @Override
    public void forceGarbageCollection() {
        System.gc();
    }

    @Override
    public String toString() {
        return "JVM self-monitoring";
    }

    @ServiceProvider
    public static class PluginFactory
    extends MARSPlugin.Factory {
        @Override
        public MARSPlugin createPlugin(MARSEndpoint marsEndpoint) {
            return new JVMSelfMonitoring(marsEndpoint.getRoot());
        }
    }

    private static class GCBean {
        private final MARSNode countNode;
        private final MARSNode timeNode;
        private final MARSNode ratioNode;
        private long lastCollectionTime;

        GCBean(GarbageCollectorMXBean gc, MARSNode root) {
            this.countNode = root.subNode("jvm.GC." + gc.getName() + ".count", "Total number of GCs that have occurred.");
            this.timeNode = root.subNode("jvm.GC." + gc.getName() + ".time", "Approximate accumulated GC elapsed time.");
            this.ratioNode = root.subNode("jvm.GC." + gc.getName() + ".ratio", "Ratio of time spent in GC, %.");
        }

        long update(GarbageCollectorMXBean gc, long interval) {
            long delta = gc.getCollectionTime() - this.lastCollectionTime;
            this.lastCollectionTime += delta;
            this.countNode.setDoubleValue(gc.getCollectionCount());
            this.timeNode.setValue(JVMSelfMonitoring.timeToString(this.lastCollectionTime / 1000L));
            this.ratioNode.setDoubleValue(interval <= 0L ? 0.0 : (double)(delta * 10000L / interval) / 100.0);
            return delta;
        }
    }
}

