/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.connector;

import com.devexperts.connector.Connector;
import com.devexperts.connector.SocketAddress;
import com.devexperts.connector.SocketController;
import com.devexperts.connector.SocketHandler;
import com.devexperts.util.TimeFormat;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;

class SocketConnector
extends SocketController {
    private final String address;
    private final Set<SocketAddress> parsed_addresses = new HashSet<SocketAddress>();
    private final Random random = new Random();
    private final List<SocketAddress> resolved_addresses = new ArrayList<SocketAddress>();
    private int current_address;
    private SocketHandler handler;
    private long next_attempt_time;
    private String prevConnectStatus;
    private long prevConnectStatusTime;
    private long prevConnectStatusNumber;
    private String prevResolveStatus;
    private long prevResolveStatusTime;
    private long prevResolveStatusNumber;

    SocketConnector(Connector connector, String address) throws ParseException {
        super(connector);
        this.address = address;
        StringTokenizer st = new StringTokenizer(address, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            SocketAddress sa = SocketAddress.valueOf(s);
            if (sa.getHost().isEmpty()) {
                throw new ParseException("Host name is missing.", 0);
            }
            this.parsed_addresses.add(sa);
        }
        if (this.parsed_addresses.isEmpty()) {
            throw new ParseException("No addresses found.", 0);
        }
    }

    public String toString() {
        return "SocketConnector-" + this.address + ": " + STATE_NAMES[this.state];
    }

    @Override
    synchronized void start() {
        if (this.state == 3) {
            return;
        }
        if (this.state != 0) {
            throw new IllegalStateException("Connector may be started only once.");
        }
        this.state = 1;
        this.handler = this.createNewSocket(this.address);
        this.handler.start();
    }

    @Override
    synchronized void close() {
        if (this.state == 3) {
            return;
        }
        this.state = 3;
        if (this.handler != null) {
            this.handler.close();
        }
        this.handler = null;
    }

    @Override
    synchronized void handlerClosed(SocketHandler handler) {
        if (this.state == 3) {
            return;
        }
        if (handler != this.handler) {
            return;
        }
        this.state = 1;
        this.handler = this.createNewSocket(this.address);
        this.handler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Socket acquireSocket() {
        String curConnectStatus;
        Object object;
        long time = System.currentTimeMillis();
        if (time < this.next_attempt_time) {
            try {
                Thread.sleep(this.next_attempt_time - time);
                time = System.currentTimeMillis();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        this.next_attempt_time = time + (long)this.connector.getSkewedPeriod(this.connector.getReconnectionPeriod());
        ++this.current_address;
        if (this.current_address >= this.resolved_addresses.size()) {
            this.resolveAddresses();
            this.current_address = 0;
            if (this.resolved_addresses.isEmpty()) {
                return null;
            }
        }
        SocketAddress address = this.resolved_addresses.get(this.current_address);
        StringBuilder connectingMsgBuf = new StringBuilder().append("connecting... ");
        Throwable throwable = null;
        String connectorState = null;
        try {
            Socket socket = new Socket(address.getHost(), address.getPort());
            object = this;
            synchronized (object) {
                if (this.state == 1) {
                    this.state = 2;
                }
            }
            connectingMsgBuf.append("established");
            connectorState = "ESTABLISHED";
            object = socket;
            curConnectStatus = connectingMsgBuf.toString();
        }
        catch (Throwable t) {
            String curConnectStatus2;
            Socket socket;
            try {
                throwable = t;
                connectingMsgBuf.append("failed");
                socket = null;
                curConnectStatus2 = connectingMsgBuf.toString();
            }
            catch (Throwable throwable2) {
                String curConnectStatus3 = connectingMsgBuf.toString();
                long curTime = System.currentTimeMillis();
                boolean isEqual = curConnectStatus3.equals(this.prevConnectStatus);
                if (isEqual && curTime - this.prevConnectStatusTime < 120000L) {
                    ++this.prevConnectStatusNumber;
                } else {
                    if (this.prevConnectStatusNumber != 0L) {
                        StringBuilder buf = new StringBuilder(curConnectStatus3.length() + 50);
                        buf.append('[');
                        if (isEqual) {
                            buf.append(this.prevConnectStatusNumber + 1L).append(" msg, address=").append(address).append(']');
                            this.connector.log(buf.append(this.prevConnectStatus).toString(), throwable, !this.isStandardState(throwable), null);
                        } else {
                            buf.append(this.prevConnectStatusNumber).append(" msg, address=").append(address).append(", last=").append(TimeFormat.DEFAULT.withMillis().format(this.prevConnectStatusTime)).append(']');
                            this.connector.log(buf.append(this.prevConnectStatus).toString(), null, null);
                            this.connector.log(curConnectStatus3, throwable, !this.isStandardState(throwable), connectorState);
                        }
                        this.prevConnectStatusNumber = 0L;
                    } else {
                        this.connector.log(curConnectStatus3, throwable, !this.isStandardState(throwable), connectorState);
                    }
                    this.prevConnectStatusTime = curTime;
                    this.prevConnectStatus = curConnectStatus3;
                }
                throw throwable2;
            }
            long curTime = System.currentTimeMillis();
            boolean isEqual = curConnectStatus2.equals(this.prevConnectStatus);
            if (isEqual && curTime - this.prevConnectStatusTime < 120000L) {
                ++this.prevConnectStatusNumber;
            } else {
                if (this.prevConnectStatusNumber != 0L) {
                    StringBuilder buf = new StringBuilder(curConnectStatus2.length() + 50);
                    buf.append('[');
                    if (isEqual) {
                        buf.append(this.prevConnectStatusNumber + 1L).append(" msg, address=").append(address).append(']');
                        this.connector.log(buf.append(this.prevConnectStatus).toString(), throwable, !this.isStandardState(throwable), null);
                    } else {
                        buf.append(this.prevConnectStatusNumber).append(" msg, address=").append(address).append(", last=").append(TimeFormat.DEFAULT.withMillis().format(this.prevConnectStatusTime)).append(']');
                        this.connector.log(buf.append(this.prevConnectStatus).toString(), null, null);
                        this.connector.log(curConnectStatus2, throwable, !this.isStandardState(throwable), connectorState);
                    }
                    this.prevConnectStatusNumber = 0L;
                } else {
                    this.connector.log(curConnectStatus2, throwable, !this.isStandardState(throwable), connectorState);
                }
                this.prevConnectStatusTime = curTime;
                this.prevConnectStatus = curConnectStatus2;
            }
            return socket;
        }
        long curTime = System.currentTimeMillis();
        boolean isEqual = curConnectStatus.equals(this.prevConnectStatus);
        if (isEqual && curTime - this.prevConnectStatusTime < 120000L) {
            ++this.prevConnectStatusNumber;
        } else {
            if (this.prevConnectStatusNumber != 0L) {
                StringBuilder buf = new StringBuilder(curConnectStatus.length() + 50);
                buf.append('[');
                if (isEqual) {
                    buf.append(this.prevConnectStatusNumber + 1L).append(" msg, address=").append(address).append(']');
                    this.connector.log(buf.append(this.prevConnectStatus).toString(), throwable, !this.isStandardState(throwable), null);
                } else {
                    buf.append(this.prevConnectStatusNumber).append(" msg, address=").append(address).append(", last=").append(TimeFormat.DEFAULT.withMillis().format(this.prevConnectStatusTime)).append(']');
                    this.connector.log(buf.append(this.prevConnectStatus).toString(), null, null);
                    this.connector.log(curConnectStatus, throwable, !this.isStandardState(throwable), connectorState);
                }
                this.prevConnectStatusNumber = 0L;
            } else {
                this.connector.log(curConnectStatus, throwable, !this.isStandardState(throwable), connectorState);
            }
            this.prevConnectStatusTime = curTime;
            this.prevConnectStatus = curConnectStatus;
        }
        return object;
    }

    private boolean isStandardState(Throwable t) {
        if (t == null) {
            return true;
        }
        String message = t.getMessage();
        return message.contains("refused") || message.contains("timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAddresses() {
        HashSet<SocketAddress> addresses = new HashSet<SocketAddress>();
        for (SocketAddress address : this.parsed_addresses) {
            StringBuilder resolvingMsgBuf = new StringBuilder().append("Resolving ").append(address.getHost());
            UnknownHostException exception = null;
            try {
                InetAddress[] addrs = InetAddress.getAllByName(address.getHost());
                for (int i = 0; i < addrs.length; ++i) {
                    addresses.add(new SocketAddress(address.getSpec(), addrs[i].getHostAddress(), address.getPort()));
                }
            }
            catch (UnknownHostException e) {
                exception = e;
                resolvingMsgBuf.append("... FAILED");
            }
            finally {
                String curResolveStatus = resolvingMsgBuf.toString();
                long curTime = System.currentTimeMillis();
                if (exception == null) continue;
                boolean isEqual = curResolveStatus.equals(this.prevResolveStatus);
                if (isEqual && curTime - this.prevResolveStatusTime < 120000L) {
                    ++this.prevResolveStatusNumber;
                    continue;
                }
                if (this.prevResolveStatusNumber != 0L) {
                    StringBuilder buf = new StringBuilder(curResolveStatus.length() + 50);
                    buf.append('[');
                    if (isEqual) {
                        buf.append(this.prevResolveStatusNumber + 1L).append(" msg]");
                        this.connector.log(buf.append(this.prevResolveStatus).toString(), exception, null);
                    } else {
                        buf.append(this.prevResolveStatusNumber).append(" msg, LAST=").append(TimeFormat.DEFAULT.withMillis().format(this.prevResolveStatusTime)).append(']');
                        this.connector.log(buf.append(this.prevResolveStatus).toString(), null, null);
                        this.connector.log(curResolveStatus, exception, null);
                    }
                    this.prevResolveStatusNumber = 0L;
                } else {
                    this.connector.log(curResolveStatus, exception, null);
                }
                this.prevResolveStatusTime = curTime;
                this.prevResolveStatus = curResolveStatus;
            }
        }
        this.resolved_addresses.retainAll(addresses);
        addresses.removeAll(this.resolved_addresses);
        for (SocketAddress address : addresses) {
            this.resolved_addresses.add(this.random.nextInt(this.resolved_addresses.size() + 1), address);
        }
    }
}

