/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars.common;

public final class MARSStatus
implements Comparable {
    public static final MARSStatus OK = new MARSStatus("Ok", "OK", 4);
    public static final MARSStatus WARNING = new MARSStatus("Warning", "WARNG", 2);
    public static final MARSStatus ERROR = new MARSStatus("Error", "ERROR", 1);
    public static final MARSStatus REMOVED = new MARSStatus("Removed", "RMVED", 5);
    public static final MARSStatus UNDEFINED = new MARSStatus("<undefined>", "UNDEF", 3);
    public static final String[] STATUS_NAMES = new String[]{UNDEFINED.toString(), OK.toString(), WARNING.toString(), ERROR.toString()};
    private final String name;
    private final String shortName;
    private final byte order;

    private MARSStatus(String name, String shortName, byte order) {
        this.name = name;
        this.shortName = shortName;
        this.order = order;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static String toString(MARSStatus marsStatus) {
        return marsStatus == null ? UNDEFINED.toString() : marsStatus.toString();
    }

    public String getShortName() {
        return this.shortName;
    }

    public static MARSStatus find(String status) {
        if (status == null) {
            return UNDEFINED;
        }
        if (status.regionMatches(true, 0, MARSStatus.OK.name, 0, MARSStatus.OK.name.length())) {
            return OK;
        }
        if (status.regionMatches(true, 0, MARSStatus.WARNING.name, 0, MARSStatus.WARNING.name.length())) {
            return WARNING;
        }
        if (status.regionMatches(true, 0, MARSStatus.ERROR.name, 0, MARSStatus.ERROR.name.length())) {
            return ERROR;
        }
        if (status.regionMatches(true, 0, MARSStatus.REMOVED.name, 0, MARSStatus.REMOVED.name.length())) {
            return REMOVED;
        }
        return UNDEFINED;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        MARSStatus marsStatus = (MARSStatus)o;
        if (this.order < marsStatus.order) {
            return 1;
        }
        if (this.order > marsStatus.order) {
            return -1;
        }
        return 0;
    }
}

