/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.Hashing;
import java.util.Arrays;

public class HashingTest {
    public static void main(String[] args) {
        int[] random = new int[100];
        int[] indexed = new int[100];
        int[] rational = new int[100];
        double totRandom = 0.0;
        double totIndexed = 0.0;
        double totRational = 0.0;
        int capacity = 1000000;
        int shift = Hashing.getShift((int)capacity);
        int[] matrix = new int[1 << 32 - shift];
        int magic = 0;
        int[] magics = new int[10];
        for (int repeat = 1; repeat <= 100000; ++repeat) {
            for (int i = 0; i < magics.length; ++i) {
                magics[i] = Hashing.nextMagic((int)magic);
            }
            int m1 = HashingTest.findIndexed(magics);
            int m2 = HashingTest.findRational(magics);
            double hr1 = HashingTest.check(capacity, shift, matrix, magics[m1], 10.0);
            totIndexed += HashingTest.add(indexed, hr1);
            if (m1 != m2) {
                double hr2 = HashingTest.check(capacity, shift, matrix, magics[m2], 10.0);
                totRational += HashingTest.add(rational, hr2);
                totRandom += HashingTest.add(random, m1 == 0 ? hr1 : (m2 == 0 ? hr2 : HashingTest.check(capacity, shift, matrix, magics[0], 50.0)));
            } else {
                totRational += HashingTest.add(rational, hr1);
                totRandom += HashingTest.add(random, m1 == 0 ? hr1 : HashingTest.check(capacity, shift, matrix, magics[0], 50.0));
            }
            magic = magics[m2];
            if (repeat % 100 != 0) continue;
            System.out.println(capacity + " #" + repeat);
            System.out.println("random   " + HashingTest.toString(totRandom / (double)repeat, random));
            System.out.println("indexed  " + HashingTest.toString(totIndexed / (double)repeat, indexed));
            System.out.println("rational " + HashingTest.toString(totRational / (double)repeat, rational));
        }
    }

    private static double add(int[] a, double r) {
        int n = Math.min((int)(r / 10.0), a.length - 1);
        a[n] = a[n] + 1;
        return r;
    }

    private static String toString(double rate, int[] a) {
        int i;
        for (i = a.length; i > 0 && a[i - 1] == 0; --i) {
        }
        return String.format("%10.6f %s", rate, Arrays.toString(Arrays.copyOf(a, i)));
    }

    private static double check(int capacity, int shift, int[] matrix, int magic, double print) {
        Arrays.fill(matrix, 0);
        long start = System.nanoTime();
        long hits = 0L;
        long hm = 0L;
        for (int key = 1; key <= capacity; ++key) {
            int distance = HashingTest.addKey(key, matrix, magic, shift);
            hits += (long)distance;
            hm = Math.max(hm, (long)distance);
        }
        long end = System.nanoTime();
        double hr = (double)hits / (double)capacity;
        if (hr >= print) {
            System.out.println(magic + " in " + (double)((end - start) / 1000L) / 1000.0 + " ms avg " + hr + " max " + hm + " as " + HashingTest.printContinuedFraction(magic));
        }
        return hr;
    }

    private static int addKey(int key, int[] matrix, int magic, int shift) {
        int test;
        int distance = 1;
        int index = key * magic >>> shift;
        while ((test = matrix[index]) != key) {
            if (test == 0) {
                if (index > 0) {
                    matrix[index] = key;
                    return distance;
                }
                index = matrix.length;
            }
            --index;
            ++distance;
        }
        throw new IllegalStateException("duplicate key " + matrix[index] + " for " + key + " at " + index);
    }

    private static int findIndexed(int[] magics) {
        int best = 0;
        long eval = HashingTest.evaluateContinuedFractionIndexed(magics[best]);
        for (int i = 1; i < magics.length; ++i) {
            long e = HashingTest.evaluateContinuedFractionIndexed(magics[i]);
            if (e >= eval) continue;
            best = i;
            eval = e;
        }
        return best;
    }

    private static int findRational(int[] magics) {
        int best = 0;
        double eval = Hashing.evaluateContinuedFraction((int)magics[best]);
        for (int i = 1; i < magics.length; ++i) {
            double e = Hashing.evaluateContinuedFraction((int)magics[i]);
            if (!(e > eval)) continue;
            best = i;
            eval = e;
        }
        return best;
    }

    private static long evaluateContinuedFractionIndexed(int magic) {
        double d = (double)((long)magic & 0xFFFFFFFFL) / 4.294967296E9;
        long result = 1L;
        long prev = 1L;
        for (int i = 0; i < 15; ++i) {
            d = 1.0 / d;
            long c = (long)d;
            result = Math.max(result, prev * c / (long)(i + 1));
            prev = c;
            d -= (double)c;
        }
        return result;
    }

    private static String printContinuedFraction(int magic) {
        double x;
        double rem = x = (double)((long)magic & 0xFFFFFFFFL) / 4.294967296E9;
        long p2 = 1L;
        long q2 = 0L;
        long p1 = 0L;
        long q1 = 1L;
        double grade = x;
        StringBuilder sb = new StringBuilder();
        sb.append(x).append("=[");
        for (int i = 0; i < 20; ++i) {
            rem = 1.0 / rem;
            long a = (long)rem;
            rem -= (double)a;
            long p = a * p1 + p2;
            long q = a * q1 + q2;
            p2 = p1;
            q2 = q1;
            p1 = p;
            q1 = q;
            double e = Math.abs(x * (double)q - (double)p) * (double)q;
            grade = Math.min(grade, e);
            sb.append(a).append(" ").append(p).append("/").append(q);
            sb.append(" ~").append(e < 1.0E-4 ? e : (double)((long)(e * 10000.0)) / 10000.0).append(",");
            if (grade < 1.0E-6 || rem < 1.0E-6 || q > 0x100000L) break;
        }
        sb.setLength(sb.length() - 1);
        sb.append("]=").append(grade);
        return sb.toString();
    }
}

