/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.HistorySubscriptionFilter;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.QDErrorHandler;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.QDHistory;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.impl.matrix.History;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.qd.kit.RecordOnlyFilter;
import com.devexperts.qd.ng.AbstractRecordProvider;
import com.devexperts.qd.ng.AbstractRecordSink;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordListener;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordProvider;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.test.TraceRunnerWithParametersFactory;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=TraceRunnerWithParametersFactory.class)
public class HistoryTxTest {
    private static final int TX_PENDING = EventFlag.TX_PENDING.flag();
    private static final int REMOVE_EVENT = EventFlag.REMOVE_EVENT.flag();
    private static final int SNAPSHOT_BEGIN = EventFlag.SNAPSHOT_BEGIN.flag();
    private static final int SNAPSHOT_END = EventFlag.SNAPSHOT_END.flag();
    private static final int SNAPSHOT_SNIP = EventFlag.SNAPSHOT_SNIP.flag();
    private static final int SNAPSHOT_MODE = EventFlag.SNAPSHOT_MODE.flag();
    private static final int VALUE_INDEX = 2;
    private static final DataRecord RECORD = new DefaultRecord(0, "Test", true, new DataIntField[]{new CompactIntField(0, "Test.1"), new CompactIntField(1, "Test.2"), new CompactIntField(2, "Test.Value")}, new DataObjField[0]);
    private static final PentaCodec CODEC = PentaCodec.INSTANCE;
    private static final int CIPHER = CODEC.encode("TST");
    private static final DataScheme SCHEME = new DefaultScheme((SymbolCodec)CODEC, new DataRecord[]{RECORD});
    private final boolean blocking;
    private final boolean unconflated;
    private HistoryImpl history;
    private QDDistributor distributor;
    private QDAgent agent;
    private QDAgent agent2;
    private boolean available;
    RecordProvider provider;
    RecordProvider blockingProvider;
    RecordListener blockingListener;
    RecordBuffer retrieveBuf = new RecordBuffer(RecordMode.FLAGGED_DATA);
    RecordBuffer distributeBuf = new RecordBuffer(RecordMode.FLAGGED_DATA);
    boolean distributeBatch;
    Runnable betweenProcessPhases;

    @Parameterized.Parameters(name="blocking={0}, unconflated={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({false, false}, {true, false}, {false, true}, {true, true});
    }

    public HistoryTxTest(boolean blocking, boolean unconflated) {
        this.blocking = blocking;
        this.unconflated = unconflated;
    }

    @Before
    public void setUp() throws Exception {
        this.history = new HistoryImpl((QDCollector.Builder<QDHistory>)QDFactory.getDefaultFactory().historyBuilder().withScheme(SCHEME).withStats(QDStats.VOID).withHistoryFilter((HistorySubscriptionFilter)new HSF()));
        this.distributor = this.history.distributorBuilder().build();
        this.history.setErrorHandler(QDErrorHandler.THROW);
    }

    @Test
    public void testLegacyToSnapshotUpdate() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(3L, 13, SNAPSHOT_BEGIN);
        this.distribute(1L, 14, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        if (this.blocking) {
            this.expectMore(3L, 13, TX_PENDING | SNAPSHOT_BEGIN);
            this.expectMore(1L, 14, TX_PENDING);
            this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        } else {
            this.expectMore(3L, 13, SNAPSHOT_BEGIN);
            this.expectMore(1L, 14, 0);
            this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        }
    }

    @Test
    public void testLegacyToSnapshotUpdateDirty() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(3L, 13, SNAPSHOT_BEGIN);
        this.expectJust(3L, 13, TX_PENDING | SNAPSHOT_BEGIN);
        this.distribute(1L, 14, 0);
        this.expectJust(1L, 14, TX_PENDING);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
    }

    @Test
    public void testLegacyToSnapshotUpdateLegacyAgent() {
        this.createAgent(0L, false);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(3L, 13, SNAPSHOT_BEGIN);
        this.distribute(1L, 14, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(3L, 13, 0);
        this.expectMore(2L, 0, 0);
        this.expectJust(1L, 14, 0);
    }

    @Test
    public void testLegacyCleanupWithSnapshot() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(0L, 0, SNAPSHOT_BEGIN | SNAPSHOT_END | REMOVE_EVENT);
        this.expectJust(0L, 0, SNAPSHOT_BEGIN | SNAPSHOT_END | REMOVE_EVENT);
    }

    @Test
    public void testLegacyCleanupWithSnapshotLegacyAgent() {
        this.createAgent(0L, false);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(0L, 0, SNAPSHOT_BEGIN | SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(3L, 0, 0);
        this.expectMore(2L, 0, 0);
        this.expectJust(1L, 0, 0);
    }

    @Test
    public void testLegacyCleanupWithSnapshotBelowSub() {
        this.createAgent(2L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectJust(2L, 11, 0);
        this.distribute(0L, 0, SNAPSHOT_BEGIN | SNAPSHOT_END | REMOVE_EVENT);
        this.expectJust(2L, 0, SNAPSHOT_BEGIN | SNAPSHOT_END | REMOVE_EVENT);
    }

    @Test
    public void testLegacyCleanupWithSnapshotBelowSubLegacyAgent() {
        this.createAgent(2L, false);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectJust(2L, 11, 0);
        this.distribute(0L, 0, SNAPSHOT_BEGIN | SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(3L, 0, 0);
        this.expectJust(2L, 0, 0);
    }

    @Test
    public void testLegacyPartialRetrieveReplaceWithSnapshot() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
    }

    @Test
    public void testLegacyPartialRetrieveReplaceWithSnapshotLegacyAgent() {
        this.createAgent(0L, false);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
    }

    @Test
    public void testSimpleSnapshotUpdate() {
        this.distribute(4L, 10, 0);
        this.createAgent(0L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT);
        this.expectNothing();
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(4L, 13, SNAPSHOT_BEGIN);
        if (this.unconflated) {
            this.expectJust(4L, 13, TX_PENDING | SNAPSHOT_BEGIN);
        } else {
            this.expectJust(4L, 13, TX_PENDING);
        }
        this.distribute(3L, 14, 0);
        this.expectJust(3L, 14, TX_PENDING);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        if (this.unconflated) {
            this.expectMore(2L, 11, TX_PENDING);
            this.expectJust(1L, 12, TX_PENDING);
        } else {
            this.expectNothing();
        }
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
    }

    @Test
    public void testSnapshotSweepRemoveClean() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, SNAPSHOT_END);
        this.distribute(1L, 13, SNAPSHOT_BEGIN);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(1L, 13, (this.blocking ? TX_PENDING : 0) | SNAPSHOT_BEGIN);
            this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(2L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(0L, 0, REMOVE_EVENT);
        }
    }

    @Test
    public void testSnapshotSweepRemoveExamine() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, SNAPSHOT_END);
        this.distribute(1L, 13, SNAPSHOT_BEGIN);
        this.examineAll();
        this.expectMore(1L, 13, SNAPSHOT_BEGIN | TX_PENDING);
        this.expectJust(0L, 14, SNAPSHOT_END | TX_PENDING);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.examineAll();
        this.expectMore(1L, 13, SNAPSHOT_BEGIN);
        this.expectJust(0L, 14, SNAPSHOT_END);
    }

    @Test
    public void testSnapshotSweepRemoveDirty() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, SNAPSHOT_END);
        this.distribute(1L, 13, SNAPSHOT_BEGIN);
        if (this.unconflated) {
            this.expectJust(1L, 13, TX_PENDING | SNAPSHOT_BEGIN);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(2L, 0, REMOVE_EVENT | TX_PENDING);
        }
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        if (this.unconflated) {
            this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        } else {
            this.expectJust(0L, 0, REMOVE_EVENT);
        }
    }

    @Test
    public void testSnapshotSweepRemoveDirtyLegacyAgent() {
        this.createAgent(0L, false);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, 0);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, 0);
        this.distribute(1L, 13, SNAPSHOT_BEGIN);
        this.expectMore(4L, 0, 0);
        this.expectMore(3L, 0, 0);
        this.expectJust(2L, 0, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectJust(0L, 0, 0);
    }

    @Test
    public void testSnapshotSweepRemovePartSub1() {
        this.createAgent(2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 12, SNAPSHOT_END);
        this.distribute(1L, 13, SNAPSHOT_BEGIN);
        if (this.unconflated) {
            this.expectJust(2L, 0, REMOVE_EVENT | SNAPSHOT_BEGIN | SNAPSHOT_END);
        } else if (this.blocking) {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(2L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(2L, 0, REMOVE_EVENT);
        }
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectNothing();
    }

    @Test
    public void testSnapshotSweepRemovePartSub2() {
        this.createAgent(2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(1L, 13, SNAPSHOT_BEGIN);
        if (this.unconflated) {
            this.expectJust(2L, 0, REMOVE_EVENT | SNAPSHOT_BEGIN | SNAPSHOT_END);
        } else if (this.blocking) {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(3L, 0, REMOVE_EVENT);
        }
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectNothing();
    }

    @Test
    public void testSnapshotSweepRemoveUpdate() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, SNAPSHOT_END);
        this.distribute(1L, 15, SNAPSHOT_BEGIN);
        if (this.unconflated) {
            this.expectJust(1L, 15, SNAPSHOT_BEGIN | TX_PENDING);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(2L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(1L, 15, TX_PENDING);
        }
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        if (this.unconflated) {
            this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        } else {
            this.expectJust(0L, 0, REMOVE_EVENT);
        }
    }

    @Test
    public void testSnapshotSweepRemoveUpdatePartSub() {
        this.createAgent(2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 12, SNAPSHOT_END);
        this.distribute(1L, 15, SNAPSHOT_BEGIN);
        if (this.unconflated) {
            this.expectJust(2L, 0, REMOVE_EVENT | SNAPSHOT_BEGIN | SNAPSHOT_END);
        } else if (this.blocking) {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(2L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(2L, 0, REMOVE_EVENT);
        }
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectNothing();
    }

    @Test
    public void testSnapshotSweepClearTx() {
        this.history.setStoreEverything(true);
        this.distribute(2L, 1, SNAPSHOT_BEGIN);
        this.distribute(1L, 1, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END | SNAPSHOT_SNIP);
        this.distribute(2L, 1, SNAPSHOT_BEGIN);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END | SNAPSHOT_SNIP);
        this.createAgent(0L, true);
        this.expectMore(2L, 1, SNAPSHOT_BEGIN);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
    }

    @Test
    public void testSnapshotInsert() {
        this.createAgent(0L, true);
        this.distribute(6L, 10, SNAPSHOT_BEGIN);
        this.distribute(4L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        this.expectMore(6L, 10, SNAPSHOT_BEGIN);
        this.expectMore(4L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectJust(0L, 13, SNAPSHOT_END);
        this.distribute(6L, 10, SNAPSHOT_BEGIN);
        this.distribute(4L, 11, 0);
        this.distribute(3L, 14, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 15, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(6L, 10, SNAPSHOT_BEGIN);
            this.expectMore(4L, 11, 0);
            this.expectMore(3L, 14, this.blocking ? TX_PENDING : 0);
            this.expectMore(2L, 12, this.blocking ? TX_PENDING : 0);
            this.expectMore(1L, 15, this.blocking ? TX_PENDING : 0);
            this.expectJust(0L, 13, SNAPSHOT_END);
        } else if (this.blocking) {
            this.expectMore(3L, 14, TX_PENDING);
            this.expectMore(1L, 15, TX_PENDING);
            this.expectJust(0L, 13, 0);
        } else {
            this.expectMore(3L, 14, TX_PENDING);
            this.expectJust(1L, 15, 0);
        }
    }

    @Test
    public void testSnapshotInsertPartSub1() {
        this.createAgent(2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectJust(2L, 11, SNAPSHOT_END);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 13, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 14, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectMore(3L, 13, this.blocking ? TX_PENDING : 0);
            this.expectJust(2L, 11, SNAPSHOT_END);
        } else if (this.blocking) {
            this.expectMore(3L, 13, TX_PENDING);
            this.expectJust(2L, 11, 0);
        } else {
            this.expectJust(3L, 13, 0);
        }
    }

    @Test
    public void testSnapshotInsertPartSub2() {
        this.createAgent(3L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectJust(3L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 13, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 14, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectJust(3L, 13, SNAPSHOT_END);
        } else {
            this.expectJust(3L, 13, 0);
        }
    }

    @Test
    public void testSnapshotInsertPartSub3() {
        this.createAgent(1L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 13, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 14, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectMore(3L, 13, this.blocking ? TX_PENDING : 0);
            this.expectMore(2L, 11, this.blocking ? TX_PENDING : 0);
            this.expectJust(1L, 14, SNAPSHOT_END);
        } else {
            this.expectMore(3L, 13, TX_PENDING);
            this.expectJust(1L, 14, 0);
        }
    }

    @Test
    public void testSnapshotInsertPartSub4() {
        this.createAgent(3L, true);
        this.distribute(8L, 10, SNAPSHOT_BEGIN);
        this.distribute(4L, 11, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        this.expectMore(8L, 10, SNAPSHOT_BEGIN);
        this.expectMore(4L, 11, 0);
        this.expectJust(3L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(8L, 10, SNAPSHOT_BEGIN);
        this.distribute(6L, 13, 0);
        this.distribute(4L, 11, 0);
        this.distribute(2L, 14, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(8L, 10, SNAPSHOT_BEGIN);
            this.expectMore(6L, 13, this.blocking ? TX_PENDING : 0);
            this.expectMore(4L, 11, this.blocking ? TX_PENDING : 0);
            this.expectJust(3L, 0, SNAPSHOT_END | REMOVE_EVENT);
        } else if (this.blocking) {
            this.expectMore(6L, 13, TX_PENDING);
            this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
        } else {
            this.expectJust(6L, 13, 0);
        }
    }

    @Test
    public void testSnapshotInsertPartSub5() {
        this.createAgent(1L, true);
        this.distribute(8L, 10, SNAPSHOT_BEGIN);
        this.distribute(4L, 11, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        this.expectMore(8L, 10, SNAPSHOT_BEGIN);
        this.expectMore(4L, 11, 0);
        this.expectJust(1L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(8L, 10, SNAPSHOT_BEGIN);
        this.distribute(6L, 13, 0);
        this.distribute(4L, 11, 0);
        this.distribute(2L, 14, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(8L, 10, SNAPSHOT_BEGIN);
            this.expectMore(6L, 13, this.blocking ? TX_PENDING : 0);
            this.expectMore(4L, 11, this.blocking ? TX_PENDING : 0);
            this.expectMore(2L, 14, this.blocking ? TX_PENDING : 0);
            this.expectJust(1L, 0, SNAPSHOT_END | REMOVE_EVENT);
        } else if (this.blocking) {
            this.expectMore(6L, 13, TX_PENDING);
            this.expectMore(2L, 14, TX_PENDING);
            this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
        } else {
            this.expectMore(6L, 13, TX_PENDING);
            this.expectJust(2L, 14, 0);
        }
    }

    @Test
    public void testTxSimple() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, SNAPSHOT_END);
        this.distribute(3L, 15, TX_PENDING);
        this.distribute(2L, 16, 0);
        this.expectMore(3L, 15, TX_PENDING);
        this.expectJust(2L, 16, 0);
        this.distribute(0L, 17, TX_PENDING);
        this.distribute(3L, 18, 0);
        this.expectMore(0L, 17, TX_PENDING);
        this.expectJust(3L, 18, 0);
    }

    @Test
    public void testTxConflate() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectJust(0L, 12, SNAPSHOT_END);
        this.distribute(4L, 13, TX_PENDING);
        this.distribute(4L, 14, 0);
        if (this.unconflated) {
            this.expectMore(4L, 13, TX_PENDING);
            this.expectJust(4L, 14, 0);
        } else {
            this.expectJust(4L, 14, 0);
        }
    }

    @Test
    public void testTxDirty1() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.distribute(2L, 15, TX_PENDING);
        this.expectMore(4L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, TX_PENDING);
        this.expectMore(2L, 15, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 14, TX_PENDING | SNAPSHOT_END);
        this.distribute(1L, 16, TX_PENDING);
        this.expectJust(1L, 16, TX_PENDING);
        this.distribute(3L, 17, 0);
        this.expectJust(3L, 17, 0);
    }

    @Test
    public void testTxDirty1a() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.distribute(2L, 15, TX_PENDING);
        this.expectMore(4L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, TX_PENDING);
        this.expectMore(2L, 15, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 14, TX_PENDING | SNAPSHOT_END);
        this.distribute(1L, 16, TX_PENDING);
        this.distribute(3L, 17, 0);
        this.expectMore(1L, 16, TX_PENDING);
        this.expectJust(3L, 17, 0);
    }

    @Test
    public void testTxDirty1b() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.distribute(2L, 15, TX_PENDING);
        this.expectMore(4L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, TX_PENDING);
        this.expectMore(2L, 15, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 14, TX_PENDING | SNAPSHOT_END);
        this.distribute(1L, 13, TX_PENDING);
        this.distribute(3L, 11, 0);
        this.expectJust(3L, 11, 0);
    }

    @Test
    public void testTxDirty1bBatchRetrieve() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.distribute(2L, 15, TX_PENDING);
        this.retrieveBatch(5);
        this.expectMore(4L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, TX_PENDING);
        this.expectMore(2L, 15, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 14, TX_PENDING | SNAPSHOT_END);
        this.distribute(1L, 13, TX_PENDING);
        this.distribute(3L, 11, 0);
        this.expectJust(3L, 11, 0);
    }

    @Test
    public void testTxNonDirtyUpdates1() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, SNAPSHOT_END);
        this.distribute(3L, 15, 0);
        this.distribute(2L, 16, 0);
        this.distribute(3L, 17, TX_PENDING);
        this.distribute(2L, 18, 0);
        this.distribute(3L, 19, TX_PENDING);
        this.distribute(2L, 20, 0);
        this.expectMore(3L, 15, 0);
        this.expectMore(2L, 16, 0);
        this.expectMore(3L, 17, TX_PENDING);
        this.expectMore(2L, 18, 0);
        this.expectMore(3L, 19, TX_PENDING);
        this.expectJust(2L, 20, 0);
    }

    @Test
    public void testTxNonDirtyUpdates2() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.distribute(1L, 15, 0);
        this.distribute(0L, 16, 0);
        this.distribute(1L, 17, TX_PENDING);
        this.distribute(0L, 18, 0);
        this.distribute(1L, 19, TX_PENDING);
        this.distribute(0L, 20, 0);
        this.expectMore(1L, 19, 0);
        this.expectJust(0L, 20, SNAPSHOT_END);
    }

    @Test
    public void testTxDirtyUpdates1() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.distribute(3L, 15, 0);
        this.distribute(2L, 16, 0);
        this.distribute(3L, 17, TX_PENDING);
        this.distribute(2L, 18, 0);
        this.distribute(3L, 19, TX_PENDING);
        this.distribute(2L, 20, 0);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectMore(0L, 14, TX_PENDING | SNAPSHOT_END);
        this.expectMore(3L, 15, TX_PENDING);
        this.expectMore(2L, 16, TX_PENDING);
        this.expectMore(3L, 17, TX_PENDING);
        this.expectMore(2L, 18, TX_PENDING);
        this.expectMore(3L, 19, TX_PENDING);
        this.expectJust(2L, 20, 0);
    }

    @Test
    public void testTxDirtyUpdates2() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.distribute(3L, 15, 0);
        this.distribute(2L, 16, 0);
        this.distribute(3L, 17, TX_PENDING);
        this.distribute(2L, 18, 0);
        this.distribute(3L, 19, TX_PENDING);
        this.distribute(2L, 20, 0);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectMore(0L, 14, TX_PENDING | SNAPSHOT_END);
        this.expectMore(3L, 15, TX_PENDING);
        this.expectMore(2L, 16, TX_PENDING);
        this.expectMore(3L, 17, TX_PENDING);
        this.expectMore(2L, 18, TX_PENDING);
        this.expectMore(3L, 19, TX_PENDING);
        this.expectJust(2L, 20, 0);
    }

    @Test
    public void testTxSnapshotTxEndDeliveryBelowTimeSub() {
        this.createAgent(2L, true);
        this.distribute(4L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.distribute(3L, 11, TX_PENDING);
        this.distribute(2L, 12, TX_PENDING);
        this.distribute(1L, 13, TX_PENDING);
        this.distribute(0L, 14, TX_PENDING | SNAPSHOT_END);
        this.expectMore(4L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, TX_PENDING);
        this.expectJust(2L, 12, TX_PENDING | SNAPSHOT_END);
        this.distribute(1L, 16, TX_PENDING);
        this.distribute(0L, 17, 0);
        this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
    }

    @Test
    public void testTxDirtyTxEndDeliveryBelowTimeSub() {
        if (this.blocking) {
            return;
        }
        this.createAgent(2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.distribute(2L, 15, TX_PENDING);
        this.expectMore(4L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, TX_PENDING);
        this.expectJust(2L, 15, TX_PENDING | SNAPSHOT_END);
        this.distribute(1L, 16, TX_PENDING);
        this.distribute(0L, 17, 0);
        this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
    }

    @Test
    public void testSnapshotUpdateTxEndDeliveryBelowTimeSub1() {
        this.createAgent(2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 12, SNAPSHOT_END);
        this.distribute(0L, 0, SNAPSHOT_BEGIN | REMOVE_EVENT | SNAPSHOT_END);
        if (this.unconflated) {
            this.expectJust(2L, 0, SNAPSHOT_BEGIN | REMOVE_EVENT | SNAPSHOT_END);
        } else if (this.blocking) {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(2L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(2L, 0, REMOVE_EVENT);
        }
    }

    @Test
    public void testSnapshotUpdateTxEndDeliveryBelowTimeSub2() {
        this.createAgent(2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(0L, 0, SNAPSHOT_BEGIN | REMOVE_EVENT | SNAPSHOT_END);
        if (this.unconflated) {
            this.expectJust(2L, 0, SNAPSHOT_BEGIN | REMOVE_EVENT | SNAPSHOT_END);
        } else if (this.blocking) {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(3L, 0, REMOVE_EVENT);
        }
    }

    @Test
    public void testFlagsOnLastEventConflationWithRebase() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.distribute(2L, 14, TX_PENDING);
        this.distribute(1L, 15, 0);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 14, 0);
        this.distribute(1L, 16, 0);
        this.history.forceRebase(this.agent);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        if (this.unconflated && this.blocking) {
            this.expectMore(2L, 14, TX_PENDING);
            this.expectMore(1L, 15, 0);
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectMore(3L, 11, 0);
            this.expectMore(2L, 14, 0);
            this.expectMore(1L, 16, TX_PENDING);
            this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        } else if (this.unconflated) {
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectMore(3L, 11, 0);
            this.expectMore(2L, 14, 0);
            this.expectMore(1L, 16, 0);
            this.expectMore(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
            this.expectNothingRetrieves();
        } else if (this.blocking) {
            this.expectMore(2L, 14, TX_PENDING);
            this.expectMore(1L, 16, TX_PENDING);
            this.expectJust(0L, 0, REMOVE_EVENT);
        } else {
            this.expectMore(2L, 14, TX_PENDING);
            this.expectJust(1L, 16, 0);
        }
    }

    @Test
    public void testUnlinkedReturnAfterRebase() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.distribute(2L, 14, TX_PENDING);
        this.distribute(1L, 15, 0);
        this.setSubTime(0L);
        this.history.forceRebase(this.agent);
        this.setSubTime(0L);
    }

    @Test
    public void testUnlinkedReturnAfterRebase2() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.distribute(2L, 14, TX_PENDING);
        this.distribute(1L, 15, 0);
        this.setSubTime(0L);
        this.history.forceRebase(this.agent);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
    }

    @Test
    public void testUnlinkedReturnAfterRebase3() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.distribute(2L, 14, TX_PENDING);
        this.distribute(1L, 15, 0);
        this.setSubTime(0L);
        this.history.forceRebase(this.agent);
        if (this.blocking) {
            this.expectMore(2L, 14, TX_PENDING);
            this.expectMore(1L, 15, 0);
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectMore(3L, 11, 0);
        } else {
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectMore(3L, 11, 0);
        }
        this.distribute(4L, 10, TX_PENDING);
        this.retrieveBatch(1);
    }

    @Test
    public void testComplexTxUpdateSequence() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.distribute(2L, 14, TX_PENDING);
        this.distribute(1L, 15, 0);
        this.expectMore(2L, 14, TX_PENDING);
        this.expectJust(1L, 15, 0);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 17, 0);
        this.distribute(2L, 16, 0);
        this.distribute(1L, 15, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.distribute(2L, 17, 0);
        if (this.unconflated && this.blocking) {
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectMore(3L, 17, TX_PENDING);
            this.expectMore(2L, 16, TX_PENDING);
            this.expectMore(1L, 15, TX_PENDING);
            this.expectMore(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
            this.expectJust(2L, 17, 0);
        } else if (this.unconflated) {
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectMore(3L, 17, 0);
            this.expectMore(2L, 17, 0);
            this.expectMore(1L, 15, 0);
            this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        } else {
            this.expectMore(3L, 17, TX_PENDING);
            if (this.blocking) {
                this.expectMore(2L, 16, TX_PENDING);
                this.expectMore(0L, 0, REMOVE_EVENT);
                this.expectJust(2L, 17, 0);
            } else {
                this.expectJust(2L, 17, 0);
            }
            this.distribute(2L, 18, TX_PENDING);
            this.distribute(0L, 0, REMOVE_EVENT);
            if (this.blocking) {
                this.expectMore(2L, 18, TX_PENDING);
                this.expectJust(0L, 0, REMOVE_EVENT);
            } else {
                this.expectJust(2L, 18, 0);
            }
        }
    }

    @Test
    public void testTxUnSubPart() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.setSubTime(2L);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 12, SNAPSHOT_END);
        this.setSubTime(0L);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 12, 0);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        if (this.unconflated) {
            this.expectMore(4L, 10, SNAPSHOT_BEGIN);
            this.expectMore(3L, 11, 0);
            this.expectMore(2L, 12, 0);
            this.expectMore(1L, 13, 0);
            this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        } else {
            this.expectMore(1L, 13, 0);
            this.expectJust(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        }
    }

    @Test
    public void testStoreEverything() {
        this.history.setStoreEverything(true);
        this.distribute(1L, 10, 0);
        this.createAgent(0L, true);
        this.expectJust(1L, 10, 0);
        this.distribute(2L, 11, 0);
        this.expectJust(2L, 11, 0);
        this.closeAgent();
        this.createAgent(0L, true);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 10, 0);
        this.closeAgent();
        this.removeData();
        this.createAgent(0L, true);
        this.expectNothing();
    }

    @Test
    public void testStoreEverything2() {
        this.history.setStoreEverything(true);
        this.distribute(1L, 10, 0);
        this.distribute(2L, 11, 0);
        this.createAgent(0L, true);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 10, 0);
    }

    @Test
    public void testStoreEverythingSnipThenSnapshot() {
        int i;
        this.history.setStoreEverything(true);
        this.distribute(7L, 10, 0);
        this.distribute(6L, 11, 0);
        this.distribute(5L, 12, 0);
        this.examineAll();
        this.expectMore(7L, 10, 0);
        this.expectMore(6L, 11, 0);
        this.expectJust(5L, 12, 0);
        this.distribute(6L, 0, REMOVE_EVENT);
        this.examineAll();
        this.expectMore(7L, 10, 0);
        this.expectJust(5L, 12, 0);
        this.distribute(6L, 0, SNAPSHOT_SNIP);
        this.examineAll();
        this.expectMore(7L, 10, 0);
        this.expectJust(6L, 0, SNAPSHOT_SNIP);
        this.distribute(9L, 19, SNAPSHOT_BEGIN);
        for (i = 8; i >= 1; --i) {
            this.distribute(i, 10 + i, 0);
        }
        this.distribute(0L, 20, SNAPSHOT_END);
        this.examineAll();
        this.expectMore(9L, 19, SNAPSHOT_BEGIN);
        for (i = 8; i >= 1; --i) {
            this.expectMore(i, 10 + i, 0);
        }
        this.expectJust(0L, 20, SNAPSHOT_END);
    }

    @Test
    public void testSnapshotThenEnable() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_MODE);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
    }

    @Test
    public void testSnapshotSnipThenEnable() {
        this.createAgent(-1L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_SNIP);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_SNIP);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_MODE);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_SNIP);
    }

    @Test
    public void testSnapshotMode() {
        this.createAgent(1L, true);
        this.distribute(Long.MAX_VALUE, 0, REMOVE_EVENT | SNAPSHOT_MODE);
        this.expectNothing();
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, SNAPSHOT_END);
    }

    @Test
    public void testSnapshotModeThenSnip() {
        this.createAgent(-1L, true);
        this.distribute(Long.MAX_VALUE, 0, REMOVE_EVENT | SNAPSHOT_MODE);
        this.expectNothing();
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, SNAPSHOT_SNIP);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, SNAPSHOT_SNIP);
    }

    @Test
    public void testBigSnapshot() {
        int n;
        int i;
        if (this.unconflated) {
            return;
        }
        this.createAgent(0L, true);
        for (i = n = 100; i >= 0; --i) {
            this.distribute(i, i, i == n ? SNAPSHOT_BEGIN : (i == 0 ? SNAPSHOT_END : 0));
        }
        for (i = n; i >= 0; --i) {
            this.expect(i, i, i == n ? SNAPSHOT_BEGIN : (i == 0 ? SNAPSHOT_END : 0));
        }
        this.expectNothing();
        for (i = n; i >= 0; --i) {
            this.distribute(i, i, i == n ? SNAPSHOT_BEGIN : (i == 0 ? SNAPSHOT_END : 0));
        }
        this.expectNothing();
        for (i = n; i >= 0; --i) {
            this.distribute(i, i + n, i == n ? SNAPSHOT_BEGIN : (i == 0 ? SNAPSHOT_END : 0));
        }
        for (i = n; i >= 0; --i) {
            this.expect(i, i + n, i == 0 ? 0 : TX_PENDING);
        }
        this.expectNothing();
    }

    @Test
    public void testExamineLegacy() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.examineAll();
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.examineBySubscription(0L);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.examineBySubscription(2L);
        this.expectMore(3L, 10, 0);
        this.expectJust(2L, 11, 0);
        this.examineRange(0L, Long.MAX_VALUE);
        this.expectMore(1L, 12, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(3L, 10, 0);
        this.examineRange(0L, 0L);
        this.expectNothing();
        this.examineRange(1L, 2L);
        this.expectMore(1L, 12, 0);
        this.expectJust(2L, 11, 0);
        this.examineRange(2L, 3L);
        this.expectMore(2L, 11, 0);
        this.expectJust(3L, 10, 0);
        this.examineRange(Long.MAX_VALUE, 0L);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.examineRange(2L, 1L);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.examineRange(2L, 0L);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.examineRange(3L, 2L);
        this.expectMore(3L, 10, 0);
        this.expectJust(2L, 11, 0);
        this.closeAgentAndExamine();
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
    }

    @Test
    public void testExamineSnapshot() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.examineAll();
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.examineBySubscription(0L);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.examineBySubscription(2L);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectJust(2L, 11, SNAPSHOT_END);
        this.examineRange(0L, 0L);
        this.expectJust(0L, 0, REMOVE_EVENT);
        this.examineRange(0L, Long.MAX_VALUE);
        this.expectMore(0L, 0, REMOVE_EVENT);
        this.expectMore(1L, 12, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(3L, 10, 0);
        this.examineRange(1L, 2L);
        this.expectMore(1L, 12, 0);
        this.expectJust(2L, 11, 0);
        this.examineRange(2L, 3L);
        this.expectMore(2L, 11, 0);
        this.expectJust(3L, 10, 0);
        this.examineRange(Long.MAX_VALUE, 0L);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT);
        this.examineRange(2L, 1L);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.examineRange(2L, 0L);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT);
        this.examineRange(3L, 2L);
        this.expectMore(3L, 10, 0);
        this.expectJust(2L, 11, 0);
        this.closeAgentAndExamine();
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
    }

    @Test
    public void testExamineTxPending() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(1L, 13, TX_PENDING);
        this.expectJust(1L, 13, TX_PENDING);
        this.examineAll();
        this.expectMore(3L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END | TX_PENDING);
        this.examineBySubscription(0L);
        this.expectMore(3L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END | TX_PENDING);
        this.examineBySubscription(2L);
        this.expectMore(3L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectJust(2L, 11, TX_PENDING | SNAPSHOT_END);
        this.examineRange(0L, 0L);
        this.expectJust(0L, 0, REMOVE_EVENT | TX_PENDING);
        this.examineRange(0L, Long.MAX_VALUE);
        this.expectMore(0L, 0, REMOVE_EVENT | TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectJust(3L, 10, TX_PENDING);
        this.examineRange(1L, 2L);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(2L, 11, TX_PENDING);
        this.examineRange(2L, 3L);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectJust(3L, 10, TX_PENDING);
        this.examineRange(Long.MAX_VALUE, 0L);
        this.expectMore(3L, 10, TX_PENDING);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, REMOVE_EVENT | TX_PENDING);
        this.examineRange(2L, 1L);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectJust(1L, 13, TX_PENDING);
        this.examineRange(2L, 0L);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, REMOVE_EVENT | TX_PENDING);
        this.examineRange(3L, 2L);
        this.expectMore(3L, 10, TX_PENDING);
        this.expectJust(2L, 11, TX_PENDING);
        this.closeAgentAndExamine();
        this.expectMore(3L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END | TX_PENDING);
    }

    @Test
    public void testExamineDuringSnapshotUpdate() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 13, 0);
        if (this.unconflated) {
            this.expectMore(3L, 10, (this.blocking ? 0 : TX_PENDING) | SNAPSHOT_BEGIN);
            this.expectMore(2L, 11, this.blocking ? 0 : TX_PENDING);
            this.expectJust(1L, 13, TX_PENDING);
        } else {
            this.expectJust(1L, 13, TX_PENDING);
        }
        this.examineAll();
        this.expectMore(3L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, TX_PENDING | REMOVE_EVENT | SNAPSHOT_END);
        this.examineBySubscription(0L);
        this.expectMore(3L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, TX_PENDING | REMOVE_EVENT | SNAPSHOT_END);
        this.examineBySubscription(2L);
        this.expectMore(3L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectJust(2L, 11, TX_PENDING | SNAPSHOT_END);
        this.examineRange(0L, 0L);
        this.expectJust(0L, 0, REMOVE_EVENT | TX_PENDING);
        this.examineRange(0L, Long.MAX_VALUE);
        this.expectMore(0L, 0, REMOVE_EVENT | TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectJust(3L, 10, TX_PENDING);
        this.examineRange(1L, 2L);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(2L, 11, TX_PENDING);
        this.examineRange(2L, 3L);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectJust(3L, 10, TX_PENDING);
        this.examineRange(Long.MAX_VALUE, 0L);
        this.expectMore(3L, 10, TX_PENDING);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, REMOVE_EVENT | TX_PENDING);
        this.examineRange(2L, 1L);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectJust(1L, 13, TX_PENDING);
        this.examineRange(2L, 0L);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, REMOVE_EVENT | TX_PENDING);
        this.examineRange(3L, 2L);
        this.expectMore(3L, 10, TX_PENDING);
        this.expectJust(2L, 11, TX_PENDING);
        this.closeAgentAndExamine();
        this.expectMore(3L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 0, TX_PENDING | REMOVE_EVENT | SNAPSHOT_END);
    }

    @Test
    public void testSnapshotThenSnip() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, SNAPSHOT_SNIP);
        if (this.unconflated) {
            this.expectMore(3L, 10, SNAPSHOT_BEGIN);
            this.expectMore(2L, 11, 0);
            this.expectJust(1L, 12, SNAPSHOT_SNIP);
        } else {
            this.expectJust(1L, 12, SNAPSHOT_SNIP);
        }
        this.distribute(3L, 10, SNAPSHOT_BEGIN | SNAPSHOT_SNIP);
        if (this.unconflated) {
            this.expectJust(3L, 10, SNAPSHOT_BEGIN | SNAPSHOT_SNIP);
        } else {
            this.expectJust(3L, 10, SNAPSHOT_SNIP);
        }
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, SNAPSHOT_SNIP);
        if (this.unconflated) {
            this.expectMore(3L, 10, (this.blocking ? SNAPSHOT_SNIP : 0) | SNAPSHOT_BEGIN);
            this.expectMore(2L, 11, 0);
            this.expectJust(1L, 12, SNAPSHOT_SNIP);
        } else {
            this.expectMore(2L, 11, 0);
            this.expectJust(1L, 12, SNAPSHOT_SNIP);
        }
        this.distribute(0L, 13, SNAPSHOT_END);
        this.expectJust(0L, 13, 0);
    }

    @Test
    public void testSnapshotThenSnip2ndOrder() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(1L, 12, SNAPSHOT_SNIP);
        this.expectJust(1L, 12, SNAPSHOT_SNIP);
        this.distribute(3L, 10, SNAPSHOT_SNIP);
        this.expectJust(3L, 10, SNAPSHOT_SNIP);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, SNAPSHOT_SNIP);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, SNAPSHOT_SNIP);
        this.distribute(0L, 13, 0);
        this.expectJust(0L, 13, 0);
    }

    @Test
    public void testSnapshotThenSnipLegacyAgent() {
        this.createAgent(0L, false);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, SNAPSHOT_SNIP);
        this.expectNothing();
        this.distribute(3L, 10, SNAPSHOT_BEGIN | SNAPSHOT_SNIP);
        this.expectMore(2L, 0, 0);
        this.expectJust(1L, 0, 0);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, SNAPSHOT_SNIP);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        this.expectJust(0L, 13, 0);
    }

    @Test
    public void testCleanupWithSnip() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(4L, 0, REMOVE_EVENT | SNAPSHOT_SNIP);
        this.expectJust(4L, 0, REMOVE_EVENT | SNAPSHOT_SNIP);
    }

    @Test
    public void testCleanupWithSnipLegacyAgent() {
        this.createAgent(0L, false);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(4L, 0, REMOVE_EVENT | SNAPSHOT_SNIP);
        this.expectMore(3L, 0, 0);
        this.expectMore(2L, 0, 0);
        this.expectJust(1L, 0, 0);
    }

    @Test
    public void testSnipAndUpdate() {
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, SNAPSHOT_SNIP);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, SNAPSHOT_SNIP);
        this.distribute(3L, 15, 0);
        this.distribute(2L, 14, 0);
        this.distribute(1L, 13, 0);
        this.expectMore(3L, 15, 0);
        this.expectMore(2L, 14, 0);
        this.expectJust(1L, 13, 0);
        this.distribute(4L, 16, 0);
        this.distribute(2L, 14, SNAPSHOT_SNIP);
        this.expectMore(4L, 16, 0);
        this.expectJust(2L, 14, SNAPSHOT_SNIP);
        this.examineAll();
        this.expectMore(4L, 16, SNAPSHOT_BEGIN);
        this.expectMore(3L, 15, 0);
        this.expectJust(2L, 14, SNAPSHOT_SNIP);
    }

    @Test
    public void testSnipAndUpdateLegacyAgent() {
        this.createAgent(0L, false);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, SNAPSHOT_SNIP);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(3L, 15, 0);
        this.distribute(2L, 14, 0);
        this.distribute(1L, 13, 0);
        this.expectMore(3L, 15, 0);
        this.expectMore(2L, 14, 0);
        this.expectJust(1L, 13, 0);
        this.distribute(4L, 16, 0);
        this.distribute(2L, 14, SNAPSHOT_SNIP);
        this.expectMore(4L, 16, 0);
        this.expectJust(1L, 0, 0);
        this.examineAll();
        this.expectMore(4L, 16, SNAPSHOT_BEGIN);
        this.expectMore(3L, 15, 0);
        this.expectJust(2L, 14, SNAPSHOT_SNIP);
    }

    @Test
    public void testSnipTimeKnown() {
        this.createAgent(0L, true);
        this.distribute(6L, 10, SNAPSHOT_BEGIN);
        this.distribute(5L, 11, 0);
        this.distribute(4L, 12, SNAPSHOT_SNIP);
        this.expectMore(6L, 10, SNAPSHOT_BEGIN);
        this.expectMore(5L, 11, 0);
        this.expectJust(4L, 12, SNAPSHOT_SNIP);
        this.distribute(3L, 13, SNAPSHOT_BEGIN);
        this.distribute(2L, 14, 0);
        this.distribute(1L, 15, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(3L, 13, (this.blocking ? TX_PENDING : 0) | SNAPSHOT_BEGIN);
            this.expectMore(2L, 14, this.blocking ? TX_PENDING : 0);
            this.expectMore(1L, 15, this.blocking ? TX_PENDING : 0);
            this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        } else {
            this.expectMore(6L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(5L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 13, TX_PENDING);
            this.expectMore(2L, 14, TX_PENDING);
            if (this.blocking) {
                this.expectMore(1L, 15, TX_PENDING);
                this.expectJust(0L, 0, REMOVE_EVENT);
            } else {
                this.expectJust(1L, 15, 0);
            }
        }
    }

    @Test
    public void testSnipWithPartialRetrieve() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, SNAPSHOT_SNIP);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.distribute(6L, 13, SNAPSHOT_BEGIN);
        this.distribute(5L, 14, 0);
        this.distribute(4L, 15, SNAPSHOT_SNIP);
        if (this.unconflated) {
            this.expectMore(6L, 13, SNAPSHOT_BEGIN);
            this.expectMore(5L, 14, 0);
            this.expectJust(4L, 15, SNAPSHOT_SNIP);
        } else {
            this.expectMore(6L, 13, TX_PENDING);
            this.expectMore(5L, 14, TX_PENDING);
            this.expectJust(4L, 15, SNAPSHOT_SNIP);
        }
    }

    @Test
    public void testSnipSubByHistorySubscriptionFilter() {
        this.createAgent(-2L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_SNIP);
    }

    @Test
    public void testSnipSubSnapshotSweepRemove() {
        this.createAgent(-2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, SNAPSHOT_SNIP);
        this.distribute(1L, 13, SNAPSHOT_BEGIN);
        if (this.unconflated) {
            this.expectJust(1L, 13, TX_PENDING | SNAPSHOT_BEGIN);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(2L, 0, REMOVE_EVENT | TX_PENDING);
        }
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        if (this.unconflated) {
            this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_SNIP);
        } else {
            this.expectJust(0L, 0, REMOVE_EVENT);
        }
    }

    @Test
    public void testSnipSubTxDirty1a() {
        if (this.blocking) {
            return;
        }
        this.createAgent(-2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.distribute(2L, 15, TX_PENDING);
        this.expectMore(4L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, TX_PENDING);
        this.expectMore(2L, 15, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 14, TX_PENDING | SNAPSHOT_SNIP);
        this.distribute(1L, 16, TX_PENDING);
        this.distribute(3L, 17, 0);
        this.expectMore(1L, 16, TX_PENDING);
        this.expectJust(3L, 17, 0);
    }

    @Test
    public void testSnipSubTxDirty1b() {
        if (this.blocking) {
            return;
        }
        this.createAgent(-2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.distribute(2L, 15, TX_PENDING);
        this.expectMore(4L, 10, TX_PENDING | SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, TX_PENDING);
        this.expectMore(2L, 15, TX_PENDING);
        this.expectMore(1L, 13, TX_PENDING);
        this.expectJust(0L, 14, TX_PENDING | SNAPSHOT_SNIP);
        this.distribute(1L, 13, TX_PENDING);
        this.distribute(3L, 11, 0);
        this.expectJust(3L, 11, 0);
    }

    @Test
    public void testSnipAndSweep() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, SNAPSHOT_END);
        this.distribute(2L, 0, REMOVE_EVENT | SNAPSHOT_BEGIN | SNAPSHOT_SNIP);
        if (this.unconflated) {
            this.expectJust(2L, 0, REMOVE_EVENT | SNAPSHOT_BEGIN | SNAPSHOT_SNIP);
        } else {
            this.expectMore(4L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectMore(3L, 0, REMOVE_EVENT | TX_PENDING);
            this.expectJust(2L, 0, REMOVE_EVENT | SNAPSHOT_SNIP);
        }
    }

    @Test
    public void testSnipAndSweepLegacy() {
        this.createAgent(0L, false);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(4L, 10, 0);
        this.expectMore(3L, 11, 0);
        this.expectMore(2L, 12, 0);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, 0);
        this.distribute(2L, 0, REMOVE_EVENT | SNAPSHOT_BEGIN | SNAPSHOT_SNIP);
        this.expectMore(4L, 0, 0);
        this.expectMore(3L, 0, 0);
        this.expectMore(2L, 0, 0);
        this.expectMore(1L, 0, 0);
        this.expectJust(0L, 0, 0);
    }

    @Test
    public void testReceivePart() {
        this.createAgent(0L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, SNAPSHOT_END);
    }

    @Test
    public void testLegacyReceivePart() {
        this.createAgent(0L, false);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, 0);
        this.expectMore(4L, 10, 0);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 12, 0);
        this.distribute(1L, 13, 0);
        this.distribute(0L, 14, SNAPSHOT_END);
        this.expectMore(1L, 13, 0);
        this.expectJust(0L, 14, 0);
    }

    @Test
    public void testPartialRetrieveUpdateInconsistency() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.distribute(2L, 14, 0);
        this.distribute(1L, 15, 0);
        this.expectMore(1L, 15, TX_PENDING);
        this.expectMore(0L, 13, TX_PENDING | SNAPSHOT_END);
        this.expectJust(2L, 14, 0);
    }

    @Test
    public void testPartialRetrieveUpdateLegacySource() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(3L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 13, 0);
        this.expectMore(3L, 10, 0);
        this.expectMore(2L, 11, 0);
        this.distribute(2L, 14, 0);
        this.distribute(1L, 15, 0);
        this.expectMore(1L, 15, 0);
        this.expectMore(0L, 13, 0);
        this.expectJust(2L, 14, 0);
    }

    @Test
    public void testInconsistentSnapshotRetrieveMT1() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(3L, 9, SNAPSHOT_BEGIN);
        this.startBatch();
        this.distribute(2L, 10, 0);
        this.distribute(1L, 11, 0);
        this.distribute(0L, 12, SNAPSHOT_END);
        this.distribute(2L, 13, 0);
        this.distribute(1L, 14, 0);
        this.betweenProcessPhases = () -> {
            this.expectMore(3L, 9, TX_PENDING | SNAPSHOT_BEGIN);
            this.expectMore(2L, 13, TX_PENDING);
            this.expectMore(1L, 14, TX_PENDING);
            this.expectJust(0L, 12, TX_PENDING | SNAPSHOT_END);
        };
        this.processBatch();
        this.expectMore(2L, 10, TX_PENDING);
        this.expectMore(1L, 11, TX_PENDING);
        this.expectMore(0L, 12, TX_PENDING);
        this.expectMore(2L, 13, TX_PENDING);
        this.expectJust(1L, 14, 0);
    }

    @Test
    public void testLostTxPending1() {
        if (this.blocking) {
            return;
        }
        this.createAgent(-2L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(3L, 13, TX_PENDING);
        this.betweenProcessPhases = () -> {
            this.history.forceRetrieveUpdate = true;
            this.expectMore(3L, 13, TX_PENDING);
            this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_SNIP | TX_PENDING);
        };
        this.distribute(2L, 14, 0);
        this.expectJust(2L, 14, 0);
    }

    @Test
    public void testLostTxPending2() {
        if (this.blocking) {
            return;
        }
        this.createAgent(-2L, true);
        this.distribute(2L, 10, SNAPSHOT_BEGIN);
        this.distribute(1L, 11, 0);
        this.expectMore(2L, 10, SNAPSHOT_BEGIN);
        this.expectJust(1L, 11, 0);
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(1L, 12, TX_PENDING);
        this.startBatch();
        this.distribute(-1L, 13, REMOVE_EVENT);
        this.distribute(2L, 14, TX_PENDING);
        this.processBatch();
        this.history.forceRetrieveUpdate = true;
        this.expectMore(1L, 12, TX_PENDING);
        this.expectMore(2L, 14, TX_PENDING);
        this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_SNIP | TX_PENDING);
    }

    @Test
    public void testLostTxPending3() {
        if (this.blocking) {
            return;
        }
        this.createAgent(-2L, true);
        this.distribute(3L, 7, TX_PENDING);
        this.expectJust(3L, 7, TX_PENDING);
        this.distribute(2L, 8, TX_PENDING);
        this.distribute(1L, 9, 0);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN | TX_PENDING);
        this.expectJust(2L, 11, TX_PENDING);
        this.distribute(1L, 12, 0);
        this.startBatch();
        this.distribute(0L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(1L, 13, TX_PENDING);
        this.distribute(2L, 14, 0);
        this.distribute(1L, 15, TX_PENDING);
        this.distribute(2L, 16, 0);
        this.betweenProcessPhases = () -> {
            this.expectMore(1L, 15, TX_PENDING);
            this.expectJust(0L, 0, REMOVE_EVENT | SNAPSHOT_SNIP | TX_PENDING);
        };
        this.processBatch();
        this.expectMore(1L, 13, TX_PENDING);
        this.expectMore(2L, 14, TX_PENDING);
        this.expectMore(1L, 15, TX_PENDING);
        this.expectJust(2L, 16, 0);
    }

    @Test
    public void testLostTxPending4() {
        if (this.blocking || this.unconflated) {
            return;
        }
        this.createAgent(-2L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.expectJust(3L, 10, SNAPSHOT_BEGIN);
        this.startBatch();
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(-1L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(1L, 13, TX_PENDING);
        this.processBatch();
        this.startBatch();
        this.distribute(2L, 14, 0);
        this.distribute(1L, 15, TX_PENDING);
        this.distribute(2L, 16, 0);
        this.betweenProcessPhases = () -> {
            this.expectMore(2L, 16, TX_PENDING);
            this.expectMore(1L, 15, TX_PENDING);
            this.expectJust(0L, 0, TX_PENDING | REMOVE_EVENT | SNAPSHOT_SNIP);
        };
        this.processBatch();
        this.startBatch();
        this.distribute(2L, 17, TX_PENDING);
        this.distribute(1L, 18, 0);
        this.processBatch();
        this.startBatch();
        this.distribute(1L, 19, TX_PENDING);
        this.distribute(2L, 20, 0);
        this.betweenProcessPhases = () -> this.expectMore(2L, 14, TX_PENDING);
        this.processBatch();
        this.expectMore(1L, 15, TX_PENDING);
        this.expectMore(2L, 17, TX_PENDING);
        this.expectMore(1L, 19, TX_PENDING);
        this.expectJust(2L, 20, 0);
    }

    @Test
    public void testLostTxPending5() {
        this.createAgent2(0L, true);
        this.createAgent(2L, true);
        this.distribute(1L, 10, SNAPSHOT_BEGIN);
        this.distribute(0L, 11, SNAPSHOT_END);
        this.expectJust(2L, 0, SNAPSHOT_BEGIN | SNAPSHOT_END | REMOVE_EVENT);
        this.startBatch();
        this.distribute(1L, 12, TX_PENDING);
        this.distribute(0L, 13, 0);
        this.distribute(0L, 14, TX_PENDING);
        this.distribute(1L, 15, 0);
        this.betweenProcessPhases = () -> {
            this.unsubscribeAgent();
            this.setSubTime(0L);
            this.expectMore(1L, 15, SNAPSHOT_BEGIN);
            this.expectJust(0L, 14, SNAPSHOT_END);
        };
        this.processBatch();
        this.expectNothing();
    }

    @Test
    public void testLostTxPending6() {
        this.createAgent2(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        this.createAgent(1L, true);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectJust(1L, 12, SNAPSHOT_END);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.closeAgent2();
        this.distribute(2L, 13, 0);
        this.distribute(1L, 14, 0);
        this.distribute(0L, 15, SNAPSHOT_END);
        this.distribute(2L, 16, TX_PENDING);
        this.distribute(3L, 17, TX_PENDING);
        this.distribute(1L, 18, 0);
        this.distribute(3L, 17, SNAPSHOT_BEGIN);
        this.distribute(2L, 19, 0);
        this.distribute(1L, 20, SNAPSHOT_END);
        if (this.unconflated && this.blocking) {
            this.expectMore(3L, 10, SNAPSHOT_BEGIN);
            this.expectMore(2L, 13, TX_PENDING);
            this.expectMore(1L, 14, SNAPSHOT_END);
            this.expectMore(2L, 16, TX_PENDING);
            this.expectMore(3L, 17, TX_PENDING);
            this.expectMore(1L, 18, 0);
            this.expectMore(3L, 17, SNAPSHOT_BEGIN);
            this.expectMore(2L, 19, TX_PENDING);
            this.expectJust(1L, 20, SNAPSHOT_END);
        } else if (this.unconflated) {
            this.expectMore(3L, 17, SNAPSHOT_BEGIN);
            this.expectMore(2L, 19, 0);
            this.expectJust(1L, 20, SNAPSHOT_END);
        } else {
            this.expectMore(2L, 13, TX_PENDING);
            this.expectMore(1L, 14, 0);
            this.expectMore(2L, 16, TX_PENDING);
            this.expectMore(3L, 17, TX_PENDING);
            this.expectMore(1L, 18, 0);
            this.expectMore(2L, 19, TX_PENDING);
            this.expectJust(1L, 20, 0);
        }
    }

    @Test
    public void testBeginSnapshotBufferClear() {
        if (this.blocking) {
            return;
        }
        this.createAgent(1L, true);
        this.distribute(2L, 10, 0);
        this.expectJust(2L, 10, 0);
        this.distribute(1L, 11, 0);
        this.distribute(2L, 12, 0);
        this.distribute(2L, 13, SNAPSHOT_BEGIN);
        this.distribute(1L, 14, SNAPSHOT_END);
        this.expectMore(2L, 13, SNAPSHOT_BEGIN);
        this.expectMore(1L, 14, SNAPSHOT_END);
        this.expectNothingRetrieves();
    }

    @Test
    public void testAgent2BreaksSnapshot() {
        this.createAgent2(10L, true);
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 13, SNAPSHOT_END);
        this.closeAgent();
        this.createAgent(0L, true);
        this.distribute(1L, 14, 0);
        this.distribute(0L, 15, 0);
        this.expectNothing();
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 14, 0);
        this.distribute(0L, 15, SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 14, 0);
        this.expectJust(0L, 15, SNAPSHOT_END);
    }

    @Test
    public void testAgent2WithLargerSub() {
        this.createAgent2(0L, true);
        this.createAgent(2L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectJust(2L, 11, SNAPSHOT_END);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(3L, 10, SNAPSHOT_BEGIN);
            this.expectJust(2L, 11, SNAPSHOT_END);
        } else {
            this.expectNothing();
        }
    }

    @Test
    public void testAgent2StillConsistentOnTotalSubReduce() {
        this.createAgent(2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 12, SNAPSHOT_END);
        this.createAgent2(0L, true);
        this.distribute(4L, 13, TX_PENDING);
        this.distribute(3L, 14, TX_PENDING);
        this.distribute(2L, 15, 0);
        this.expectMore(4L, 13, TX_PENDING);
        this.expectMore(3L, 14, TX_PENDING);
        this.expectJust(2L, 15, 0);
        this.distribute(4L, 13, SNAPSHOT_BEGIN);
        this.distribute(3L, 14, 0);
        this.distribute(2L, 15, 0);
        this.distribute(1L, 16, 0);
        this.distribute(0L, 17, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(4L, 13, SNAPSHOT_BEGIN);
            this.expectMore(3L, 14, 0);
            this.expectJust(2L, 15, SNAPSHOT_END);
        } else {
            this.expectNothing();
        }
        this.setSubTime2(10L);
        this.distribute(4L, 18, TX_PENDING);
        this.distribute(3L, 19, TX_PENDING);
        this.distribute(2L, 20, 0);
        this.expectMore(4L, 18, TX_PENDING);
        this.expectMore(3L, 19, TX_PENDING);
        this.expectJust(2L, 20, 0);
        this.distribute(4L, 18, SNAPSHOT_BEGIN);
        this.distribute(3L, 19, 0);
        this.distribute(2L, 20, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(4L, 18, SNAPSHOT_BEGIN);
            this.expectMore(3L, 19, 0);
            this.expectJust(2L, 20, SNAPSHOT_END);
        } else {
            this.expectNothing();
        }
    }

    @Test
    public void testNonSubscribedUpdates() {
        this.createAgent2(10L, true);
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, 0);
        this.distribute(1L, 12, 0);
        this.distribute(0L, 13, SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectMore(2L, 11, 0);
        this.expectMore(1L, 12, 0);
        this.expectJust(0L, 13, SNAPSHOT_END);
        this.setSubTime(10L);
        this.distribute(3L, 14, SNAPSHOT_BEGIN);
        this.distribute(2L, 15, 0);
        this.distribute(1L, 16, 0);
        this.distribute(0L, 17, SNAPSHOT_END);
        if (this.unconflated && this.blocking) {
            this.expectMore(10L, 0, SNAPSHOT_BEGIN | SNAPSHOT_END | REMOVE_EVENT);
        }
        this.expectJust(10L, 0, SNAPSHOT_BEGIN | SNAPSHOT_END | REMOVE_EVENT);
        this.closeAgent();
        this.createAgent(0L, true);
        this.expectNothing();
    }

    @Test
    public void testTwoSweep() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(0L, 10, 0);
        this.distribute(2L, 11, 0);
        this.distribute(3L, 12, 0);
        this.distribute(4L, 13, 0);
        this.distribute(4L, 14, SNAPSHOT_BEGIN);
        this.distribute(0L, 15, 0);
        this.distribute(-1L, 0, REMOVE_EVENT | SNAPSHOT_END);
        this.distribute(4L, 15, TX_PENDING);
        this.distribute(0L, 16, 0);
        this.expectMore(4L, 15, SNAPSHOT_BEGIN);
        this.expectJust(0L, 16, SNAPSHOT_END);
    }

    @Test
    public void testLowerSnapshot() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(3L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 11, SNAPSHOT_END);
        this.expectMore(3L, 10, SNAPSHOT_BEGIN);
        this.expectJust(2L, 11, 0);
        this.distribute(1L, 12, SNAPSHOT_BEGIN);
        this.distribute(0L, 13, SNAPSHOT_END);
        if (this.unconflated) {
            this.expectMore(1L, 12, SNAPSHOT_BEGIN);
            this.expectJust(0L, 13, SNAPSHOT_END);
        } else {
            this.expectMore(1L, 12, TX_PENDING);
            this.expectMore(0L, 13, TX_PENDING | SNAPSHOT_END);
            this.expectMore(3L, 0, TX_PENDING | REMOVE_EVENT);
            this.expectJust(2L, 0, REMOVE_EVENT);
        }
    }

    @Test
    public void testImplicitTxPending() {
        if (this.blocking) {
            return;
        }
        this.createAgent(0L, true);
        this.distribute(2L, 10, SNAPSHOT_BEGIN);
        this.distribute(1L, 11, 0);
        this.distribute(0L, 0, SNAPSHOT_END | REMOVE_EVENT);
        this.expectMore(2L, 10, SNAPSHOT_BEGIN);
        this.distribute(2L, 12, 0);
        this.expectMore(1L, 11, TX_PENDING);
        this.expectMore(0L, 0, TX_PENDING | SNAPSHOT_END | REMOVE_EVENT);
        this.expectJust(2L, 12, 0);
    }

    @Test
    public void testQD985TxPendingHang() {
        if (this.blocking) {
            return;
        }
        this.createAgent2(1L, true);
        this.distribute(5L, 10, TX_PENDING);
        this.distribute(4L, 11, 0);
        this.createAgent(5L, true);
        this.startBatch();
        this.distribute(5L, 12, SNAPSHOT_BEGIN);
        this.distribute(3L, 13, 0);
        this.distribute(2L, 14, 0);
        this.distribute(1L, 15, SNAPSHOT_END);
        this.distribute(1L, 16, TX_PENDING);
        this.distribute(2L, 17, 0);
        this.processBatch();
        this.expectJust(5L, 12, SNAPSHOT_BEGIN | SNAPSHOT_END);
    }

    @Test
    public void testRemoveEventWithVirtualTimeOnSnipForSecondAgentTxDirty() {
        this.createAgent(2L, true);
        this.distribute(4L, 10, SNAPSHOT_BEGIN);
        this.distribute(3L, 11, 0);
        this.distribute(2L, 12, SNAPSHOT_END);
        this.expectMore(4L, 10, SNAPSHOT_BEGIN);
        this.expectMore(3L, 11, 0);
        this.expectJust(2L, 12, SNAPSHOT_END);
        this.createAgent2(-2L, true);
        this.distribute(1L, 13, TX_PENDING);
        this.distribute(0L, 14, SNAPSHOT_SNIP);
        this.expectJust(Long.MAX_VALUE, 0, REMOVE_EVENT);
        this.closeAgent2();
        this.closeAgent();
    }

    private void createAgent(long timeSub, boolean useHistorySnapshot) {
        Assert.assertEquals(null, (Object)this.agent);
        this.agent = this.history.agentBuilder().withHistorySnapshot(useHistorySnapshot).build();
        this.setSubTime(timeSub);
        this.provider = this.getProvider(this.agent);
        this.provider.setRecordListener(p -> {
            Assert.assertTrue((String)"!available", (!this.available ? 1 : 0) != 0);
            Assert.assertEquals((Object)this.provider, (Object)p);
            this.available = true;
        });
    }

    private void setSubTime(long timeSub) {
        RecordBuffer sub = RecordBuffer.getInstance((RecordMode)RecordMode.HISTORY_SUBSCRIPTION);
        RecordCursor cursor = sub.add(RECORD, CIPHER, null);
        cursor.setTime(timeSub);
        this.agent.addSubscription((RecordSource)sub);
        sub.release();
    }

    private void unsubscribeAgent() {
        RecordBuffer sub = RecordBuffer.getInstance((RecordMode)RecordMode.HISTORY_SUBSCRIPTION);
        this.agent.setSubscription((RecordSource)sub);
        sub.release();
    }

    void closeAgent() {
        this.agent.close();
        this.agent = null;
        this.provider = null;
        this.blockingProvider = null;
        this.blockingListener = null;
        Assert.assertTrue((String)"!available", (!this.available ? 1 : 0) != 0);
    }

    private void createAgent2(long timeSub, boolean useHistorySnapshot) {
        Assert.assertEquals(null, (Object)this.agent2);
        this.agent2 = this.history.agentBuilder().withHistorySnapshot(useHistorySnapshot).build();
        this.setSubTime2(timeSub);
    }

    private void setSubTime2(long timeSub) {
        RecordBuffer sub = RecordBuffer.getInstance((RecordMode)RecordMode.HISTORY_SUBSCRIPTION);
        RecordCursor cursor = sub.add(RECORD, CIPHER, null);
        cursor.setTime(timeSub);
        this.agent2.addSubscription((RecordSource)sub);
        sub.release();
    }

    private void closeAgent2() {
        this.agent2.close();
        this.agent2 = null;
    }

    private void examineAll() {
        RecordBuffer buf = RecordBuffer.getInstance((RecordMode)RecordMode.FLAGGED_DATA);
        this.history.examineData((RecordSink)buf);
        this.provider = buf;
        this.available = buf.hasNext();
    }

    private void examineBySubscription(long time) {
        RecordBuffer sub = RecordBuffer.getInstance((RecordMode)RecordMode.HISTORY_SUBSCRIPTION);
        sub.add(RECORD, CIPHER, null).setTime(time);
        RecordBuffer buf = RecordBuffer.getInstance((RecordMode)RecordMode.FLAGGED_DATA);
        this.history.examineDataBySubscription((RecordSink)buf, (RecordSource)sub);
        sub.release();
        this.provider = buf;
        this.available = buf.hasNext();
    }

    private void examineRange(long startTime, long endTime) {
        RecordBuffer buf = RecordBuffer.getInstance((RecordMode)RecordMode.FLAGGED_DATA);
        this.history.examineData(RECORD, CIPHER, null, startTime, endTime, (RecordSink)buf);
        this.provider = buf;
        this.available = buf.hasNext();
    }

    private void closeAgentAndExamine() {
        RecordBuffer buf = RecordBuffer.getInstance((RecordMode)RecordMode.FLAGGED_DATA);
        this.agent.closeAndExamineDataBySubscription((RecordSink)buf);
        this.agent = null;
        this.provider = buf;
        this.available = buf.hasNext();
    }

    RecordProvider getProvider(final QDAgent agent) {
        if (!this.blocking) {
            return agent;
        }
        agent.setBufferOverflowStrategy(QDAgent.BufferOverflowStrategy.BLOCK);
        agent.setMaxBufferSize(1);
        final RecordBuffer buf = RecordBuffer.getInstance((RecordMode)agent.getMode());
        this.blockingProvider = new AbstractRecordProvider(){

            public RecordMode getMode() {
                return agent.getMode();
            }

            public boolean retrieve(RecordSink sink) {
                return buf.retrieve(sink);
            }

            public void setRecordListener(RecordListener listener) {
                HistoryTxTest.this.blockingListener = listener;
                if (listener != null && buf.hasNext()) {
                    listener.recordsAvailable(HistoryTxTest.this.blockingProvider);
                }
            }
        };
        AbstractRecordSink conflatingSink = new AbstractRecordSink(){
            long lastPosition = -1L;

            public void append(RecordCursor cursor) {
                RecordCursor writeCursor;
                if (this.lastPosition >= buf.getPosition() && (writeCursor = buf.writeCursorAt(this.lastPosition)).getTime() == cursor.getTime() && !HistoryTxTest.this.unconflated) {
                    writeCursor.setEventFlags(cursor.getEventFlags());
                    writeCursor.copyDataFrom(cursor);
                    return;
                }
                this.lastPosition = buf.getLimit();
                buf.append(cursor);
            }
        };
        agent.setRecordListener(arg_0 -> this.lambda$getProvider$7(buf, agent, (RecordSink)conflatingSink, arg_0));
        return this.blockingProvider;
    }

    private void startBatch() {
        this.distributeBatch = true;
    }

    private void distribute(long time, int value, int flags) {
        RecordCursor cursor = this.distributeBuf.add(RECORD, CIPHER, null);
        cursor.setTime(time);
        cursor.setInt(2, value);
        cursor.setEventFlags(flags);
        if (!this.distributeBatch) {
            this.processBatch();
        }
    }

    private void processBatch() {
        this.distributor.process((RecordSource)this.distributeBuf);
        this.distributeBuf.clear();
        this.distributeBatch = false;
    }

    private void removeData() {
        RecordBuffer buf = RecordBuffer.getInstance((RecordMode)RecordMode.FLAGGED_DATA);
        buf.add(RECORD, CIPHER, null);
        this.history.remove((RecordSource)buf);
        buf.release();
    }

    private void expectMore(long time, int value, int flags) {
        this.expect(time, value, flags);
        Assert.assertTrue((String)"available", (this.available || !this.retrieveBuf.isEmpty() ? 1 : 0) != 0);
    }

    private void expectJust(long time, int value, int flags) {
        this.expect(time, value, flags);
        Assert.assertTrue((String)"!available", (!this.available && this.retrieveBuf.isEmpty() ? 1 : 0) != 0);
    }

    private void expectUnconflated(long time, int value, int flags) {
        if (this.unconflated) {
            this.expect(time, value, flags);
        }
    }

    private void expect(long time, int value, int flags) {
        Assert.assertTrue((String)"available", (this.available || !this.retrieveBuf.isEmpty() ? 1 : 0) != 0);
        if (this.retrieveBuf.isEmpty()) {
            this.retrieveBatch(1);
        }
        RecordCursor cursor = this.retrieveBuf.next();
        Assert.assertNotNull((Object)cursor);
        Assert.assertEquals((String)"record", (Object)RECORD, (Object)cursor.getRecord());
        Assert.assertEquals((String)"cipher", (long)CIPHER, (long)cursor.getCipher());
        Assert.assertNull((String)"symbol", (Object)cursor.getSymbol());
        Assert.assertEquals((String)"time", (long)time, (long)cursor.getTime());
        Assert.assertEquals((String)"value", (long)value, (long)cursor.getInt(2));
        Assert.assertEquals((String)"flags", (long)flags, (long)cursor.getEventFlags());
        if (time == Long.MAX_VALUE) {
            int cursorFlags = cursor.getEventFlags();
            Assert.assertEquals((long)cursorFlags, (long)(cursorFlags & ~SNAPSHOT_BEGIN & ~SNAPSHOT_END & ~SNAPSHOT_SNIP & ~SNAPSHOT_MODE));
        }
        this.retrieveBuf.cleanup(cursor);
    }

    private void expectNothing() {
        Assert.assertTrue((String)"!available", (!this.available && this.retrieveBuf.isEmpty() ? 1 : 0) != 0);
        this.expectNothingRetrieves();
    }

    private void expectNothingRetrieves() {
        boolean hasMore = this.provider.retrieve((RecordSink)new AbstractRecordSink(){

            public void append(RecordCursor cursor) {
                Assert.fail();
            }
        });
        Assert.assertFalse((boolean)hasMore);
        this.available = false;
    }

    private void retrieveBatch(final int size) {
        Assert.assertTrue((String)"available", (boolean)this.available);
        Assert.assertEquals((long)0L, (long)this.retrieveBuf.size());
        this.available = false;
        boolean hasMore = this.provider.retrieve((RecordSink)new AbstractRecordSink(){
            int rem;
            {
                this.rem = size;
            }

            public boolean hasCapacity() {
                return this.rem > 0;
            }

            public void append(RecordCursor cursor) {
                Assert.assertTrue((this.rem > 0 ? 1 : 0) != 0);
                --this.rem;
                HistoryTxTest.this.retrieveBuf.append(cursor);
            }
        });
        Assert.assertEquals((String)"received", (long)size, (long)this.retrieveBuf.size());
        Assert.assertFalse((String)"!available", (boolean)this.available);
        this.available = hasMore;
    }

    private /* synthetic */ void lambda$getProvider$7(RecordBuffer buf, QDAgent agent, RecordSink conflatingSink, RecordProvider p) {
        boolean wasEmpty = !buf.hasNext();
        agent.retrieve(conflatingSink);
        if (wasEmpty && buf.hasNext() && this.blockingListener != null) {
            this.blockingListener.recordsAvailable(this.blockingProvider);
        }
    }

    private class HistoryImpl
    extends History {
        boolean forceRetrieveUpdate;

        HistoryImpl(QDCollector.Builder<QDHistory> builder) {
            super(builder, new RecordOnlyFilter(builder.getScheme()){

                public boolean acceptRecord(DataRecord record) {
                    return !HistoryTxTest.this.unconflated;
                }
            });
        }

        protected void onBetweenProcessPhases() {
            if (HistoryTxTest.this.betweenProcessPhases != null) {
                HistoryTxTest.this.betweenProcessPhases.run();
                HistoryTxTest.this.betweenProcessPhases = null;
            }
        }

        protected boolean shallForceRetrieveUpdate() {
            return this.forceRetrieveUpdate;
        }
    }

    private static class HSF
    implements HistorySubscriptionFilter {
        private HSF() {
        }

        public long getMinHistoryTime(DataRecord record, int cipher, String symbol) {
            return 0L;
        }

        public int getMaxRecordCount(DataRecord record, int cipher, String symbol) {
            return Integer.MAX_VALUE;
        }
    }
}

