/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.stats;

import com.devexperts.qd.stats.QDStats;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class QDStatsTest {
    private static final QDStats.SType BOX = new QDStats.SType("Box", 6, new QDStats.SType[0]);
    private static final QDStats.SType APPLE = new QDStats.SType("Apple", 6, new QDStats.SType[0]);
    private static final QDStats.SType ORANGE = new QDStats.SType("Orange", 6, new QDStats.SType[0]);
    private static final QDStats.SValue VALUE = QDStats.SValue.IO_READ_BYTES;

    @Test
    public void testSimple() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        this.updateValue(box, 1L);
        this.updateValue(box, 2L);
        this.updateValue(box, 4L);
        Assert.assertEquals((long)7L, (long)box.getValue(VALUE));
        Assert.assertEquals((long)7L, (long)root.getValue(VALUE));
    }

    @Test
    public void testGet() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box1 = root.create(BOX);
        QDStats box2 = root.create(BOX, "key=value2");
        QDStats box3 = root.getOrCreate(BOX, "key=value3");
        Assert.assertNotSame((Object)box1, (Object)box3);
        Assert.assertNotSame((Object)box2, (Object)box3);
        Assert.assertSame((Object)box1, (Object)root.get(BOX));
        Assert.assertSame((Object)box2, (Object)root.get(BOX, "key=value2"));
        Assert.assertSame((Object)box3, (Object)root.get(BOX, "key=value3"));
        List stats = root.getAll(BOX);
        Assert.assertNotNull((Object)stats);
        Assert.assertEquals((long)3L, (long)stats.size());
        Assert.assertSame((Object)box1, (Object)root.getOrCreate(BOX));
        Assert.assertSame((Object)box2, (Object)root.getOrCreate(BOX, "key=value2"));
        Assert.assertSame((Object)QDStats.VOID, (Object)root.getOrVoid(APPLE));
    }

    @Test
    public void testEquivalenceRelation() {
        QDStats.SType A = new QDStats.SType("A");
        QDStats.SType B = new QDStats.SType("B", 0, new QDStats.SType[]{A});
        QDStats.SType C = new QDStats.SType("C", 0, new QDStats.SType[]{B});
        Assert.assertTrue((boolean)A.isSameAs(A));
        Assert.assertTrue((boolean)A.isSameAs(B));
        Assert.assertTrue((boolean)A.isSameAs(C));
        Assert.assertTrue((boolean)B.isSameAs(C));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidEquivalence() {
        QDStats.SType A = new QDStats.SType("A");
        QDStats.SType B = new QDStats.SType("B");
        QDStats.SType C = new QDStats.SType("C", 0, new QDStats.SType[]{A, B});
    }

    @Test
    public void testSimpleTree() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        QDStats apple = box.create(APPLE);
        QDStats orange = box.create(ORANGE);
        this.updateValue(apple, 1L);
        this.updateValue(orange, 2L);
        this.updateValue(box, 4L);
        Assert.assertEquals((long)1L, (long)apple.getValue(VALUE));
        Assert.assertEquals((long)2L, (long)orange.getValue(VALUE));
        Assert.assertEquals((long)4L, (long)box.getValue(VALUE, true));
        Assert.assertEquals((long)7L, (long)box.getValue(VALUE));
        Assert.assertEquals((long)7L, (long)root.getValue(VALUE));
        Assert.assertEquals((long)1L, (long)root.get(APPLE).getValue(VALUE));
        Assert.assertEquals((long)2L, (long)root.get(ORANGE).getValue(VALUE));
    }

    @Test
    public void testSumTotal() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box1 = root.create(BOX);
        QDStats apple1 = box1.create(APPLE);
        QDStats orange1 = box1.create(ORANGE);
        QDStats orange2 = box1.create(ORANGE);
        QDStats box2 = root.create(BOX);
        QDStats apple2 = box2.create(APPLE);
        QDStats apple3 = box2.create(APPLE);
        QDStats orange3 = box2.create(ORANGE);
        this.updateValue(apple1, 1L);
        this.updateValue(apple2, 2L);
        this.updateValue(apple3, 4L);
        this.updateValue(orange1, 10L);
        this.updateValue(orange2, 20L);
        this.updateValue(orange3, 40L);
        Assert.assertEquals((long)31L, (long)box1.getValue(VALUE));
        Assert.assertEquals((long)46L, (long)box2.getValue(VALUE));
        Assert.assertEquals((long)77L, (long)root.getValue(VALUE));
        Assert.assertEquals((long)7L, (long)root.get(APPLE).getValue(VALUE));
        Assert.assertEquals((long)70L, (long)root.get(ORANGE).getValue(VALUE));
    }

    @Test
    public void testSumMixed() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        QDStats apple1 = box.create(APPLE);
        QDStats apple2 = box.create(APPLE);
        QDStats orange1 = box.create(ORANGE);
        QDStats orange2 = box.create(ORANGE);
        QDStats apple3 = orange2.create(APPLE);
        QDStats orange3 = orange2.create(ORANGE);
        this.updateValue(apple1, 1L);
        this.updateValue(apple2, 2L);
        this.updateValue(apple3, 4L);
        this.updateValue(orange1, 10L);
        this.updateValue(orange2, 20L);
        this.updateValue(orange3, 40L);
        Assert.assertEquals((long)64L, (long)orange2.getValue(VALUE));
        Assert.assertEquals((long)7L, (long)root.get(APPLE).getValue(VALUE));
        Assert.assertEquals((long)70L, (long)root.get(ORANGE).getValue(VALUE));
    }

    @Test
    public void testSumWithClosed() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        QDStats apple1 = box.create(APPLE, "n=apple1");
        QDStats apple2 = box.create(APPLE, "n=apple2");
        QDStats orange1 = box.create(ORANGE, "n=orange1");
        QDStats orange2 = box.create(ORANGE, "n=orange2");
        this.updateValue(apple1, 1L);
        this.updateValue(apple2, 2L);
        this.updateValue(orange1, 10L);
        this.updateValue(orange2, 20L);
        Assert.assertEquals((long)3L, (long)root.get(APPLE).getValue(VALUE));
        Assert.assertEquals((long)30L, (long)root.get(ORANGE).getValue(VALUE));
        Assert.assertEquals((long)33L, (long)box.getValue(VALUE));
        Assert.assertEquals((long)33L, (long)root.getValue(VALUE));
        apple2.close();
        orange2.close();
        Assert.assertEquals((long)3L, (long)root.get(APPLE).getValue(VALUE));
        Assert.assertEquals((long)30L, (long)root.get(ORANGE).getValue(VALUE));
        Assert.assertEquals((long)11L, (long)box.getValue(VALUE));
        Assert.assertEquals((long)33L, (long)root.getValue(VALUE));
    }

    @Test
    public void testSameTypeTree() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        QDStats box1 = box.create(BOX, "n=box1");
        QDStats box11 = box1.create(BOX, "nn=box11");
        QDStats box12 = box1.create(BOX, "nn=box12");
        QDStats box2 = box.create(BOX, "n=box2");
        QDStats box21 = box2.create(BOX, "nn=box21");
        QDStats box22 = box2.create(BOX, "nn=box22");
        this.updateValue(box11, 1L);
        this.updateValue(box12, 2L);
        this.updateValue(box21, 10L);
        this.updateValue(box22, 20L);
        Assert.assertEquals((long)0L, (long)box1.getValue(VALUE, true));
        Assert.assertEquals((long)3L, (long)box1.getValue(VALUE));
        Assert.assertEquals((long)0L, (long)box2.getValue(VALUE, true));
        Assert.assertEquals((long)30L, (long)box2.getValue(VALUE));
        Assert.assertEquals((long)33L, (long)box.getValue(VALUE));
        Assert.assertEquals((long)33L, (long)root.getValue(VALUE));
        box12.close();
        box22.close();
        Assert.assertEquals((long)2L, (long)box1.getValue(VALUE, true));
        Assert.assertEquals((long)3L, (long)box1.getValue(VALUE));
        Assert.assertEquals((long)20L, (long)box2.getValue(VALUE, true));
        Assert.assertEquals((long)30L, (long)box2.getValue(VALUE));
        Assert.assertEquals((long)33L, (long)box.getValue(VALUE));
        Assert.assertEquals((long)33L, (long)root.getValue(VALUE));
    }

    @Test
    public void testCloseMiddleStats() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        QDStats apple = box.create(APPLE, "n=apple1");
        QDStats orange = apple.create(ORANGE, "n=orange1");
        this.updateValue(box, 1L);
        this.updateValue(apple, 2L);
        this.updateValue(orange, 4L);
        Assert.assertEquals((long)7L, (long)box.getValue(VALUE));
        apple.close();
        Assert.assertEquals((long)5L, (long)box.getValue(VALUE));
        Assert.assertEquals((long)7L, (long)root.getValue(VALUE));
    }

    @Test
    public void testCloseRootChildStats() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        this.updateValue(box, 1L);
        Assert.assertEquals((long)1L, (long)box.getValue(VALUE));
        box.close();
        Assert.assertEquals((long)0L, (long)root.getValue(VALUE));
    }

    @Test
    public void testCloseHierarchy() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats stats1 = root.create(BOX, "n1=1");
        QDStats stats2 = stats1.create(APPLE, "n2=2");
        QDStats stats3 = stats2.create(ORANGE, "n3=3");
        QDStats stats4 = stats3.create(BOX, "n4=4");
        QDStats stats5 = stats4.create(APPLE, "n5=5");
        QDStats stats6 = stats5.create(ORANGE, "n6=6");
        QDStats stats7 = stats6.create(BOX, "n7=7");
        QDStats stats8 = stats7.create(APPLE, "n8=8");
        QDStats stats9 = stats8.create(ORANGE, "n9=9");
        QDStats stats10 = stats9.create(BOX, "n10=10");
        this.updateValue(stats10, 100L);
        stats2.close();
        Assert.assertEquals((long)100L, (long)root.getValue(VALUE));
        stats1.close();
        Assert.assertEquals((long)0L, (long)root.getValue(VALUE));
    }

    @Test
    public void testCloseHierarchySameType() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        int count = 10;
        QDStats[] statsArray = new QDStats[count];
        statsArray[0] = root.create(BOX, "n0=0");
        for (int i = 1; i < 10; ++i) {
            statsArray[i] = statsArray[i - 1].create(BOX, "n" + i + "=" + i);
            statsArray[i].updateIOReadBytes(1L);
        }
        statsArray[1].close();
        Assert.assertEquals((long)9L, (long)root.get(BOX).getValue(VALUE));
    }

    @Test
    public void testSumNodeOnSameType() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        QDStats apple = box.create(APPLE);
        QDStats box1 = apple.create(BOX);
        QDStats box2 = box1.create(BOX);
        this.updateValue(box, 1L);
        this.updateValue(box1, 2L);
        this.updateValue(box2, 4L);
        Assert.assertNotNull((Object)root.get(BOX).get(BOX));
        Assert.assertEquals((long)7L, (long)root.get(BOX).getValue(VALUE));
        box2.close();
        Assert.assertEquals((long)7L, (long)root.get(BOX).getValue(VALUE));
    }

    @Test
    public void testSumNodeOnSameType2() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        QDStats apple1 = box.create(APPLE);
        QDStats apple2 = apple1.create(APPLE);
        QDStats box1 = apple2.create(BOX);
        this.updateValue(box1, 1L);
        Assert.assertNotNull((Object)root.get(BOX).get(BOX));
        Assert.assertNotNull((Object)root.get(BOX).get(APPLE).get(BOX));
        Assert.assertEquals((long)1L, (long)root.get(BOX).getValue(VALUE));
        Assert.assertEquals((long)0L, (long)root.get(APPLE).getValue(VALUE));
        Assert.assertEquals((long)1L, (long)apple2.getValue(VALUE));
        Assert.assertEquals((long)1L, (long)apple2.getValue(VALUE));
        box1.close();
        Assert.assertEquals((long)1L, (long)root.get(BOX).getValue(VALUE));
        Assert.assertEquals((long)0L, (long)root.get(APPLE).getValue(VALUE));
        Assert.assertEquals((long)0L, (long)apple2.getValue(VALUE));
    }

    @Test
    public void testSameTypesTree() {
        QDStats.SType OTHER_BOX = new QDStats.SType("OtherBox", 0, new QDStats.SType[]{BOX});
        QDStats.SType ANOTHER_BOX = new QDStats.SType("OtherBox", 0, new QDStats.SType[]{OTHER_BOX});
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        QDStats otherBox = box.create(OTHER_BOX);
        QDStats anotherBox = otherBox.create(ANOTHER_BOX);
        this.updateValue(anotherBox, 1L);
        Assert.assertNull((Object)root.get(BOX).get(ANOTHER_BOX));
        Assert.assertEquals((long)1L, (long)root.get(BOX).getValue(VALUE));
        Assert.assertNull((Object)root.get(OTHER_BOX));
        Assert.assertNull((Object)root.get(ANOTHER_BOX));
    }

    @Test
    public void testCloseSumNodeFirstTree() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box0 = root.create(BOX, "n=0");
        QDStats box1 = box0.create(BOX, "nn=1");
        QDStats apple1 = box1.create(APPLE);
        QDStats box2 = box0.create(BOX, "n=2");
        QDStats apple2 = box2.create(APPLE);
        this.updateValue(apple1, 1L);
        this.updateValue(apple2, 2L);
        Assert.assertEquals((long)3L, (long)root.get(APPLE).getValue(VALUE));
        box1.close();
        apple1.close();
        Assert.assertEquals((long)3L, (long)root.get(APPLE).getValue(VALUE));
        box0.close();
        apple2.close();
        QDStats sumNode = root.get(APPLE);
        Assert.assertEquals((long)3L, (long)sumNode.getValue(VALUE));
        Assert.assertNull((Object)sumNode.get(APPLE));
    }

    @Test
    public void testCloseSumNode() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box0 = root.create(BOX, "n=0");
        QDStats box1 = box0.create(BOX, "nn=1");
        QDStats apple1 = box1.create(APPLE);
        QDStats box2 = box0.create(BOX, "n=2");
        QDStats apple2 = box2.create(APPLE);
        this.updateValue(apple1, 1L);
        this.updateValue(apple2, 2L);
        Assert.assertEquals((long)3L, (long)root.get(APPLE).getValue(VALUE));
        box0.get(APPLE).close();
        Assert.assertNull((Object)box0.get(APPLE));
        Assert.assertNull((Object)box1.get(APPLE));
        Assert.assertNull((Object)box2.get(APPLE));
        Assert.assertNull((Object)root.get(APPLE).get(APPLE));
        Assert.assertNotNull((Object)root.get(APPLE));
        Assert.assertEquals((long)3L, (long)root.get(APPLE).getValue(VALUE));
    }

    @Test
    public void testRecreateSumNode() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box0 = root.create(BOX, "n=0");
        QDStats box1 = box0.create(BOX, "nn=1");
        QDStats apple1 = box1.create(APPLE);
        QDStats box2 = box0.create(BOX, "n=2");
        QDStats apple2 = box2.create(APPLE);
        this.updateValue(apple1, 1L);
        this.updateValue(apple2, 2L);
        Assert.assertEquals((long)3L, (long)root.get(APPLE).getValue(VALUE));
        QDStats oldSum = box0.get(APPLE);
        oldSum.close();
        this.updateValue(box1.create(APPLE), 4L);
        this.updateValue(box2.create(APPLE), 8L);
        QDStats newSum = box0.get(APPLE);
        Assert.assertNotNull((Object)newSum);
        Assert.assertNotSame((Object)oldSum, (Object)newSum);
        Assert.assertEquals((long)15L, (long)root.get(APPLE).getValue(VALUE));
    }

    @Test
    public void testGetValue() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box0 = root.create(BOX);
        QDStats box1 = box0.create(BOX);
        QDStats apple1 = box1.create(APPLE);
        this.updateValue(box0, 1L);
        this.updateValue(box1, 2L);
        this.updateValue(apple1, 4L);
        this.updateValue(box0.get(APPLE), 8L);
        this.updateValue(root.get(APPLE), 16L);
        Assert.assertEquals((long)1L, (long)box0.getValue(VALUE, true));
        Assert.assertEquals((long)15L, (long)box0.getValue(VALUE));
        Assert.assertEquals((long)2L, (long)box1.getValue(VALUE, true));
        Assert.assertEquals((long)6L, (long)box1.getValue(VALUE));
        Assert.assertEquals((long)8L, (long)box0.get(APPLE).getValue(VALUE, true));
        Assert.assertEquals((long)12L, (long)box0.get(APPLE).getValue(VALUE));
        Assert.assertEquals((long)16L, (long)root.get(APPLE).getValue(VALUE, true));
        Assert.assertEquals((long)28L, (long)root.get(APPLE).getValue(VALUE));
    }

    @Test
    public void testAddValues() {
        QDStats root = new QDStats();
        root.initRoot(QDStats.SType.ANY, 1);
        QDStats box0 = root.create(BOX);
        QDStats box1 = box0.create(BOX);
        QDStats apple1 = box1.create(APPLE);
        this.updateRidValue(box0, 1L);
        this.updateRidValue(box1, 2L);
        this.updateRidValue(apple1, 4L);
        this.updateRidValue(box0.get(APPLE), 8L);
        this.updateRidValue(root.get(APPLE), 16L);
        QDStatsTest.assertRidValue(1L, box0, true);
        QDStatsTest.assertRidValue(15L, box0, false);
        QDStatsTest.assertRidValue(2L, box1, true);
        QDStatsTest.assertRidValue(6L, box1, false);
        QDStatsTest.assertRidValue(8L, box0.get(APPLE), true);
        QDStatsTest.assertRidValue(12L, box0.get(APPLE), false);
        QDStatsTest.assertRidValue(16L, root.get(APPLE), true);
        QDStatsTest.assertRidValue(28L, root.get(APPLE), false);
    }

    @Test
    public void testNoRid() {
        QDStats root = new QDStats();
        root.initRoot(QDStats.SType.ANY, 100);
        QDStats box = root.create(BOX, null, false);
        QDStats apple = box.create(BOX, null, true);
        QDStats orange = root.create(BOX, null);
        Assert.assertEquals((long)100L, (long)root.getRidCount());
        Assert.assertEquals((long)0L, (long)box.getRidCount());
        Assert.assertEquals((long)0L, (long)apple.getRidCount());
        Assert.assertEquals((long)100L, (long)orange.getRidCount());
    }

    @Test
    public void testCreateOnSumNode() {
        QDStats root = new QDStats(QDStats.SType.ANY);
        QDStats box = root.create(BOX);
        box.create(APPLE);
        QDStats orange = root.get(APPLE).create(ORANGE);
        this.updateValue(orange, 1L);
        Assert.assertEquals((long)1L, (long)root.get(APPLE).getValue(VALUE));
    }

    private void updateValue(QDStats stats, long value) {
        stats.updateIOReadBytes(value);
    }

    private void updateRidValue(QDStats stats, long value) {
        stats.updateIOReadRecordBytes(0, value);
    }

    private static void assertRidValue(long expected, QDStats stats, boolean localOnly) {
        long[] values = new long[stats.getRidCount()];
        values[0] = 0L;
        stats.addValues(VALUE, localOnly, values);
        Assert.assertEquals((long)expected, (long)values[0]);
    }
}

