/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.impl.matrix.AbstractCollectorTest;
import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.impl.matrix.AgentBuffer;
import com.devexperts.qd.impl.matrix.History;
import com.devexperts.qd.impl.matrix.Stream;
import com.devexperts.qd.stats.QDStats;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class AgentBufferRebaseTest
extends AbstractCollectorTest {
    private static final int MAGIC = 12345678;

    @Test
    public void testStream() {
        this.setUp((QDCollector)new TestStream());
        this.check();
    }

    @Test
    public void testHistory() {
        this.setUp((QDCollector)new TestHistory());
        this.check();
    }

    private void check() {
        long seed = System.currentTimeMillis();
        System.out.println("Seed: " + seed);
        Random r = new Random(seed);
        this.process(arg_0 -> ((QDAgent)this.agent).addSubscription(arg_0), "SYMBOL_SYMBOL");
        int processed = 0;
        int retrieved = 0;
        for (int dc = 1; dc <= 100; ++dc) {
            for (int i = 0; i < dc; ++i) {
                int time = ++processed;
                this.process(arg_0 -> ((QDDistributor)this.distributor).process(arg_0), "SYMBOL_SYMBOL", time ^ 0xBC614E, 0, time);
            }
            int limit = retrieved + r.nextInt(processed - retrieved) + 1;
            for (int i = retrieved; i < limit; ++i) {
                int time = ++retrieved;
                this.assertRetrieve("SYMBOL_SYMBOL", time ^ 0xBC614E, 0, time);
            }
            Assert.assertEquals((String)"retrieved", (long)limit, (long)retrieved);
        }
    }

    private static class TestHistory
    extends History {
        TestHistory() {
            super(QDFactory.getDefaultFactory().historyBuilder().withScheme(AbstractCollectorTest.SCHEME).withStats(QDStats.VOID));
        }

        AgentBuffer createAgentBuffer(Agent agent) {
            return new TestAgentBuffer(agent);
        }
    }

    private static class TestStream
    extends Stream {
        TestStream() {
            super(QDFactory.getDefaultFactory().streamBuilder().withScheme(AbstractCollectorTest.SCHEME).withStats(QDStats.VOID));
        }

        AgentBuffer createAgentBuffer(Agent agent) {
            return new TestAgentBuffer(agent);
        }
    }

    public static class TestAgentBuffer
    extends AgentBuffer {
        public TestAgentBuffer(Agent agent) {
            super(agent);
        }

        int getRebaseThreshold() {
            return 100;
        }
    }
}

