/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.QDErrorHandler;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.qd.kit.VoidIntField;
import com.devexperts.qd.ng.AbstractRecordSink;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordProvider;
import com.devexperts.qd.ng.RecordSink;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Assert;

public abstract class AbstractCollectorTest {
    protected static final int VALUE_INDEX = 2;
    protected static final DataRecord RECORD = new DefaultRecord(0, "Test", true, new DataIntField[]{new VoidIntField(0, "Test.Dummy"), new CompactIntField(1, "Test.Index"), new CompactIntField(2, "Test.Value")}, null);
    protected static final DataScheme SCHEME = new DefaultScheme((SymbolCodec)PentaCodec.INSTANCE, new DataRecord[]{RECORD});
    protected static final String SYMBOL = "SYMBOL_SYMBOL";
    protected static final String AAPL = "AAPL_AAPL_AAPL";
    protected static final String MSFT = "MSFT_MSFT_MSFT";
    protected QDCollector collector;
    protected QDDistributor distributor;
    protected QDAgent agent;

    protected void setUp(QDCollector c) {
        this.collector = c;
        this.collector.setErrorHandler(QDErrorHandler.THROW);
        this.distributor = this.collector.distributorBuilder().build();
        this.agent = this.collector.agentBuilder().build();
    }

    @After
    public void tearDown() throws Exception {
        if (this.agent != null) {
            this.agent.close();
        }
        if (this.distributor != null) {
            this.distributor.close();
        }
        if (this.collector != null) {
            this.collector.close();
        }
    }

    protected RecordMode getRecordMode() {
        return RecordMode.FLAGGED_DATA.withTimeMark();
    }

    void process(Consumer<RecordBuffer> consumer, String symbol) {
        this.process(consumer, symbol, 0, 0);
    }

    void process(Consumer<RecordBuffer> consumer, String symbol, int value, int timeMark) {
        this.process(consumer, symbol, value, timeMark, 0L);
    }

    void process(Consumer<RecordBuffer> consumer, String symbol, int value, int timeMark, long time) {
        RecordBuffer buf = new RecordBuffer(this.getRecordMode());
        RecordCursor cursor = buf.add(RECORD, 0, symbol);
        if (cursor.hasTime()) {
            cursor.setTime(time);
        }
        cursor.setInt(2, value);
        cursor.setTimeMark(timeMark);
        consumer.accept(buf);
    }

    void assertRetrieve(String symbol, int value, int timeMark) {
        this.assertRetrieve(symbol, value, timeMark, 0L);
    }

    void assertRetrieve(String symbol, int value, int timeMark, long time) {
        this.assertRetrieve((RecordProvider)this.agent, symbol, value, timeMark, time);
    }

    void assertRetrieve(RecordProvider provider, final String symbol, final int value, final int timeMark, final long time) {
        final AtomicBoolean received = new AtomicBoolean();
        provider.retrieve((RecordSink)new AbstractRecordSink(){

            public boolean hasCapacity() {
                return !received.get();
            }

            public void append(RecordCursor cursor) {
                Assert.assertEquals((String)"symbol", (Object)symbol, (Object)cursor.getDecodedSymbol());
                if (cursor.hasTime()) {
                    Assert.assertEquals((String)"time", (long)time, (long)cursor.getTime());
                }
                Assert.assertEquals((String)"timeMark", (long)timeMark, (long)cursor.getTimeMark());
                Assert.assertEquals((String)"value", (long)value, (long)cursor.getInt(2));
                received.set(true);
            }
        });
        Assert.assertTrue((String)"received", (boolean)received.get());
    }

    void dumpRetrieve(RecordProvider provider) {
        final AtomicBoolean received = new AtomicBoolean();
        provider.retrieve((RecordSink)new AbstractRecordSink(){

            public boolean hasCapacity() {
                return !received.get();
            }

            public void append(RecordCursor cursor) {
                System.out.println(cursor.getDecodedSymbol() + ", value=" + cursor.getInt(2) + ", timeMark=" + cursor.getTimeMark());
                received.set(true);
            }
        });
    }

    void assertRetrieveNothing() {
        this.assertRetrieveNothing((RecordProvider)this.agent);
    }

    void assertRetrieveNothing(RecordProvider provider) {
        boolean hasMore = provider.retrieve((RecordSink)new AbstractRecordSink(){

            public void append(RecordCursor cursor) {
                Assert.fail((String)"available");
            }
        });
        Assert.assertFalse((String)"available", (boolean)hasMore);
    }
}

