/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.logging.Logging;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.History;
import com.devexperts.qd.impl.matrix.RecordCursorKeeperOld;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.stats.QDStats;

public final class HistoryBufferOld {
    private static final Logging log = Logging.getLogging(HistoryBufferOld.class);
    private final boolean withEventTimeSequence;
    private final int intOffset;
    private final int objOffset;
    private final int intStep;
    private final int objStep;
    private int mask;
    private int[] intValues;
    private Object[] objValues;
    private int min;
    private int max;
    private static final byte SNAPSHOT_BEGIN_SEEN_FLAG = 1;
    private static final byte SNAPSHOT_END_SEEN_FLAG = 2;
    private static final byte EVER_SNAPSHOT_MODE_FLAG = 4;
    private static final byte SWEEP_TX_FLAG = 8;
    private static final byte EXPLICIT_TX_FLAG = 16;
    private byte flags;
    private long snapshotTime = Long.MAX_VALUE;
    private long everSnapshotTime = Long.MAX_VALUE;
    private long snipSnapshotTime = Long.MIN_VALUE;
    long expirationTime = Long.MAX_VALUE;
    int nExamined;
    long examinedTime;

    HistoryBufferOld(DataRecord record, boolean withEventTimeSequence) {
        if (!record.hasTime() || record.getIntFieldCount() < 2) {
            throw new IllegalArgumentException("Record does not contain time.");
        }
        this.withEventTimeSequence = withEventTimeSequence;
        this.intOffset = withEventTimeSequence ? 2 : 0;
        this.objOffset = 0;
        this.intStep = record.getIntFieldCount() + this.intOffset;
        this.objStep = record.getObjFieldCount() + this.objOffset;
        this.allocInitial();
    }

    private void allocInitial() {
        this.mask = 15;
        this.intValues = this.intStep == 0 ? null : new int[this.intStep * (this.mask + 1)];
        this.objValues = this.objStep == 0 ? null : new Object[this.objStep * (this.mask + 1)];
    }

    boolean validTimes() {
        return this.snapshotTime >= this.everSnapshotTime && this.everSnapshotTime >= this.snipSnapshotTime && (this.min == this.max || this.time(this.min) >= this.everSnapshotTime);
    }

    private long time(int index) {
        int place = index * this.intStep + this.intOffset;
        return (long)this.intValues[place] << 32 | (long)this.intValues[place + 1] & 0xFFFFFFFFL;
    }

    private void setTime(int index, long time) {
        int place = index * this.intStep + this.intOffset;
        this.intValues[place] = (int)(time >>> 32);
        this.intValues[place + 1] = (int)time;
    }

    private long eventTimeSequence(int index) {
        if (!this.withEventTimeSequence) {
            return 0L;
        }
        int place = index * this.intStep;
        return (long)this.intValues[place] << 32 | (long)this.intValues[place + 1] & 0xFFFFFFFFL;
    }

    private void setEventTimeSequence(int index, long eventTimeSequence) {
        if (!this.withEventTimeSequence) {
            return;
        }
        int place = index * this.intStep;
        this.intValues[place] = (int)(eventTimeSequence >> 32);
        this.intValues[place + 1] = (int)eventTimeSequence;
    }

    private int getIndexInclusive(long time) {
        assert (this.min != this.max);
        long lTime = this.time(this.min);
        if (time < lTime) {
            return this.min - 1 & this.mask;
        }
        long rTime = this.time(this.max - 1 & this.mask);
        if (time >= rTime) {
            return this.max - 1 & this.mask;
        }
        int r = this.max - 1;
        int l = this.min;
        if (r < l) {
            r += this.mask + 1;
        }
        while (true) {
            assert (l < r);
            int n = r - l;
            if (n == 1) {
                return l & this.mask;
            }
            if ((long)n == rTime - lTime) {
                return l + (int)(time - lTime) & this.mask;
            }
            int i = l + r >> 1;
            long iTime = this.time(i & this.mask);
            if (iTime <= time) {
                l = i;
                lTime = iTime;
                continue;
            }
            r = i;
            rTime = iTime;
        }
    }

    private int getIndexExclusive(long time) {
        assert (this.min != this.max);
        long lTime = this.time(this.min);
        if (time <= lTime) {
            return this.min - 1 & this.mask;
        }
        long rTime = this.time(this.max - 1 & this.mask);
        if (time > rTime) {
            return this.max - 1 & this.mask;
        }
        int r = this.max - 1;
        int l = this.min;
        if (r < l) {
            r += this.mask + 1;
        }
        while (true) {
            assert (l < r);
            int n = r - l;
            if (n == 1) {
                return l & this.mask;
            }
            if ((long)n == rTime - lTime) {
                return l + (int)(time - lTime) - 1 & this.mask;
            }
            int i = l + r >> 1;
            long iTime = this.time(i & this.mask);
            if (iTime < time) {
                l = i;
                lTime = iTime;
                continue;
            }
            r = i;
            rTime = iTime;
        }
    }

    private static void copy(Object src, Object dst, int head, int tail, int length) {
        if (tail < head) {
            System.arraycopy(src, head, dst, 0, length - head);
            System.arraycopy(src, 0, dst, length - head, tail);
        } else {
            System.arraycopy(src, head, dst, 0, tail - head);
        }
    }

    private void ensureCapacity() {
        int size = this.max - this.min & this.mask;
        if (this.mask - size <= 2) {
            int length = this.mask + 1;
            int newLength = length << 1;
            this.intValues = new int[newLength * this.intStep];
            HistoryBufferOld.copy(this.intValues, this.intValues, this.min * this.intStep, this.max * this.intStep, length * this.intStep);
            if (this.objStep != 0) {
                this.objValues = new Object[newLength * this.objStep];
                HistoryBufferOld.copy(this.objValues, this.objValues, this.min * this.objStep, this.max * this.objStep, length * this.objStep);
            }
            this.mask = newLength - 1;
            this.min = 0;
            this.max = size;
        }
    }

    private void moveData(int index, int dest, int len) {
        System.arraycopy(this.intValues, index * this.intStep, this.intValues, dest * this.intStep, len * this.intStep);
        if (this.objStep != 0) {
            System.arraycopy(this.objValues, index * this.objStep, this.objValues, dest * this.objStep, len * this.objStep);
        }
    }

    private void moveLeft(int index, int size, int dist) {
        int overCnt;
        assert (size > 0);
        int end = index + size & this.mask;
        if (index > end) {
            int len = this.mask + 1 - index;
            this.moveData(index, index - dist, len);
            index = 0;
            if ((size -= len) == 0) {
                return;
            }
        }
        if ((overCnt = Math.min(dist - index, size)) > 0) {
            this.moveData(index, index - dist & this.mask, overCnt);
            index += overCnt;
            if ((size -= overCnt) == 0) {
                return;
            }
        }
        this.moveData(index, index - dist, size);
    }

    private void moveRight(int index, int size, int dist) {
        int overCnt;
        assert (size > 0);
        int end = index + size & this.mask;
        if (index > end && end > 0) {
            int len = end;
            this.moveData(0, dist, len);
            assert ((size -= len) > 0);
        }
        if ((overCnt = Math.min(index + size + dist - this.mask - 1, size)) > 0) {
            int k = index + size - overCnt;
            this.moveData(k, k + dist & this.mask, overCnt);
            if ((size -= overCnt) == 0) {
                return;
            }
        }
        this.moveData(index, index + dist, size);
    }

    private int insertAt(int index) {
        int l = index + 1 - this.min & this.mask;
        int r = this.max - index - 1 & this.mask;
        this.ensureCapacity();
        index = this.min + l - 1 & this.mask;
        if (l < r || l == r && this.min < index) {
            this.moveLeft(this.min, l, 1);
            this.min = this.min - 1 & this.mask;
        } else {
            index = index + 1 & this.mask;
            this.moveRight(index, r, 1);
            this.max = this.max + 1 & this.mask;
        }
        this.clearAt(index);
        return index;
    }

    private void clearAt(int index) {
        int i;
        int place = index * this.intStep;
        for (i = 0; i < this.intStep; ++i) {
            this.intValues[place + i] = 0;
        }
        if (this.objStep != 0) {
            place = index * this.objStep;
            for (i = 0; i < this.objStep; ++i) {
                this.objValues[place + i] = null;
            }
        }
    }

    private int removeAt(int index) {
        int l = index - this.min & this.mask;
        int r = this.max - 1 - index & this.mask;
        if (l <= r) {
            if (l != 0) {
                this.moveRight(this.min, l, 1);
            }
            this.clearAt(this.min);
            this.min = this.min + 1 & this.mask;
            return index;
        }
        if (r != 0) {
            this.moveLeft(index + 1 & this.mask, r, 1);
        }
        this.max = this.max - 1 & this.mask;
        this.clearAt(this.max);
        return index - 1 & this.mask;
    }

    private void copy(int index, RecordCursor cursor) {
        cursor.getIntsTo(0, this.intValues, index * this.intStep + this.intOffset, this.intStep - this.intOffset);
        if (this.objStep != 0) {
            cursor.getObjsTo(0, this.objValues, index * this.objStep + this.objOffset, this.objStep - this.objOffset);
        }
        this.setEventTimeSequence(index, cursor.getEventTimeSequence());
    }

    private int removeSnapshotFromSnipTime(long time, DataRecord record, int cipher, String symbol, RecordBuffer removeBuffer) {
        assert (this.max != this.min);
        int startIndex = this.getIndexExclusive(time);
        int stopIndex = this.min - 1 & this.mask;
        int index = startIndex;
        while (index != stopIndex) {
            removeBuffer.add(record, cipher, symbol).setTime(this.time(index));
            this.clearAt(index);
            index = index - 1 & this.mask;
        }
        this.min = startIndex + 1 & this.mask;
        return startIndex - stopIndex & this.mask;
    }

    private int removeSnapshotSweepBetween(long snapshotTime, long toTime, DataRecord record, int cipher, String symbol, RecordBuffer removeBuffer) {
        long time;
        assert (this.max != this.min);
        assert (toTime <= snapshotTime);
        int startIndex = this.getIndexExclusive(snapshotTime);
        int stopIndex = this.min - 1 & this.mask;
        int index = startIndex;
        while (index != stopIndex && (time = this.time(index)) > toTime) {
            removeBuffer.add(record, cipher, symbol).setTime(time);
            index = index - 1 & this.mask;
        }
        int count = startIndex - index & this.mask;
        if (count == 0) {
            return 0;
        }
        int removeCount = 0;
        int l = index + 1 - this.min & this.mask;
        int r = this.max - startIndex - 1 & this.mask;
        if (l < r) {
            if (l != 0) {
                this.moveRight(this.min, l, count);
            }
            for (int i = 0; i < count; ++i) {
                this.clearAt(this.min);
                this.min = this.min + 1 & this.mask;
                ++removeCount;
            }
        } else {
            if (r != 0) {
                this.moveLeft(startIndex + 1 & this.mask, r, count);
            }
            for (int i = 0; i < count; ++i) {
                this.max = this.max - 1 & this.mask;
                this.clearAt(this.max);
                ++removeCount;
            }
        }
        return removeCount;
    }

    public boolean isTx() {
        return (this.flags & 0x18) != 0;
    }

    public boolean isSweepTx() {
        return (this.flags & 8) != 0;
    }

    public boolean wasSnapshotBeginSeen() {
        return (this.flags & 1) != 0;
    }

    public boolean wasSnapshotEndSeen() {
        return (this.flags & 2) != 0;
    }

    public boolean wasEverSnapshotMode() {
        return (this.flags & 4) != 0;
    }

    public boolean isWaitingForSnapshotBegin() {
        return (this.flags & 7) == 4;
    }

    public long getSnapshotTime() {
        return this.snapshotTime;
    }

    public long getEverSnapshotTime() {
        return this.everSnapshotTime;
    }

    public long getSnipSnapshotTime() {
        return this.snipSnapshotTime;
    }

    boolean isSnipToTime(long time) {
        return time == this.snipSnapshotTime;
    }

    void resetSnapshot() {
        this.flags = (byte)(this.flags & 0xFFFFFFFC);
    }

    boolean enterSnapshotModeFirstTime() {
        assert (this.validTimes());
        if (this.wasEverSnapshotMode()) {
            return false;
        }
        this.flags = (byte)(this.flags | 5);
        return true;
    }

    void enterSnapshotModeForUnconflated() {
        this.flags = (byte)(this.flags | 5);
    }

    boolean updateExplicitTx(boolean txPending) {
        if (txPending) {
            this.flags = (byte)(this.flags | 0x10);
            return false;
        }
        if ((this.flags & 0x10) != 0) {
            this.flags = (byte)(this.flags & 0xFFFFFFEF);
            return !this.isTx();
        }
        return false;
    }

    void snapshotBegin() {
        this.snapshotTime = Long.MAX_VALUE;
        assert (this.validTimes());
        this.flags = (byte)(this.flags | 1);
        this.flags = (byte)(this.flags & 0xFFFFFFFD);
    }

    boolean snapshotSnipAndRemove(long time, DataRecord record, int cipher, String symbol, RecordBuffer removeBuffer, QDStats stats, int rid) {
        if (this.isSnipToTime(time)) {
            return false;
        }
        if (this.max != this.min) {
            int removeCount = this.removeSnapshotFromSnipTime(time, record, cipher, symbol, removeBuffer);
            stats.updateRemoved(rid, removeCount);
        }
        this.snipSnapshotTime = time;
        this.trimSnapshotTimes(time);
        assert (this.validTimes());
        return true;
    }

    boolean updateSnapshotTimeAndSweepRemove(long time, long trimToTime, DataRecord record, int cipher, String symbol, RecordBuffer removeBuffer, QDStats stats, int rid) {
        boolean updatedEverSnapshotTime;
        long trimmedTime = Math.max(time, trimToTime);
        if (trimmedTime >= this.snapshotTime) {
            return false;
        }
        if (this.max != this.min) {
            int removeCount = this.removeSnapshotSweepBetween(this.snapshotTime, time < trimToTime ? trimToTime - 1L : time, record, cipher, symbol, removeBuffer);
            stats.updateRemoved(rid, removeCount);
        }
        this.snapshotTime = trimmedTime;
        boolean bl = updatedEverSnapshotTime = trimmedTime < this.everSnapshotTime;
        if (updatedEverSnapshotTime) {
            this.everSnapshotTime = trimmedTime;
        }
        if (trimmedTime < this.snipSnapshotTime) {
            this.snipSnapshotTime = Long.MIN_VALUE;
        }
        assert (this.validTimes());
        return updatedEverSnapshotTime;
    }

    void updateSweepTxOn() {
        this.flags = (byte)(this.flags | 8);
    }

    boolean snapshotEnd() {
        if (!this.wasSnapshotBeginSeen()) {
            return false;
        }
        if (this.wasSnapshotEndSeen()) {
            return false;
        }
        this.flags = (byte)(this.flags | 2);
        return true;
    }

    boolean updateSweepTxOff() {
        if (!this.isSweepTx()) {
            return false;
        }
        this.flags = (byte)(this.flags & 0xFFFFFFF7);
        return !this.isTx();
    }

    boolean putRecord(long time, RecordCursor cursor, boolean removeEvent, QDStats stats, int rid) {
        if (this.max == this.min || time > this.time(this.max - 1 & this.mask)) {
            return !removeEvent && this.putNewRecordAboveMax(cursor, stats, rid);
        }
        if (time < this.time(this.min)) {
            return !removeEvent && this.putNewRecordBelowMin(cursor, stats, rid);
        }
        int index = this.getIndexInclusive(time);
        if (this.time(index) != time) {
            return !removeEvent && this.putNewRecordInTheMiddle(cursor, index, stats, rid);
        }
        if (removeEvent) {
            this.removeAt(index);
            stats.updateRemoved(rid);
            return true;
        }
        boolean changed = cursor.updateIntsTo(2, this.intValues, index * this.intStep + this.intOffset + 2, this.intStep - this.intOffset - 2);
        if (this.objStep != 0) {
            changed |= cursor.updateObjsTo(0, this.objValues, index * this.objStep + this.objOffset, this.objStep - this.objOffset);
        }
        if (changed) {
            this.setEventTimeSequence(index, cursor.getEventTimeSequence());
            stats.updateChanged(rid);
        }
        return changed;
    }

    private boolean putNewRecordAboveMax(RecordCursor cursor, QDStats stats, int rid) {
        this.ensureCapacity();
        this.copy(this.max, cursor);
        this.max = this.max + 1 & this.mask;
        stats.updateAdded(rid);
        return true;
    }

    private boolean putNewRecordBelowMin(RecordCursor cursor, QDStats stats, int rid) {
        this.ensureCapacity();
        this.min = this.min - 1 & this.mask;
        this.copy(this.min, cursor);
        stats.updateAdded(rid);
        return true;
    }

    private boolean putNewRecordInTheMiddle(RecordCursor cursor, int index, QDStats stats, int rid) {
        index = this.insertAt(index);
        this.copy(index, cursor);
        stats.updateAdded(rid);
        return true;
    }

    void enforceMaxRecordCount(int maxRecordCount, QDStats stats, int rid) {
        int size = this.max - this.min & this.mask;
        if (size > maxRecordCount) {
            int removeCount = maxRecordCount > 0 ? size - maxRecordCount : size;
            this.removeToIndex(this.min + removeCount & this.mask);
            stats.updateRemoved(rid, removeCount);
        }
    }

    void clearAllRecords(QDStats stats, int rid) {
        int removeCount = this.size();
        this.min = 0;
        this.max = 0;
        this.allocInitial();
        this.trimSnapshotTimes(Long.MAX_VALUE);
        stats.updateRemoved(rid, removeCount);
        assert (this.validTimes());
        if (Collector.TRACE_LOG) {
            log.trace("clearAllRecords " + this);
        }
    }

    void removeOldRecords(long time, QDStats stats, int rid) {
        int removeCount = 0;
        while (this.min != this.max && this.time(this.min) < time) {
            this.clearAt(this.min);
            this.min = this.min + 1 & this.mask;
            ++removeCount;
        }
        this.trimSnapshotTimes(time);
        stats.updateRemoved(rid, removeCount);
        assert (this.validTimes());
        if (Collector.TRACE_LOG) {
            log.trace("removeOldRecords " + this);
        }
    }

    private void trimSnapshotTimes(long time) {
        this.snapshotTime = Math.max(this.snapshotTime, time);
        this.everSnapshotTime = Math.max(this.everSnapshotTime, time);
    }

    private void removeToIndex(int newMin) {
        while (this.min != newMin) {
            this.clearAt(this.min);
            this.min = this.min + 1 & this.mask;
        }
    }

    int size() {
        return this.max - this.min & this.mask;
    }

    long getMinAvailableTime() {
        if (this.min == this.max) {
            return 0L;
        }
        return this.time(this.min);
    }

    long getMaxAvailableTime() {
        if (this.min == this.max) {
            return 0L;
        }
        return this.time(this.max - 1 & this.mask);
    }

    int getAvailableCount(long startTime, long endTime) {
        if (this.min == this.max) {
            return 0;
        }
        if (startTime > endTime) {
            long t = startTime;
            startTime = endTime;
            endTime = t;
        }
        return this.getIndexInclusive(endTime) - this.getIndexExclusive(startTime) & this.mask;
    }

    boolean examineDataRangeRTL(DataRecord record, int cipher, String symbol, long startTime, long endTime, RecordSink sink, RecordCursorKeeperOld keeper, Object attachment) {
        int endIndex;
        int startIndex;
        assert (startTime >= endTime);
        long inSnapshotTime = Math.max(endTime, this.everSnapshotTime);
        boolean inSnapshot = this.wasEverSnapshotMode() && inSnapshotTime <= startTime;
        RecordCursor.Owner owner = keeper.getForHistoryBufferReadOnly(this, record, cipher, symbol);
        if (this.min != this.max && (startIndex = this.getIndexInclusive(startTime)) != (endIndex = this.getIndexExclusive(endTime))) {
            long lastTime = Long.MAX_VALUE;
            int index = startIndex;
            while (index != endIndex) {
                lastTime = this.time(index);
                if (this.examineOne(sink, attachment, owner, index, this.isTx() ? History.TX_PENDING : 0)) {
                    return true;
                }
                index = index - 1 & this.mask;
            }
            return inSnapshot && lastTime > inSnapshotTime && this.examineSnapshotTime(sink, attachment, inSnapshotTime, owner);
        }
        if (inSnapshot) {
            return this.examineSnapshotTime(sink, attachment, inSnapshotTime, owner);
        }
        return false;
    }

    boolean examineDataRangeLTR(DataRecord record, int cipher, String symbol, long startTime, long endTime, RecordSink sink, RecordCursorKeeperOld keeper, Object attachment) {
        int endIndex;
        int startIndex;
        assert (startTime <= endTime);
        long inSnapshotTime = Math.max(startTime, this.everSnapshotTime);
        boolean inSnapshot = this.wasEverSnapshotMode() && inSnapshotTime <= endTime;
        RecordCursor.Owner owner = keeper.getForHistoryBufferReadOnly(this, record, cipher, symbol);
        if (this.min != this.max && (startIndex = this.getIndexExclusive(startTime) + 1 & this.mask) != (endIndex = this.getIndexInclusive(endTime) + 1 & this.mask)) {
            if (inSnapshot && this.time(startIndex) > inSnapshotTime && this.examineSnapshotTime(sink, attachment, inSnapshotTime, owner)) {
                return true;
            }
            int index = startIndex;
            while (index != endIndex) {
                if (this.examineOne(sink, attachment, owner, index, this.isTx() ? History.TX_PENDING : 0)) {
                    return true;
                }
                index = index + 1 & this.mask;
            }
            return false;
        }
        if (inSnapshot) {
            return this.examineSnapshotTime(sink, attachment, inSnapshotTime, owner);
        }
        return false;
    }

    private boolean examineSnapshotTime(RecordSink sink, Object attachment, long time, RecordCursor.Owner owner) {
        this.setTime(this.max, time);
        return this.examineOne(sink, attachment, owner, this.max, History.REMOVE_EVENT | (this.isTx() ? History.TX_PENDING : 0));
    }

    boolean examineDataSnapshot(DataRecord record, int cipher, String symbol, long toTime, RecordSink sink, RecordCursorKeeperOld keeper, Object attachment) {
        return this.examineDataRetrieve(record, cipher, symbol, Long.MAX_VALUE, Math.max(toTime, this.everSnapshotTime), sink, keeper, attachment, Integer.MAX_VALUE, History.SNAPSHOT_BEGIN, toTime < this.snipSnapshotTime ? History.SNAPSHOT_SNIP : History.SNAPSHOT_END, false, true);
    }

    boolean examineDataRetrieve(DataRecord record, int cipher, String symbol, long timeKnown, long toTime, RecordSink sink, RecordCursorKeeperOld keeper, Object attachment, int nLimit, int eventFlags, int snapshotEndFlag, boolean txEnd, boolean useFlags) {
        this.nExamined = 0;
        RecordCursor.Owner owner = keeper.getForHistoryBufferReadOnly(this, record, cipher, symbol);
        if (!this.wasEverSnapshotMode()) {
            eventFlags &= ~History.SNAPSHOT_BEGIN;
            snapshotEndFlag &= ~History.SNAPSHOT_END;
        }
        if (this.isTx()) {
            eventFlags |= History.TX_PENDING;
        }
        if (this.min != this.max) {
            long time;
            int index = this.getIndexExclusive(timeKnown);
            int stopIndex = this.min - 1 & this.mask;
            while (index != stopIndex && (time = this.time(index)) >= toTime) {
                if (time == toTime) {
                    eventFlags |= snapshotEndFlag;
                    if (txEnd) {
                        eventFlags &= ~History.TX_PENDING;
                    }
                }
                if (this.examineOneRetrieve(sink, time, attachment, owner, index, nLimit, useFlags ? eventFlags : 0)) {
                    return true;
                }
                eventFlags &= ~History.SNAPSHOT_BEGIN;
                index = index - 1 & this.mask;
            }
        }
        if (useFlags && snapshotEndFlag != 0 && (this.nExamined == 0 || this.examinedTime > toTime)) {
            eventFlags |= snapshotEndFlag;
            if (txEnd) {
                eventFlags &= ~History.TX_PENDING;
            }
            this.setTime(this.max, toTime);
            return this.examineOneRetrieve(sink, toTime, attachment, owner, this.max, nLimit, useFlags ? eventFlags | History.REMOVE_EVENT : 0);
        }
        return false;
    }

    private boolean examineOneRetrieve(RecordSink sink, long time, Object attachment, RecordCursor.Owner owner, int index, int nLimit, int eventFlags) {
        if (!sink.hasCapacity() || this.nExamined >= nLimit) {
            return true;
        }
        ++this.nExamined;
        this.examinedTime = time;
        return this.examineOne(sink, attachment, owner, index, eventFlags);
    }

    void setupOwner(RecordCursor.Owner owner, DataRecord record, int cipher, String symbol) {
        owner.setReadOnly(true);
        owner.setRecord(record, this.withEventTimeSequence ? RecordMode.TIMESTAMPED_DATA : RecordMode.DATA);
        owner.setSymbol(cipher, symbol);
        owner.setArrays(this.intValues, this.objValues);
    }

    private boolean examineOne(RecordSink sink, Object attachment, RecordCursor.Owner owner, int index, int eventFlags) {
        if (!sink.hasCapacity()) {
            return true;
        }
        owner.setOffsets(index * this.intStep + this.intOffset, index * this.objStep + this.objOffset);
        owner.setAttachment(attachment);
        owner.setEventFlags(eventFlags);
        sink.append(owner.cursor());
        return false;
    }

    public String toString() {
        return "HistoryBuffer{size=" + (this.max - this.min & this.mask) + ", snapshotTime=" + this.snapshotTime + ", everSnapshotTime=" + this.everSnapshotTime + ", snipSnapshotTime=" + this.snipSnapshotTime + ((this.flags & 1) != 0 ? ", SNAPSHOT_BEGIN_SEEN" : "") + ((this.flags & 2) != 0 ? ", SNAPSHOT_END_SEEN" : "") + ((this.flags & 4) != 0 ? ", EVER_SNAPSHOT_MODE_FLAG" : "") + ((this.flags & 8) != 0 ? ", SWEEP_TX" : "") + ((this.flags & 0x10) != 0 ? ", EXPLICIT_TX" : "") + '}';
    }
}

