/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.symbol;

import com.devexperts.qd.impl.symbol.SymbolCache;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SymbolCacheStressTest {
    public static final int MAX_SYMBOL = 1000;
    public static final int ITERATIONS = 100000;
    public static final int CONCURRENCY = 100;
    public static final String[] SYMBOLS = (String[])IntStream.range(0, 1000).mapToObj(String::valueOf).toArray(String[]::new);
    private volatile Exception exception;

    @Ignore(value="Stress test. To be run manually")
    @Test(timeout=300000L)
    public void testStress() throws Exception {
        SymbolCache cache = SymbolCache.newBuilder().withTtl(0L).withInitialCapacity(2000).build();
        ExecutorService executor = Executors.newFixedThreadPool(100);
        CountDownLatch latch = new CountDownLatch(100);
        executor.submit(() -> this.runCleanUp(cache, latch));
        for (int i = 0; i < 99; ++i) {
            executor.submit(() -> this.runAcquireRelease(cache, latch));
        }
        latch.await();
        if (this.exception != null) {
            throw this.exception;
        }
        int size = cache.size();
        cache.cleanUp();
        int cleaned = size - cache.size();
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAcquireRelease(SymbolCache cache, CountDownLatch latch) {
        try {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            for (int i = 0; i < 100000; ++i) {
                String symbol = SYMBOLS[rnd.nextInt(SYMBOLS.length)];
                cache.resolveAndAcquire(symbol);
                Thread.yield();
                cache.release(symbol);
                Thread.yield();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.exception = e;
        }
        finally {
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCleanUp(SymbolCache cache, CountDownLatch latch) {
        try {
            while (latch.getCount() > 1L) {
                Thread.sleep(100L);
                int size = cache.size();
                cache.cleanUp();
                int n = size - cache.size();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.exception = e;
        }
        finally {
            latch.countDown();
        }
    }
}

