/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.file;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.qd.qtp.AbstractConnectionHandler;
import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.MessageConsumerAdapter;
import com.devexperts.qd.qtp.file.FileReader;
import com.devexperts.qd.qtp.file.FileReaderParams;
import com.devexperts.qd.stats.QDStats;

public class FileReaderHandler
extends AbstractConnectionHandler<AbstractMessageConnector> {
    private final FileReader reader;
    private final MessageAdapter adapter;

    public FileReaderHandler(AbstractMessageConnector connector) {
        super(connector);
        FileReaderParams params = connector instanceof FileReaderParams ? (FileReaderParams)connector : new FileReaderParams.Default();
        MessageAdapter.Factory factory = MessageConnectors.retrieveMessageAdapterFactory((ApplicationConnectionFactory)connector.getFactory());
        this.reader = new FileReader(connector.getAddress(), this.getConnectionStats(), params){

            @Override
            protected void onConnected() {
                FileReaderHandler.this.makeConnected();
            }
        };
        this.adapter = factory.createAdapter(params.getStats().getOrCreate(QDStats.SType.CONNECTIONS));
        this.adapter.start();
        this.reader.setScheme(this.adapter.getScheme());
    }

    protected void doWork() throws InterruptedException {
        this.reader.readInto((MessageConsumerAdapter)this.adapter);
    }

    protected void closeImpl(Throwable reason) {
        this.reader.close();
        try {
            this.adapter.close();
        }
        catch (Throwable t) {
            this.log.error("Failed to close adapter", t);
        }
        if (reason == null || reason instanceof RuntimeException || reason instanceof Error) {
            this.log.info("Reading stopped");
        } else {
            this.log.error("Reading stopped", reason);
        }
    }

    public long getDelayActual() {
        return this.reader.getDelayActual();
    }

    public static class Factory
    implements AbstractConnectionHandler.Factory {
        public AbstractConnectionHandler<AbstractMessageConnector> createHandler(String protocol, AbstractMessageConnector connector) {
            return protocol.equals("file") ? new FileReaderHandler(connector) : null;
        }
    }
}

