/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.file;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.io.StreamCompression;
import com.devexperts.qd.qtp.AbstractConnectionHandler;
import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorState;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.file.FileFormat;
import com.devexperts.qd.qtp.file.FileWriterHandler;
import com.devexperts.qd.qtp.file.FileWriterParams;
import com.devexperts.qd.qtp.file.TapeConnectorMBean;
import com.devexperts.qd.qtp.file.TimestampsType;
import com.devexperts.qd.qtp.help.MessageConnectorProperty;
import com.devexperts.qd.qtp.help.MessageConnectorSummary;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.transport.stats.EndpointStats;
import com.devexperts.util.LogUtil;
import com.devexperts.util.TimePeriod;

@MessageConnectorSummary(info="Writes data to tape files.", addressFormat="tape:<filename>")
public class TapeConnector
extends AbstractMessageConnector
implements TapeConnectorMBean,
FileWriterParams {
    private final String address;
    private TimePeriod split;
    private StreamCompression compression;
    private FileFormat format;
    private TimestampsType time;
    private MessageType saveAs = MessageType.RAW_DATA;
    private TimePeriod storageTime = TimePeriod.UNLIMITED;
    private long storageSize = Long.MAX_VALUE;
    private String opt;
    private String tmpDir;
    private volatile FileWriterHandler handler;

    protected TapeConnector(ApplicationConnectionFactory factory, String address) {
        super(factory);
        if (address == null) {
            throw new NullPointerException();
        }
        QDConfig.setDefaultProperties((Object)this, TapeConnectorMBean.class, (String)MessageConnector.class.getName());
        QDConfig.setDefaultProperties((Object)this, TapeConnectorMBean.class, (String)TapeConnector.class.getName());
        this.address = address;
    }

    public synchronized String getAddress() {
        return this.address;
    }

    public synchronized void start() {
        if (this.isActive() || this.isClosed()) {
            return;
        }
        this.log.info("Starting TapeConnector to " + LogUtil.hideCredentials((Object)this.getAddress()));
        this.handler = new FileWriterHandler(this);
        this.handler.init();
        this.handler.start();
        this.notifyMessageConnectorListeners();
    }

    protected synchronized void handlerClosed(AbstractConnectionHandler handler) {
        if (handler != this.handler) {
            return;
        }
        this.handler = null;
    }

    public boolean isActive() {
        return this.handler != null;
    }

    public MessageConnectorState getState() {
        FileWriterHandler handler = this.handler;
        return handler != null ? handler.getHandlerState() : MessageConnectorState.DISCONNECTED;
    }

    public int getConnectionCount() {
        return this.getState() == MessageConnectorState.CONNECTED ? 1 : 0;
    }

    public EndpointStats retrieveCompleteEndpointStats() {
        EndpointStats stats = super.retrieveCompleteEndpointStats();
        FileWriterHandler handler = this.handler;
        if (handler != null && handler.getHandlerState() == MessageConnectorState.CONNECTED) {
            stats.addActiveConnectionCount(1L);
            stats.addConnectionStats(handler.getConnectionStats());
        }
        return stats;
    }

    public void awaitProcessed() throws InterruptedException {
        FileWriterHandler handler = this.handler;
        if (handler != null) {
            handler.awaitProcessed();
        }
    }

    protected AbstractMessageConnector.Joinable stopImpl() {
        if (!this.isActive()) {
            return null;
        }
        FileWriterHandler handler = this.handler;
        this.handler = null;
        if (handler != null) {
            this.log.info("Stopping TapeConnector");
            handler.close();
        }
        return handler;
    }

    @Override
    public synchronized TimePeriod getSplit() {
        return this.split;
    }

    @Override
    @MessageConnectorProperty(value="Time period determining how often must new files be created while creating multiple files with timestamped names. When this parameter is defined a special '~' marker in file name must be used")
    public synchronized void setSplit(TimePeriod split) {
        if (!split.equals((Object)this.split)) {
            this.log.info("Setting split=" + split);
            this.split = split;
            this.reconfigure();
        }
    }

    @Override
    public synchronized StreamCompression getCompression() {
        return this.compression;
    }

    @Override
    @MessageConnectorProperty(value="File compression (one of \"none\", \"gzip\", or \"zip\")")
    public synchronized void setCompression(StreamCompression compression) {
        if (!compression.equals((Object)this.compression)) {
            this.log.info("Setting compression=" + compression);
            this.compression = compression;
            this.reconfigure();
        }
    }

    @Override
    public synchronized FileFormat getFormat() {
        return this.format;
    }

    @Override
    @MessageConnectorProperty(value="Format of stored data. Its value can be one of \"text\" (see \"Help Text format\"), \"binary\" or \"blob:<record>:<symbol>\" (binary format is used by default)")
    public synchronized void setFormat(FileFormat format) {
        if (!format.equals(this.format)) {
            this.log.info("Setting format=" + format);
            this.format = format;
            this.reconfigure();
        }
    }

    @Override
    public synchronized TimestampsType getTime() {
        return this.time;
    }

    @Override
    @MessageConnectorProperty(value="Time format (one of \"none\", \"long\", \"text\", or \"event\")")
    public synchronized void setTime(TimestampsType time) {
        if (this.time != time) {
            this.log.info("Setting time=" + (Object)((Object)time));
            this.time = time;
            this.reconfigure();
        }
    }

    @Override
    public synchronized MessageType getSaveAs() {
        return this.saveAs;
    }

    @Override
    @MessageConnectorProperty(value="Overrides the type of stored messages. Data messages can be stored as ticker_data\", \"stream_data\", \"history_data\", or \"raw_data\"")
    public synchronized void setSaveAs(MessageType saveAs) {
        if (this.saveAs != saveAs) {
            this.log.info("Setting saveAs=" + saveAs);
            this.saveAs = saveAs;
            this.reconfigure();
        }
    }

    @Override
    public synchronized TimePeriod getStorageTime() {
        return this.storageTime;
    }

    @Override
    @MessageConnectorProperty(value="Enables deleting all taped files which have timestamps less than current time minus \"storagetime\" value")
    public synchronized void setStorageTime(TimePeriod storageTime) {
        if (!storageTime.equals((Object)this.storageTime)) {
            this.log.info("Setting storageTime=" + storageTime);
            this.storageTime = storageTime;
            this.reconfigure();
        }
    }

    @Override
    public synchronized long getStorageSize() {
        return this.storageSize;
    }

    @Override
    @MessageConnectorProperty(value="Enables deleting old taped files when total size of all existing taped files is greater than \"storagesize\" value")
    public synchronized void setStorageSize(long storageSize) {
        if (this.storageSize != storageSize) {
            this.log.info("Setting storageSize=" + storageSize);
            this.storageSize = storageSize;
            this.reconfigure();
        }
    }

    @Override
    public synchronized String getOpt() {
        return this.opt;
    }

    @Override
    @MessageConnectorProperty(value="String set of protocol options")
    public synchronized void setOpt(String opt) {
        if (!opt.equals(this.opt)) {
            this.log.info("Setting opt=" + opt);
            this.opt = opt;
            this.reconfigure();
        }
    }

    @Override
    public synchronized String getTmpDir() {
        return this.tmpDir;
    }

    @Override
    @MessageConnectorProperty(value="Temporary directory for tape files processing")
    public synchronized void setTmpDir(String tmpDir) {
        if (!tmpDir.equals(this.tmpDir)) {
            this.log.info("Setting tmpDir=" + tmpDir);
            this.tmpDir = tmpDir;
            this.reconfigure();
        }
    }
}

