/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.text;

import com.devexperts.io.BufferedInput;
import com.devexperts.qd.qtp.text.CorruptedTextFormatException;
import com.devexperts.qd.qtp.text.TextCoding;
import java.io.IOException;

class StringDecoder {
    private char[] buf = new char[128];

    StringDecoder() {
    }

    private void expand(int length) {
        char[] newBuf = new char[Math.max(this.buf.length * 2, length)];
        System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
        this.buf = newBuf;
    }

    public String decode(byte[] bytes, int offset, int length) throws CorruptedTextFormatException {
        if (StringDecoder.bytesEquals(bytes, offset, length, "\\NULL")) {
            return null;
        }
        if (StringDecoder.bytesEquals(bytes, offset, length, "\\0")) {
            return "\u0000";
        }
        if (length > this.buf.length) {
            this.expand(length);
        }
        int size = 0;
        int end = offset + length;
        while (offset < end) {
            byte c;
            if ((c = bytes[offset++]) == 92) {
                offset = this.decodeEscape(bytes, offset, end, size++);
                continue;
            }
            TextCoding.checkCharRange(c);
            this.buf[size++] = (char)c;
        }
        return new String(this.buf, 0, size);
    }

    public String decode(BufferedInput in, int length) throws IOException {
        if (length == 0) {
            return "";
        }
        if (length > this.buf.length) {
            this.expand(length);
        }
        int size = 0;
        boolean possibleNull = false;
        while (length-- > 0) {
            byte c = in.readByte();
            int i = size++;
            if (c == 92) {
                length = this.decodeEscape(in, length, i);
                if (i != 0 || this.buf[i] != 'N') continue;
                possibleNull = true;
                continue;
            }
            TextCoding.checkCharRange(c);
            this.buf[i] = (char)c;
        }
        if (possibleNull && size == 4 && this.buf[1] == 'U' && this.buf[2] == 'L' && this.buf[3] == 'L') {
            return null;
        }
        return new String(this.buf, 0, size);
    }

    private int decodeEscape(byte[] bytes, int offset, int end, int size) {
        byte c;
        if (offset >= end) {
            throw new CorruptedTextFormatException("Character expected after \\");
        }
        if ((c = bytes[offset++]) == 117) {
            return this.decodeUnicode(bytes, offset, end, size);
        }
        this.buf[size] = (char)this.decodeEscapedChar(c);
        return offset;
    }

    private int decodeEscape(BufferedInput in, int length, int size) throws IOException {
        if (length <= 0) {
            throw new CorruptedTextFormatException("Character expected after \\");
        }
        byte c = in.readByte();
        if (c == 117) {
            return this.decodeUnicode(in, length - 1, size);
        }
        this.buf[size] = (char)this.decodeEscapedChar(c);
        return length - 1;
    }

    private byte decodeEscapedChar(byte c) {
        switch (c) {
            case 48: {
                c = 0;
                break;
            }
            case 116: {
                c = (byte)9;
                break;
            }
            case 110: {
                c = (byte)10;
                break;
            }
            case 114: {
                c = (byte)13;
                break;
            }
            case 102: {
                c = (byte)12;
                break;
            }
            default: {
                TextCoding.checkCharRange(c);
            }
        }
        return c;
    }

    private int decodeUnicode(byte[] bytes, int offset, int end, int size) {
        if (offset + 4 > end) {
            throw new CorruptedTextFormatException("Four digit hexadecimal number is expected after \\u");
        }
        int code = 0;
        for (int j = 0; j < 4; ++j) {
            char c;
            code = (char)(code << 4);
            if ((c = (char)bytes[offset++]) >= '0' && c <= '9') {
                code = (char)(code + (c - 48));
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                code = (char)(code + (c - 97 + 10));
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                code = (char)(code + (c - 65 + 10));
                continue;
            }
            throw new CorruptedTextFormatException("Four digit hexadecimal number is expected after \\u");
        }
        this.buf[size] = code;
        return offset;
    }

    private int decodeUnicode(BufferedInput in, int length, int size) throws IOException {
        if (length < 4) {
            throw new CorruptedTextFormatException("Four digit hexadecimal number is expected after \\u");
        }
        int code = 0;
        for (int j = 0; j < 4; ++j) {
            code = (char)(code << 4);
            byte c = in.readByte();
            if (c >= 48 && c <= 57) {
                code = (char)(code + (c - 48));
                continue;
            }
            if (c >= 97 && c <= 102) {
                code = (char)(code + (c - 97 + 10));
                continue;
            }
            if (c >= 65 && c <= 70) {
                code = (char)(code + (c - 65 + 10));
                continue;
            }
            throw new CorruptedTextFormatException("Four digit hexadecimal number is expected after \\u");
        }
        this.buf[size] = code;
        return length - 4;
    }

    private static boolean bytesEquals(byte[] bytes, int offset, int length, String s) {
        if (s.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (bytes[offset + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

