/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.text;

import com.devexperts.io.BufferedInput;
import com.devexperts.logging.Logging;
import com.devexperts.qd.DataField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.kit.VoidIntField;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.qtp.AbstractQTPParser;
import com.devexperts.qd.qtp.HeartbeatPayload;
import com.devexperts.qd.qtp.MessageConsumer;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import com.devexperts.qd.qtp.text.CorruptedTextFormatException;
import com.devexperts.qd.qtp.text.LineTokenizer;
import com.devexperts.qd.qtp.text.TextDelimiters;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.TimeFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class TextQTPParser
extends AbstractQTPParser {
    private static final String LEGACY_QD_COMPLETE = "QD_COMPLETE";
    private static final DataField EVENT_TIME_DESC = new VoidIntField(Integer.MAX_VALUE, "EventTimePlaceHolder");
    private static final Logging log = Logging.getLogging(TextQTPParser.class);
    private final LineTokenizer tokenizer;
    private MessageType defaultMessageType;
    private MessageType lastMessageType;
    private ProtocolDescriptor protocolDescriptor;
    private HeartbeatPayload heartbeatPayload;
    private final HashMap<String, DataField[]> describedRecords;

    public TextQTPParser(DataScheme scheme) {
        this(scheme, null);
    }

    public TextQTPParser(DataScheme scheme, MessageType defaultMessageType) {
        super(scheme);
        this.defaultMessageType = defaultMessageType;
        this.lastMessageType = defaultMessageType;
        this.tokenizer = new LineTokenizer();
        this.describedRecords = new HashMap();
    }

    public void setDelimiters(TextDelimiters delimiters) {
        this.tokenizer.setDelimiters(delimiters);
    }

    public void resetSession() {
        this.describedRecords.clear();
        this.lastMessageType = this.defaultMessageType;
    }

    protected void parseImpl(BufferedInput in, MessageConsumer consumer) throws IOException {
        block6: while (in.hasAvailable()) {
            block14: {
                try {
                    if (!this.tokenizer.reset(in)) {
                    }
                    break block14;
                }
                catch (CorruptedTextFormatException e) {
                    this.processPending(consumer);
                    log.error("Invalid text format", (Throwable)e);
                    consumer.handleCorruptedStream();
                }
                break;
            }
            String token = this.tokenizer.nextToken();
            if (token == null) continue;
            TextDelimiters delimiters = this.tokenizer.getDelimiters();
            if (delimiters.messageTypePrefix != null && token.startsWith(delimiters.messageTypePrefix)) {
                MessageType messageType;
                String messageName = token.substring(delimiters.messageTypePrefix.length());
                if (messageName.equals(LEGACY_QD_COMPLETE)) continue;
                if (messageName.equals("DXP3")) {
                    this.processPending(consumer);
                    this.parseDescribeProtocol(consumer);
                    continue;
                }
                if (messageName.isEmpty()) {
                    this.processPending(consumer);
                    if (this.parseHeartbeat(consumer)) continue;
                    this.processPending(consumer);
                    consumer.handleCorruptedMessage(MessageType.HEARTBEAT.getId());
                    continue;
                }
                if (messageName.startsWith("QD_")) {
                    messageName = messageName.substring("QD_".length());
                }
                if ((messageType = MessageType.findByName((String)messageName)) == null) {
                    this.processPending(consumer);
                    log.error("Unknown message type \"" + messageName + "\"");
                    consumer.handleUnknownMessage(MessageType.TEXT_FORMAT.getId());
                    continue;
                }
                this.lastMessageType = messageType;
                continue;
            }
            if (token.startsWith(delimiters.describePrefix)) {
                String recordName = token.substring(delimiters.describePrefix.length());
                if (this.parseRecordDescription(recordName)) continue;
                this.processPending(consumer);
                consumer.handleCorruptedMessage(MessageType.DESCRIBE_RECORDS.getId());
                continue;
            }
            if (this.lastMessageType == null) continue;
            RecordBuffer buf = this.nextRecordsMessage(consumer, this.lastMessageType);
            switch (this.lastMessageType) {
                case TICKER_DATA: 
                case STREAM_DATA: 
                case HISTORY_DATA: 
                case RAW_DATA: {
                    if (this.parseData(buf, token)) continue block6;
                    this.processPending(consumer);
                    consumer.handleCorruptedMessage(this.lastMessageType.getId());
                    continue block6;
                }
                case TICKER_ADD_SUBSCRIPTION: 
                case TICKER_REMOVE_SUBSCRIPTION: 
                case STREAM_ADD_SUBSCRIPTION: 
                case STREAM_REMOVE_SUBSCRIPTION: 
                case HISTORY_ADD_SUBSCRIPTION: 
                case HISTORY_REMOVE_SUBSCRIPTION: {
                    if (this.parseSubscription(buf, token)) continue block6;
                    this.processPending(consumer);
                    consumer.handleCorruptedMessage(this.lastMessageType.getId());
                    continue block6;
                }
            }
            this.processPending(consumer);
            consumer.handleUnknownMessage(this.lastMessageType.getId());
        }
    }

    private void parseDescribeProtocol(MessageConsumer consumer) {
        this.protocolDescriptor = ProtocolDescriptor.newPeerProtocolDescriptor((ProtocolDescriptor)this.protocolDescriptor);
        this.protocolDescriptor.appendFromTextTokens(this.tokenizer.getTokens(), this.tokenizer.getNextIndex());
        consumer.processDescribeProtocol(this.applyReadAs(this.protocolDescriptor), true);
    }

    private boolean parseHeartbeat(MessageConsumer consumer) {
        if (this.heartbeatPayload == null) {
            this.heartbeatPayload = new HeartbeatPayload();
        } else {
            this.heartbeatPayload.clear();
        }
        try {
            this.heartbeatPayload.appendFromTextTokens(this.tokenizer.getTokens(), this.tokenizer.getNextIndex());
        }
        catch (InvalidFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        consumer.processHeartbeat(this.heartbeatPayload);
        return true;
    }

    private boolean parseData(RecordBuffer buf, String recordName) {
        DataRecord record = this.scheme.findRecordByName(recordName);
        DataField[] fieldsRearrangement = this.describedRecords.get(recordName);
        if (record == null) {
            if (fieldsRearrangement == null) {
                log.error("Unknown record \"" + recordName + "\"");
                return false;
            }
            return true;
        }
        String symbol = this.tokenizer.nextToken();
        if (symbol == null) {
            log.error("Symbol name expected for record \"" + recordName + "\"");
            return false;
        }
        int cipher = this.scheme.getCodec().encode(symbol);
        RecordCursor cur = buf.add(record, cipher, symbol);
        if (fieldsRearrangement == null) {
            int i;
            int n = record.getIntFieldCount();
            for (i = 0; this.tokenizer.hasMoreTokens() && i < n; ++i) {
                if (record.getIntField(i) instanceof VoidIntField) continue;
                TextQTPParser.trySetField((DataField)record.getIntField(i), cur, this.tokenizer.nextToken());
            }
            n = record.getObjFieldCount();
            for (i = 0; this.tokenizer.hasMoreTokens() && i < n; ++i) {
                TextQTPParser.trySetField((DataField)record.getObjField(i), cur, this.tokenizer.nextToken());
            }
        } else {
            for (int i = 0; this.tokenizer.hasMoreTokens() && i < fieldsRearrangement.length; ++i) {
                DataField field = fieldsRearrangement[i];
                String token = this.tokenizer.nextToken();
                if (field == EVENT_TIME_DESC) {
                    TextQTPParser.trySetEventTime(cur, token);
                    continue;
                }
                if (field == null) continue;
                TextQTPParser.trySetField(field, cur, token);
            }
        }
        this.parseExtraTokens(cur, true);
        this.setEventTimeSequenceIfNeeded(cur);
        this.replaceFieldIfNeeded(cur);
        return true;
    }

    private static void trySetEventTime(RecordCursor cursor, String value) {
        if (value != null) {
            try {
                cursor.setEventTimeSequence(TimeSequenceUtil.getTimeSequenceFromTimeMillis((long)TimeFormat.DEFAULT.parse(value).getTime()));
            }
            catch (IllegalArgumentException e) {
                log.error("Cannot parse \"EventTime\" field: " + e.getMessage());
            }
        }
    }

    private static void trySetField(DataField field, RecordCursor cursor, String value) {
        try {
            field.setString(cursor, value);
        }
        catch (IllegalArgumentException e) {
            log.error("Cannot parse record field \"" + field.getName() + "\": " + e.getMessage());
        }
    }

    private boolean parseSubscription(RecordBuffer buf, String recordName) {
        String timeStr;
        DataRecord record = this.scheme.findRecordByName(recordName);
        DataField[] fieldsRearrangement = this.describedRecords.get(recordName);
        if (record == null) {
            if (fieldsRearrangement == null) {
                log.error("Subscription to unknown record \"" + recordName + "\"");
                return false;
            }
            return true;
        }
        String symbol = this.tokenizer.nextToken();
        if (symbol == null) {
            log.error("Symbol name expected for record \"" + recordName + "\"");
            return false;
        }
        int cipher = this.scheme.getCodec().encode(symbol);
        long time = 0L;
        if (this.lastMessageType.isHistorySubscriptionAdd() && (timeStr = this.tokenizer.nextToken()) != null) {
            try {
                time = (long)record.getIntField(0).parseString(timeStr) << 32;
                timeStr = this.tokenizer.nextToken();
                if (timeStr != null) {
                    time |= (long)record.getIntField(1).parseString(timeStr) & 0xFFFFFFFFL;
                }
            }
            catch (IllegalArgumentException e) {
                log.error("Cannot parse time for historySubscriptionAdd subscription");
                return false;
            }
        }
        RecordCursor cur = buf.add(record, cipher, symbol);
        cur.setTime(time);
        cur.setEventFlags(this.lastMessageType.isSubscriptionRemove() ? EventFlag.REMOVE_SYMBOL.flag() : 0);
        this.parseExtraTokens(cur, false);
        return true;
    }

    private void parseExtraTokens(RecordCursor cur, boolean data) {
        block8: while (this.tokenizer.hasMoreTokens()) {
            String s = this.tokenizer.nextToken();
            int i = s.indexOf(61);
            if (i < 0) {
                log.error("Skipping extra token \"" + s + "\". Expected '=' is not found");
                continue;
            }
            String key = s.substring(0, i);
            String value = s.substring(i + 1);
            switch (key) {
                case "EventFlags": {
                    cur.setEventFlags(EventFlag.parseEventFlags((String)value, (MessageType)this.lastMessageType));
                    continue block8;
                }
                case "EventTime": {
                    TextQTPParser.trySetEventTime(cur, value);
                    continue block8;
                }
            }
            if (data) {
                DataField field = cur.getRecord().findFieldByName(key);
                if (field == null) {
                    log.error("Skipping extra token \"" + s + "\". Field is not found");
                    continue;
                }
                TextQTPParser.trySetField(field, cur, value);
                continue;
            }
            log.error("Skipping extra token \"" + s + "\" in subscription");
        }
    }

    private boolean parseRecordDescription(String recordName) {
        String fieldName;
        String symbolString = this.tokenizer.nextToken();
        if (!"Symbol".equals(symbolString) && !"EventSymbol".equals(symbolString)) {
            log.error("Invalid symbol field name '" + symbolString + "'");
            return false;
        }
        DataRecord record = this.scheme.findRecordByName(recordName);
        ArrayList<DataField> fieldsRearrangement = new ArrayList<DataField>();
        while ((fieldName = this.tokenizer.nextToken()) != null) {
            DataField field;
            DataField dataField = field = record == null ? null : record.findFieldByName(fieldName);
            if (field == null && this.readEventTimeSequence && fieldName.equals("EventTime")) {
                field = EVENT_TIME_DESC;
            }
            fieldsRearrangement.add(field);
        }
        this.describedRecords.put(recordName, fieldsRearrangement.toArray(new DataField[fieldsRearrangement.size()]));
        return true;
    }
}

