/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.blob;

import com.devexperts.io.BufferedOutput;
import com.devexperts.qd.DataField;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.qtp.AbstractQTPComposer;
import com.devexperts.qd.qtp.MessageType;
import java.io.IOException;

public class BlobQTPComposer
extends AbstractQTPComposer {
    private final DataRecord record;
    private final int cipher;
    private final String symbol;

    public BlobQTPComposer(DataRecord record, String symbol) {
        super(record.getScheme(), false);
        this.record = record;
        this.cipher = record.getScheme().getCodec().encode(symbol);
        this.symbol = symbol;
    }

    protected int writeRecordHeader(DataRecord record, int cipher, String symbol, int eventFlags) throws IOException {
        if (record != this.record) {
            throw new IOException("Wrong record for this BLOB");
        }
        if (cipher != this.cipher || cipher == 0 && !this.symbol.equals(symbol)) {
            throw new IOException("Wrong symbol for this BLOB");
        }
        return 0;
    }

    protected void writeHistorySubscriptionTime(DataRecord record, long time) throws IOException {
        throw new IOException("Unsupported message for BLOB");
    }

    protected void writeIntField(DataIntField field, int value) throws IOException {
        field.writeInt((BufferedOutput)this.msg, value);
    }

    protected void writeObjField(DataObjField field, Object value) throws IOException {
        field.writeObj((BufferedOutput)this.msg, value);
    }

    protected void writeField(DataField field, RecordCursor cursor) throws IOException {
        field.write((BufferedOutput)this.msg, cursor);
    }

    protected void writeMessageHeader(MessageType messageType) throws IOException {
        if (messageType != MessageType.HISTORY_DATA && messageType != MessageType.RAW_DATA) {
            throw new IOException("Unsupported message for BLOB");
        }
    }
}

