/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.file;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.io.StreamCompression;
import com.devexperts.monitoring.Monitored;
import com.devexperts.qd.qtp.AbstractConnectionHandler;
import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorState;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.file.FileConnectorMBean;
import com.devexperts.qd.qtp.file.FileFormat;
import com.devexperts.qd.qtp.file.FileReaderHandler;
import com.devexperts.qd.qtp.file.FileReaderParams;
import com.devexperts.qd.qtp.file.TimestampsType;
import com.devexperts.qd.qtp.help.MessageConnectorProperty;
import com.devexperts.qd.qtp.help.MessageConnectorSummary;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.transport.stats.EndpointStats;
import com.devexperts.util.LogUtil;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimePeriod;
import java.util.Date;

@MessageConnectorSummary(info="Connects to a file.", addressFormat="file:<filename>")
public class FileConnector
extends AbstractMessageConnector
implements FileConnectorMBean,
FileReaderParams {
    static final long NA_TIME = Long.MIN_VALUE;
    private String address;
    private StreamCompression compression;
    private FileFormat format;
    private long startTime = Long.MIN_VALUE;
    private long stopTime = Long.MIN_VALUE;
    private long delayTime = Long.MIN_VALUE;
    private double speed = 1.0;
    private TimestampsType time;
    private boolean ignoreTime;
    private boolean cycle;
    private MessageType readAs;
    private boolean schemeKnown;
    private MessageType resyncOn;
    private volatile FileReaderHandler handler;

    public FileConnector(ApplicationConnectionFactory factory, String address) {
        super(factory);
        if (address == null) {
            throw new NullPointerException();
        }
        QDConfig.setDefaultProperties((Object)this, FileConnectorMBean.class, (String)MessageConnector.class.getName());
        QDConfig.setDefaultProperties((Object)this, FileConnectorMBean.class, (String)FileConnector.class.getName());
        this.address = address;
    }

    public synchronized void start() {
        if (this.handler != null || this.isClosed()) {
            return;
        }
        this.log.info("Starting FileConnector to " + LogUtil.hideCredentials((Object)this.getAddress()));
        this.handler = new FileReaderHandler(this);
        this.handler.start();
        this.notifyMessageConnectorListeners();
    }

    protected synchronized AbstractMessageConnector.Joinable stopImpl() {
        FileReaderHandler handler = this.handler;
        this.handler = null;
        if (handler != null) {
            this.log.info("Stopping FileConnector");
            handler.close();
        }
        return handler;
    }

    protected synchronized void handlerClosed(AbstractConnectionHandler handler) {
        if (handler != this.handler) {
            return;
        }
        this.handler = null;
    }

    public synchronized String getAddress() {
        return this.address;
    }

    @Override
    public synchronized void setAddress(String address) {
        if (!address.equals(this.address)) {
            this.log.info("Setting address=" + LogUtil.hideCredentials((Object)address));
            this.address = address;
            this.reconfigure();
        }
    }

    @Override
    public synchronized StreamCompression getCompression() {
        return this.compression;
    }

    @Override
    @MessageConnectorProperty(value="File compression (one of \"none\", \"gzip\", or \"zip\"), autodetect by default from file header")
    public void setCompression(StreamCompression compression) {
        if (!compression.equals((Object)this.compression)) {
            this.log.info("Setting setCompression=" + compression);
            this.compression = compression;
            this.reconfigure();
        }
    }

    @Override
    public synchronized FileFormat getFormat() {
        return this.format;
    }

    @Override
    @MessageConnectorProperty(value="File format (one of \"binary\", \"text\", \"csv\", or \"blob:<record>:<symbol>\"), autodetect by default from file header")
    public synchronized void setFormat(FileFormat format) {
        if (!format.equals(this.format)) {
            this.log.info("Setting format=" + format);
            this.format = format;
            this.reconfigure();
        }
    }

    public boolean isActive() {
        return this.handler != null;
    }

    public MessageConnectorState getState() {
        FileReaderHandler handler = this.handler;
        return handler != null ? handler.getHandlerState() : MessageConnectorState.DISCONNECTED;
    }

    public int getConnectionCount() {
        return this.getState() == MessageConnectorState.CONNECTED ? 1 : 0;
    }

    public EndpointStats retrieveCompleteEndpointStats() {
        EndpointStats stats = super.retrieveCompleteEndpointStats();
        FileReaderHandler handler = this.handler;
        if (handler != null && handler.getHandlerState() == MessageConnectorState.CONNECTED) {
            stats.addActiveConnectionCount(1L);
            stats.addConnectionStats(handler.getConnectionStats());
        }
        return stats;
    }

    private void checkTimeAndIgnoreTime(TimestampsType time, boolean ignoreTime) {
        if (ignoreTime && time != null) {
            throw new IllegalArgumentException("Cannot set both ignoreTime and time. Use time=none to ignore time");
        }
    }

    private void checkStartAndStop(long startTime, long stopTime) {
        if (startTime != Long.MIN_VALUE && stopTime != Long.MIN_VALUE && stopTime <= startTime) {
            throw new IllegalArgumentException("Cannot set stop at or before start");
        }
    }

    private void checkStartAndDelay(long startTime, long delayTime) {
        if (startTime != Long.MIN_VALUE && delayTime != Long.MIN_VALUE) {
            throw new IllegalArgumentException("Cannot set both start and delay");
        }
    }

    private void checkStopAndDelay(long stopTime, long delayTime) {
        if (stopTime != Long.MIN_VALUE && delayTime != Long.MIN_VALUE) {
            throw new IllegalArgumentException("Cannot set both stop and delay");
        }
    }

    private void checkSpeedAndDelay(double speed, long delayTime) {
        if (speed != 1.0 && delayTime != Long.MIN_VALUE) {
            throw new IllegalArgumentException("Cannot set both speed and delay");
        }
    }

    private void checkCycleAndDelay(boolean cycle, long delayTime) {
        if (cycle && delayTime != Long.MIN_VALUE) {
            throw new IllegalArgumentException("Cannot set both cycle and delay");
        }
    }

    @Override
    public synchronized long getStartTime() {
        return this.startTime;
    }

    @Override
    public synchronized Date getStart() {
        return this.startTime == Long.MIN_VALUE ? null : new Date(this.startTime);
    }

    @Override
    @MessageConnectorProperty(value="Time to start playing from, use [YYYYMMDD-]HHMMSS[.sss][tz] format")
    public synchronized void setStart(Date time) {
        long startTime;
        long l = startTime = time == null ? Long.MIN_VALUE : time.getTime();
        if (this.startTime != startTime) {
            this.checkStartAndStop(startTime, this.stopTime);
            this.checkStartAndDelay(startTime, this.delayTime);
            this.log.info("Setting start=" + TimeFormat.DEFAULT.format(time));
            this.startTime = startTime;
            this.reconfigure();
        }
    }

    @Override
    public synchronized long getStopTime() {
        return this.stopTime;
    }

    @Override
    public synchronized Date getStop() {
        return this.stopTime == Long.MIN_VALUE ? null : new Date(this.stopTime);
    }

    @Override
    @MessageConnectorProperty(value="Time to stop playing, use [YYYYMMDD-]HHMMSS[.sss][tz] format")
    public synchronized void setStop(Date time) {
        long stopTime;
        long l = stopTime = time == null ? Long.MIN_VALUE : time.getTime();
        if (this.stopTime != stopTime) {
            this.checkStartAndStop(this.startTime, stopTime);
            this.checkStopAndDelay(stopTime, this.delayTime);
            this.log.info("Setting stop=" + TimeFormat.DEFAULT.format(time));
            this.stopTime = stopTime;
            this.reconfigure();
        }
    }

    @Override
    public synchronized long getDelayTime() {
        return this.delayTime;
    }

    @Override
    @Monitored(name="delayed", description="Configured delaying time period")
    public synchronized TimePeriod getDelayed() {
        return this.delayTime == Long.MIN_VALUE ? null : TimePeriod.valueOf((long)this.delayTime);
    }

    @Override
    @MessageConnectorProperty(value="Delay relatively to current time")
    public synchronized void setDelayed(TimePeriod delay) {
        long delayTime;
        long l = delayTime = delay == null ? Long.MIN_VALUE : delay.getTime();
        if (this.delayTime != delayTime) {
            this.checkStartAndDelay(this.startTime, delayTime);
            this.checkStopAndDelay(this.stopTime, delayTime);
            this.checkSpeedAndDelay(this.speed, delayTime);
            this.checkCycleAndDelay(this.cycle, delayTime);
            this.log.info("Setting delayed=" + delay);
            this.delayTime = delayTime;
            this.reconfigure();
        }
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }

    @Override
    @MessageConnectorProperty(value="Replay speed vs real time, use \"max\" to read file as fast as possible, defaults to 1")
    public void setSpeed(double speed) {
        if (!(speed > 0.0)) {
            throw new IllegalArgumentException("Invalid speed=" + speed);
        }
        if (this.speed != speed) {
            this.checkSpeedAndDelay(speed, this.delayTime);
            this.log.info("Setting speed=" + (speed == Double.MAX_VALUE ? "max" : String.valueOf(speed)));
            this.speed = speed;
            this.reconfigure();
        }
    }

    @Override
    public synchronized TimestampsType getTime() {
        return this.time;
    }

    @Override
    @MessageConnectorProperty(value="Time format (one of \"none\", \"long\", \"text\", \"field\", or \"message\"), autodetect by default")
    public synchronized void setTime(TimestampsType time) {
        if (this.time != time) {
            this.checkTimeAndIgnoreTime(time, this.ignoreTime);
            this.log.info("Setting time=" + (Object)((Object)time));
            this.time = time;
            this.reconfigure();
        }
    }

    @Override
    public synchronized boolean isIgnoreTime() {
        return this.ignoreTime;
    }

    @Override
    @MessageConnectorProperty(value="Ignores \".time\" files even if they present")
    public synchronized void setIgnoreTime(boolean ignore) {
        if (this.ignoreTime != ignore) {
            this.checkTimeAndIgnoreTime(this.time, ignore);
            this.log.warn("SETTING DEPRECATED ignoreTime=" + ignore + ". Set speed=max to replay as fast as possible.");
            this.ignoreTime = ignore;
            this.reconfigure();
        }
    }

    @Override
    public synchronized boolean isCycle() {
        return this.cycle;
    }

    @Override
    @MessageConnectorProperty(value="Enables cycle playback")
    public synchronized void setCycle(boolean cycle) {
        if (this.cycle != cycle) {
            this.checkCycleAndDelay(cycle, this.delayTime);
            this.log.info("Setting cycle=" + cycle);
            this.cycle = cycle;
            this.reconfigure();
        }
    }

    @Override
    public synchronized MessageType getReadAs() {
        return this.readAs;
    }

    @Override
    @MessageConnectorProperty(value="Overrides the type of read messages (one of \"ticker_data\", \"stream_data\", \"history_data\", or \"raw_data\", works for binary tape files only)")
    public synchronized void setReadAs(MessageType readAs) {
        if (this.readAs != readAs) {
            this.log.info("Setting readAs=" + readAs);
            this.readAs = readAs;
            this.reconfigure();
        }
    }

    @Override
    public synchronized boolean isSchemeKnown() {
        return this.schemeKnown;
    }

    @Override
    @MessageConnectorProperty(value="Enables parsing of files without record descriptions")
    public synchronized void setSchemeKnown(boolean schemeKnown) {
        if (this.schemeKnown != schemeKnown) {
            this.log.info("Setting schemeKnown=" + schemeKnown);
            this.schemeKnown = schemeKnown;
            this.reconfigure();
        }
    }

    @Override
    public synchronized MessageType getResyncOn() {
        return this.resyncOn;
    }

    @Override
    @MessageConnectorProperty(value="Message type to resync partial binary stream captured with tcpdump")
    public synchronized void setResyncOn(MessageType resyncOn) {
        if (this.resyncOn != resyncOn) {
            this.log.info("Setting resyncOn=" + resyncOn);
            this.resyncOn = resyncOn;
            this.reconfigure();
        }
    }

    @Override
    @Monitored(name="delay_actual", description="Actual delay in ms or delay time if not connected yet")
    public long getDelayActual() {
        FileReaderHandler handler = this.handler;
        return handler != null ? handler.getDelayActual() : this.getDelayTime();
    }
}

