/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.file;

import com.devexperts.qd.qtp.file.TimestampsType;
import com.devexperts.util.TimeFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

class TimestampedPosition {
    private final long time;
    private final long position;

    TimestampedPosition(long time, long position) {
        this.time = time;
        this.position = position;
    }

    public long getTime() {
        return this.time;
    }

    public long getPosition() {
        return this.position;
    }

    void writeTo(PrintWriter out, TimestampsType type) {
        if (out == null || type == TimestampsType.NONE) {
            return;
        }
        if (type == TimestampsType.LONG) {
            out.print(this.time);
        } else {
            out.print(TimeFormat.DEFAULT.withTimeZone().withMillis().format(this.time));
        }
        out.print(':');
        out.println(this.position);
    }

    static TimestampedPosition readFrom(BufferedReader in) throws IOException {
        String line;
        int semicolon;
        if (in == null) {
            return null;
        }
        do {
            if ((line = in.readLine()) != null) continue;
            return null;
        } while ((semicolon = line.lastIndexOf(58)) < 0);
        long time = TimeFormat.DEFAULT.parse(line.substring(0, semicolon)).getTime();
        long position = Long.parseLong(line.substring(semicolon + 1));
        return new TimestampedPosition(time, position);
    }

    public String toString() {
        return TimeFormat.DEFAULT.withTimeZone().withMillis().format(this.time) + ":" + this.position;
    }
}

