/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.blob;

import com.devexperts.io.BufferedInput;
import com.devexperts.logging.Logging;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.qtp.AbstractQTPParser;
import com.devexperts.qd.qtp.MessageConsumer;
import com.devexperts.qd.qtp.MessageType;
import java.io.EOFException;
import java.io.IOException;

public class BlobQTPParser
extends AbstractQTPParser {
    private static final Logging log = Logging.getLogging(BlobQTPParser.class);
    private final DataRecord record;
    private final int cipher;
    private final String symbol;

    public BlobQTPParser(DataRecord record, String symbol) {
        super(record.getScheme());
        this.record = record;
        this.cipher = record.getScheme().getCodec().encode(symbol);
        this.symbol = symbol;
    }

    protected void parseImpl(BufferedInput in, MessageConsumer consumer) {
        try {
            RecordBuffer buf = this.nextRecordsMessage(consumer, MessageType.HISTORY_DATA);
            long position = in.totalPosition();
            while (in.hasAvailable()) {
                try {
                    RecordCursor cursor = buf.add(this.record, this.cipher, this.symbol);
                    this.record.readFields(in, cursor);
                    this.replaceFieldIfNeeded(cursor);
                }
                catch (EOFException e) {
                    // empty catch block
                    break;
                }
            }
            this.stats.updateIOReadRecordBytes(this.record.getId(), in.totalPosition() - position);
            this.stats.updateIOReadDataRecord();
        }
        catch (IOException e) {
            log.error("Cannot parse data blob", (Throwable)e);
            consumer.handleCorruptedStream();
        }
    }
}

