/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.file;

import com.devexperts.io.URLInputStream;
import com.devexperts.logging.Logging;
import com.devexperts.util.LogUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;

class FileUtils {
    private static final Logging log = Logging.getLogging(FileUtils.class);
    public static final String TIME_FILE_EXTENSION = ".time";
    public static final String TIMESTAMP_MARKER = "~";

    private FileUtils() {
    }

    public static String retrieveExtension(String filePath) {
        int dotPos = filePath.lastIndexOf(46);
        if (dotPos == -1) {
            return "";
        }
        String res = filePath.substring(dotPos);
        if (res.contains(File.separator)) {
            return "";
        }
        if (res.contains(TIMESTAMP_MARKER)) {
            return "";
        }
        return res;
    }

    public static String getTimeFilePath(String dataFilePath, String dataFileExtension, String containerExtension) {
        String fullExtension = dataFileExtension + containerExtension;
        if (!dataFilePath.endsWith(fullExtension)) {
            throw new IllegalArgumentException("File path '" + LogUtil.hideCredentials((Object)dataFilePath) + "' is expected to end with extension '" + fullExtension + "'");
        }
        return dataFilePath.substring(0, dataFilePath.length() - fullExtension.length()) + TIME_FILE_EXTENSION + containerExtension;
    }

    public static URL addressToURL(String address) {
        try {
            return URLInputStream.resolveURL((String)address);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid address URL: " + LogUtil.hideCredentials((Object)address), e);
        }
    }

    public static File urlToFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        return new File(url.getPath());
    }

    public static void tryClose(Closeable closeable, String address) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                log.error("Failed to close " + LogUtil.hideCredentials((Object)address), t);
            }
        }
    }

    public static void checkOrCreateDirectory(Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (!Files.isDirectory(dir, new LinkOption[0])) {
                    throw e;
                }
                log.warn("Concurrent directory creation, just ignore " + dir, (Throwable)e);
            }
        }
    }

    public static void tryAtomicFileMove(Path source, Path destination, CopyOption ... options) throws IOException {
        try {
            CopyOption[] merged;
            int length = options.length;
            if (length > 0) {
                merged = Arrays.copyOf(options, length + 1);
                merged[length] = StandardCopyOption.ATOMIC_MOVE;
            } else {
                merged = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            }
            Files.move(source, destination, merged);
        }
        catch (AtomicMoveNotSupportedException e) {
            log.warn("Failed to atomic move file: " + source + " to destination: " + destination + ". Fail-over to using general move with file copy", (Throwable)e);
            Files.move(source, destination, options);
        }
    }
}

