/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.logging.Logging;
import com.devexperts.management.Management;
import com.devexperts.mars.common.MARSEndpoint;
import com.devexperts.mars.common.MARSScheduler;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.monitoring.ConnectorsMonitoringTask;
import com.devexperts.qd.monitoring.JMXEndpoint;
import com.devexperts.qd.monitoring.MonitoringEndpointMXBean;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.stats.JMXStats;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.util.JMXNameBuilder;
import com.devexperts.util.TimePeriod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class MonitoringEndpoint
implements MonitoringEndpointMXBean {
    public static final String NAME_PROPERTY = "name";
    public static final String MONITORING_STAT_PROPERTY = "monitoring.stat";
    private static final Logging log = Logging.getLogging(MonitoringEndpoint.class);
    private static final Map<Builder, MonitoringEndpoint> INSTANCES = new HashMap<Builder, MonitoringEndpoint>();
    private final Builder builder;
    private final String name;
    private final DataScheme scheme;
    private final List<Runnable> monitoringTasks = new ArrayList<Runnable>();
    private final JMXStats.RootRegistration statsRegistration;
    private final JMXEndpoint jmxEndpoint;
    private final MARSEndpoint marsEndpoint;
    private final long statPeriodMillis;
    private final ConnectorsMonitoringTask cmt;
    private final Management.Registration selfRegistration;
    private int refCounter;
    private final Map<MessageConnector, Management.Registration> jmxConnectors = new IdentityHashMap<MessageConnector, Management.Registration>();

    public static Builder newBuilder() {
        return new Builder();
    }

    MonitoringEndpoint(Builder builder, String name, DataScheme scheme, JMXStats.RootRegistration registration, JMXEndpoint jmxEndpoint, MARSEndpoint marsEndpoint, long configuredStartPeriodMillis) {
        this.builder = builder;
        this.name = name;
        this.scheme = scheme;
        this.statsRegistration = registration;
        this.jmxEndpoint = jmxEndpoint;
        this.marsEndpoint = marsEndpoint;
        this.statPeriodMillis = configuredStartPeriodMillis == 0L ? (long)MARSScheduler.MARS_DELAY * 1000L : configuredStartPeriodMillis;
        this.cmt = new ConnectorsMonitoringTask(name, (Logging)(configuredStartPeriodMillis != 0L ? log : null), registration.getRootStats(), marsEndpoint.getRoot(), null);
        this.registerMonitoringTask(this.cmt);
        this.selfRegistration = Management.registerMBean((Object)this, MonitoringEndpointMXBean.class, (String)("com.devexperts.qd.monitoring:type=MonitoringEndpoint,name=" + JMXNameBuilder.quoteKeyPropertyValue((String)name)));
    }

    @Override
    public boolean isLogStripedConnectors() {
        return this.cmt.isLogStripedConnectors();
    }

    @Override
    public void setLogStripedConnectors(boolean flag) {
        this.cmt.setLogStripedConnectors(flag);
    }

    void acquire() {
        if (this.refCounter++ > 0) {
            return;
        }
        for (Runnable task : this.monitoringTasks) {
            this.scheduleTask(task);
        }
    }

    private void scheduleTask(Runnable task) {
        MARSScheduler.schedule((Runnable)task, (long)this.statPeriodMillis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map<Builder, MonitoringEndpoint> map = INSTANCES;
        synchronized (map) {
            if (--this.refCounter > 0) {
                return;
            }
            INSTANCES.remove(this.builder);
            this.statsRegistration.unregister();
            this.selfRegistration.unregister();
            for (Runnable task : this.monitoringTasks) {
                MARSScheduler.cancel((Object)task);
            }
            this.jmxConnectors.values().forEach(Management.Registration::unregister);
            this.jmxConnectors.clear();
            this.cmt.close();
            this.marsEndpoint.release();
            this.jmxEndpoint.release();
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getDescriptorProperties() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String marsRootName = this.marsEndpoint.getMarsRootName();
        if (!marsRootName.isEmpty()) {
            result.put("mars.root", marsRootName);
        }
        return result;
    }

    public DataScheme getScheme() {
        return this.scheme;
    }

    public QDStats getRootStats() {
        return this.statsRegistration.getRootStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerMonitoringTask(Runnable task) {
        Map<Builder, MonitoringEndpoint> map = INSTANCES;
        synchronized (map) {
            this.monitoringTasks.add(task);
            if (this.refCounter > 0) {
                this.scheduleTask(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregisterMonitoringTask(Runnable task) {
        Map<Builder, MonitoringEndpoint> map = INSTANCES;
        synchronized (map) {
            this.monitoringTasks.remove(task);
            if (this.refCounter > 0) {
                MARSScheduler.cancel((Object)task);
            }
        }
    }

    public void addConnectors(Collection<MessageConnector> connectors) {
        for (MessageConnector connector : connectors) {
            this.jmxConnectors.put(connector, this.registerConnector(connector));
        }
        this.cmt.addConnectors(connectors);
    }

    public void removeConnectors(Collection<MessageConnector> connectors) {
        for (MessageConnector connector : connectors) {
            Management.Registration registration = this.jmxConnectors.remove(connector);
            if (registration == null) continue;
            registration.unregister();
        }
        this.cmt.removeConnectors(connectors);
    }

    private Management.Registration registerConnector(MessageConnector connector) {
        int index = 0;
        Management.Registration registration = Management.registerMBean((Object)connector, null, (String)MonitoringEndpoint.getConnectorJmxName(connector.getName()));
        while (registration.hasExisted()) {
            registration = Management.registerMBean((Object)connector, null, (String)MonitoringEndpoint.getConnectorJmxName(connector.getName() + "-" + ++index));
        }
        return registration;
    }

    private static String getConnectorJmxName(String name) {
        return "com.devexperts.qd.qtp:type=Connector,name=" + JMXNameBuilder.quoteKeyPropertyValue((String)name);
    }

    Consumer<String> droppedLogAccept() {
        return this.cmt::droppedLogAccept;
    }

    public static class Builder {
        private static final AtomicInteger INSTANCES_NUMERATOR = new AtomicInteger();
        private static final Set<String> SUPPORTED_PROPERTIES = new LinkedHashSet<String>(Arrays.asList("name", "monitoring.stat"));
        private final JMXEndpoint.Builder jmxEndpointBuilder = JMXEndpoint.newBuilder();
        private final MARSEndpoint.Builder marsEndpointBuilder = MARSEndpoint.newBuilder();
        private DataScheme scheme;
        private final Properties props = new Properties();

        Builder() {
        }

        public final Builder withScheme(DataScheme scheme) {
            if (scheme == null) {
                throw new NullPointerException();
            }
            this.scheme = scheme;
            return this;
        }

        public final Builder withProperty(String key, String value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (this.supportsProperty(key)) {
                this.props.setProperty(key, value);
            }
            return this;
        }

        public final Builder withProperties(Properties props) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.withProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        public boolean supportsProperty(String key) {
            return this.jmxEndpointBuilder.supportsProperty(key) || this.marsEndpointBuilder.supportsProperty(key) || SUPPORTED_PROPERTIES.contains(key);
        }

        private String getOrCreateName() {
            String name = this.props.getProperty(MonitoringEndpoint.NAME_PROPERTY);
            if (name != null) {
                return name;
            }
            int number = INSTANCES_NUMERATOR.getAndIncrement();
            return "monitoring" + (number == 0 ? "" : "-" + number);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MonitoringEndpoint acquire() {
            Map map = INSTANCES;
            synchronized (map) {
                MonitoringEndpoint endpoint = (MonitoringEndpoint)INSTANCES.get(this);
                if (endpoint == null) {
                    endpoint = this.build();
                    INSTANCES.put(this, endpoint);
                }
                endpoint.acquire();
                return endpoint;
            }
        }

        private MonitoringEndpoint build() {
            JMXEndpoint jmxEndpoint = this.jmxEndpointBuilder.withProperties(this.props).acquire();
            MARSEndpoint marsEndpoint = this.marsEndpointBuilder.withProperties(this.props).acquire();
            String name = this.getOrCreateName();
            for (String key : SUPPORTED_PROPERTIES) {
                if (!this.props.containsKey(key) || key.equals(MonitoringEndpoint.NAME_PROPERTY)) continue;
                log.info(name + " MonitoringEndpoint with " + key + "=" + this.props.getProperty(key));
            }
            String statProp = this.props.getProperty(MonitoringEndpoint.MONITORING_STAT_PROPERTY);
            long statPeriodMillis = statProp != null ? TimePeriod.valueOf((String)statProp).getTime() : 0L;
            MonitoringEndpoint endpoint = new MonitoringEndpoint(this, name, this.scheme, JMXStats.createRoot(name, this.scheme), jmxEndpoint, marsEndpoint, statPeriodMillis);
            return endpoint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)o;
            if (!this.props.equals(builder.props)) {
                return false;
            }
            return !(this.scheme != null ? !this.scheme.equals(builder.scheme) : builder.scheme != null);
        }

        public int hashCode() {
            int result = this.scheme != null ? this.scheme.hashCode() : 0;
            result = 31 * result + this.props.hashCode();
            return result;
        }
    }
}

