/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.logging.Logging;
import com.devexperts.management.Management;
import com.devexperts.qd.monitoring.JmxConnector;
import com.devexperts.qd.monitoring.JmxConnectors;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;

class JmxRmi {
    private static final Logging log = Logging.getLogging(JmxRmi.class);

    private JmxRmi() {
    }

    static JmxConnector init(Properties props) throws IOException {
        Integer port = Integer.decode(props.getProperty("jmx.rmi.port"));
        if (!JmxConnectors.isPortAvailable(port)) {
            return null;
        }
        String name = "com.devexperts.qd.monitoring:type=RmiServer,port=" + port;
        RMIJRMPServerImpl srvImpl = new RMIJRMPServerImpl(port, null, null, null);
        RMIConnectorServer rmiServer = new RMIConnectorServer(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi"), null, srvImpl, ManagementFactory.getPlatformMBeanServer());
        ConnectorImpl connector = new ConnectorImpl(port, name, rmiServer);
        if (!JmxConnectors.addConnector(connector)) {
            return null;
        }
        Registry registry = LocateRegistry.createRegistry(port);
        connector.setRegistry(registry);
        connector.setRegistration(Management.registerMBean((Object)rmiServer, null, (String)name));
        rmiServer.start();
        log.info("RMI management port is " + port);
        return connector;
    }

    private static class ConnectorImpl
    extends JmxConnector {
        private final RMIConnectorServer rmiServer;
        private Registry registry;

        ConnectorImpl(int port, String name, RMIConnectorServer rmiServer) {
            super(port, name);
            this.rmiServer = rmiServer;
        }

        void setRegistry(Registry registry) {
            this.registry = registry;
        }

        @Override
        public void stop() throws IOException {
            super.stop();
            this.rmiServer.stop();
            if (this.registry != null) {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
        }
    }
}

