/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.dump;

import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.management.dump.DebugDumpReader;
import com.devexperts.qd.impl.matrix.management.dump.DumpDataVisitor;
import com.devexperts.qd.impl.matrix.management.dump.DumpSubscriptionVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;

public class DebugDumpCLI {
    private final PrintStream out = System.out;
    private final DebugDumpReader reader;
    private final BufferedReader in;

    public DebugDumpCLI(DebugDumpReader reader) {
        this.reader = reader;
        this.in = new BufferedReader(new InputStreamReader(System.in));
    }

    private void help() {
        this.out.println("--- Supported commands ---");
        this.out.println((Object)((Object)Cmd.INFO) + "                         - Print dump info");
        this.out.println((Object)((Object)Cmd.VERIFY) + "                       - Verify dump's integrity");
        this.out.println((Object)((Object)Cmd.SUB) + " [<symbol> [<record>]]    - Print total & agent subscription");
        this.out.println((Object)((Object)Cmd.DATA) + " [<symbol> [<record>]]   - Print stored data");
        this.out.println((Object)((Object)Cmd.QUEUE) + " [<symbol> [<record>]]  - Analyze queue");
        this.out.println((Object)((Object)Cmd.SYMBOL) + " [<symbol> [<record>]] - Analyze symbol refs inside core");
    }

    public void interactive() throws IOException {
        String line;
        this.reader.dumpInfo();
        this.help();
        while ((line = this.readLine()) != null) {
            this.execute(line.split("\\s+"));
        }
    }

    private String readLine() throws IOException {
        this.out.print("? ");
        return this.in.readLine();
    }

    public void execute(String[] args) {
        int plusIndex;
        while ((plusIndex = Arrays.asList(args).indexOf("+")) > 0 && plusIndex < args.length - 1) {
            this.executeOne(Arrays.copyOf(args, plusIndex));
            args = Arrays.copyOfRange(args, plusIndex + 1, args.length);
        }
        this.executeOne(args);
    }

    private void executeOne(String[] args) {
        Cmd cmd;
        try {
            cmd = Cmd.valueOf(args[0].toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            this.out.println("Unknown command '" + args[0] + "'");
            this.help();
            return;
        }
        String filterSymbol = args.length > 1 ? args[1] : null;
        String filterRecord = args.length > 2 ? args[2] : null;
        CollectorDebug.RehashCrashInfo rci = this.reader.getRehashCrashInfo();
        switch (cmd) {
            case INFO: {
                this.reader.dumpInfo();
                break;
            }
            case VERIFY: {
                this.reader.visit(this.reader.getOwner(), collector -> collector.verify(CollectorDebug.CONSOLE, rci));
                break;
            }
            case SUB: {
                this.reader.visit(this.reader.getOwner(), new DumpSubscriptionVisitor(this.out, filterSymbol, filterRecord));
                break;
            }
            case DATA: {
                this.reader.visit(this.reader.getOwner(), new DumpDataVisitor(this.out, filterSymbol, filterRecord));
                break;
            }
            case QUEUE: {
                this.reader.visit(this.reader.getOwner(), collector -> collector.analyzeQueue(CollectorDebug.CONSOLE, filterSymbol, filterRecord));
                break;
            }
            case SYMBOL: {
                this.reader.visit(this.reader.getOwner(), collector -> collector.analyzeSymbolRefs(CollectorDebug.CONSOLE, filterSymbol, filterRecord, rci));
            }
        }
    }

    private static enum Cmd {
        INFO,
        VERIFY,
        SUB,
        DATA,
        QUEUE,
        SYMBOL;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

