/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.impl;

import com.devexperts.logging.Logging;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.management.CollectorManagement;
import com.devexperts.qd.impl.matrix.management.dump.DebugDumpImpl;
import com.devexperts.qd.impl.matrix.management.impl.CollectorCountersImpl;
import com.devexperts.qd.impl.matrix.management.impl.CollectorMXBean;
import com.devexperts.qd.impl.matrix.management.impl.CollectorManagementImplOneContract;
import com.devexperts.qd.impl.matrix.management.impl.ReportBuilder;
import com.devexperts.qd.impl.matrix.management.impl.SubscriptionDumpImpl;
import com.devexperts.qd.ng.AbstractRecordSink;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.util.TimePeriod;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class CollectorManagementImplBase
extends CollectorManagement
implements CollectorMXBean {
    private static final int REPORT_ROWS_LIMIT = 10000;
    private static final Logging log = Logging.getLogging(CollectorManagementImplBase.class);
    protected final String keyProperties;
    protected final String name;

    protected CollectorManagementImplBase(DataScheme scheme, QDContract contract, String keyProperties, String name) {
        super(scheme, contract);
        this.keyProperties = keyProperties;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected abstract List<Collector> getCollectors();

    @Override
    public int getCollectorCount() {
        return this.getCollectors().size();
    }

    @Override
    public void verifyCollectors() {
        for (Collector c : this.getCollectors()) {
            c.verify(CollectorDebug.DEFAULT, null);
        }
    }

    @Override
    public void dumpSubscriptionToFile(String file) {
        SubscriptionDumpImpl.makeDump(file, this.scheme, this.getCollectors());
    }

    @Override
    public void dumpCollectorsToFile(String file) {
        DebugDumpImpl.makeDump(file, this.getCollectors());
    }

    @Override
    public String reportData(String recordName, String symbol, boolean boundsOnly, String format) {
        log.info("reportData(" + recordName + "," + symbol + "," + boundsOnly + "," + format + ")");
        ReportBuilder rb = new ReportBuilder(format);
        try {
            for (Collector collector : this.getCollectors()) {
                this.reportDataImpl(rb, collector, recordName, symbol, boundsOnly);
            }
            log.info("reportData = " + rb.getLineCount() + " lines");
            return rb.toString();
        }
        catch (Throwable t) {
            log.error("reportData failed", t);
            throw t;
        }
    }

    @Override
    public String reportSubscription(String recordName, String symbol, String format) {
        log.info("reportSubscription(" + recordName + "," + symbol + "," + format + ")");
        try {
            ReportBuilder rb = new ReportBuilder(format);
            for (Collector collector : this.getCollectors()) {
                this.reportSubscriptionImpl(rb, collector, recordName, symbol);
            }
            log.info("reportSubscription = " + rb.getLineCount() + " lines");
            return rb.toString();
        }
        catch (Throwable t) {
            log.error("reportSubscription failed", t);
            throw t;
        }
    }

    private void reportDataImpl(ReportBuilder rb, Collector collector, String recordName, String symbol, boolean boundsOnly) {
        DataRecord record;
        QDContract contract = collector.getContract();
        if (!contract.hasSnapshotData()) {
            return;
        }
        rb.header(this.nameCollector(collector), 1);
        DataScheme scheme = collector.getScheme();
        boolean allSymbols = "*".equals(symbol);
        boolean allRecords = "*".equals(recordName);
        int cipher = allSymbols ? 0 : scheme.getCodec().encode(symbol);
        DataRecord dataRecord = record = allRecords ? null : scheme.findRecordByName(recordName);
        if (!allRecords && record == null) {
            rb.message("No such record in scheme");
            return;
        }
        ReportDataSink sink = new ReportDataSink(rb, contract, record, cipher, symbol, allSymbols, allRecords, boundsOnly);
        sink.begin();
        if (!allRecords && !allSymbols) {
            RecordBuffer sub = RecordBuffer.getInstance((RecordMode)RecordMode.SUBSCRIPTION);
            sub.add(record, cipher, symbol);
            collector.examineDataBySubscription((RecordSink)sink, (RecordSource)sub);
            sub.release();
        } else {
            collector.examineData((RecordSink)sink);
        }
        sink.end();
    }

    private void reportSubscriptionImpl(ReportBuilder rb, Collector collector, String recordName, String symbol) {
        DataRecord record;
        QDContract contract = collector.getContract();
        rb.header(this.nameCollector(collector), 1);
        DataScheme scheme = collector.getScheme();
        boolean allSymbols = "*".equals(symbol);
        boolean allRecords = "*".equals(recordName);
        int cipher = allSymbols ? 0 : scheme.getCodec().encode(symbol);
        DataRecord dataRecord = record = allRecords ? null : scheme.findRecordByName(recordName);
        if (!allRecords && record == null) {
            rb.message("No such record in scheme");
            return;
        }
        ReportSubscriptionSink sink = new ReportSubscriptionSink(rb, contract, cipher, symbol, record, allSymbols, allRecords);
        sink.begin();
        collector.examineSubscription((RecordSink)sink);
        sink.end();
    }

    private String nameCollector(Collector collector) {
        CollectorManagementImplOneContract management = (CollectorManagementImplOneContract)collector.getManagement();
        return management.getName() + " @" + Integer.toHexString(System.identityHashCode(collector));
    }

    private CollectorCountersImpl completeCountersSinceSnapshot() {
        List<Collector> collectors = this.getCollectors();
        if (collectors.size() == 1) {
            return (CollectorCountersImpl)collectors.get(0).getCountersSinceSnapshot();
        }
        CollectorCountersImpl result = new CollectorCountersImpl(this.scheme, 0L, 0);
        for (Collector collector : collectors) {
            result.add((CollectorCountersImpl)collector.getCountersSinceSnapshot());
        }
        return result;
    }

    @Override
    public String getAllLockOperations() {
        return CollectorCountersImpl.getAllLockOperations();
    }

    @Override
    public String getCounters() {
        return this.completeCountersSinceSnapshot().toString();
    }

    @Override
    public String reportCounters(String format, Integer topSize) {
        int top = topSize == null ? 5 : topSize;
        ReportBuilder rb = new ReportBuilder(format);
        List<Collector> collectors = this.getCollectors();
        for (Collector collector : collectors) {
            CollectorCountersImpl counters = (CollectorCountersImpl)collector.getCountersSinceSnapshot();
            counters.reportTo(rb, this.nameCollector(collector), top);
        }
        if (collectors.size() > 1) {
            this.completeCountersSinceSnapshot().reportTo(rb, this.name, top);
        }
        return rb.toString();
    }

    @Override
    public void resetCounters() {
        for (Collector collector : this.getCollectors()) {
            collector.snapshotCounters();
        }
    }

    @Override
    public String applyStickySubscriptionPeriod(String regexp, String period) {
        long stickySubscriptionPeriod = TimePeriod.valueOf((String)period, (TimePeriod)TimePeriod.ZERO).getTime();
        Stream<Object> stream = this.getCollectors().stream();
        if (regexp != null && !regexp.isEmpty()) {
            Pattern pattern = Pattern.compile(regexp);
            stream = stream.filter(collector -> pattern.matcher(this.prepareCollectorName((Collector)collector)).find());
        }
        String appliedCollectors = stream.map(collector -> {
            collector.setStickySubscriptionPeriod(stickySubscriptionPeriod);
            return this.prepareCollectorName((Collector)collector);
        }).collect(Collectors.joining("; "));
        return "Apply sticky subscription period: " + period + " to collectors: " + appliedCollectors;
    }

    @Override
    public String getStickySubscriptionPeriod() {
        return this.getCollectors().stream().map(Collector::getStickySubscriptionPeriod).distinct().map(TimePeriod::valueOf).map(TimePeriod::toString).collect(Collectors.joining(", "));
    }

    private String prepareCollectorName(Collector collector) {
        QDStats qdStats = collector.getStats();
        return qdStats.getFullKeyProperties() + ",c=" + qdStats.getType();
    }

    private static class ReportSubscriptionSink
    extends AbstractRecordSink {
        private final ReportBuilder rb;
        private final QDContract contract;
        private final int cipher;
        private final String symbol;
        private final DataRecord record;
        private final boolean allSymbols;
        private final boolean allRecords;
        private int totalRows;

        ReportSubscriptionSink(ReportBuilder rb, QDContract contract, int cipher, String symbol, DataRecord record, boolean allSymbols, boolean allRecords) {
            this.rb = rb;
            this.contract = contract;
            this.cipher = cipher;
            this.symbol = symbol;
            this.record = record;
            this.allSymbols = allSymbols;
            this.allRecords = allRecords;
        }

        void begin() {
            this.rb.beginTable().newRow();
            this.rb.td("Record");
            this.rb.td("Symbol");
            if (this.contract.hasTime()) {
                this.rb.td("Time (hi)");
                this.rb.td("Time (lo)");
                this.rb.td("Time (long)");
            }
        }

        public void append(RecordCursor cursor) {
            if (this.totalRows >= 10000) {
                return;
            }
            if (!this.allSymbols && (this.cipher == 0 ? !this.symbol.equals(cursor.getSymbol()) : this.cipher != cursor.getCipher())) {
                return;
            }
            if (!this.allRecords && this.record != cursor.getRecord()) {
                return;
            }
            ++this.totalRows;
            this.rb.newRow();
            this.rb.td(cursor.getRecord().getName());
            this.rb.td(cursor.getDecodedSymbol());
            if (this.contract.hasTime()) {
                this.rb.td(cursor.getRecord().getIntField(0).getString(cursor));
                this.rb.td(cursor.getRecord().getIntField(1).getString(cursor));
                this.rb.td(cursor.getTime());
            }
        }

        void end() {
            this.rb.endTable();
            this.rb.message("Total rows: " + this.totalRows);
        }
    }

    private static class ReportDataSink
    extends AbstractRecordSink {
        private final ReportBuilder rb;
        private final QDContract contract;
        private final DataRecord record;
        private final int cipher;
        private final String symbol;
        private final boolean allSymbols;
        private final boolean allRecords;
        private final boolean boundsOnly;
        private int totalRows;
        private int shownRows;
        private RecordCursor.Owner lastOwner;
        private RecordCursor last;
        private boolean hasLast;

        ReportDataSink(ReportBuilder rb, QDContract contract, DataRecord record, int cipher, String symbol, boolean allSymbols, boolean allRecords, boolean boundsOnly) {
            this.rb = rb;
            this.contract = contract;
            this.record = record;
            this.cipher = cipher;
            this.symbol = symbol;
            this.allSymbols = allSymbols;
            this.allRecords = allRecords;
            this.boundsOnly = boundsOnly;
        }

        void begin() {
            int i;
            if (this.contract == QDContract.HISTORY && this.boundsOnly) {
                this.rb.message("Note: Only first and last rows are shown");
            }
            this.rb.beginTable().newRow();
            this.rb.td("Record");
            this.rb.td("Symbol");
            if (this.record == null) {
                return;
            }
            for (i = 0; i < this.record.getIntFieldCount(); ++i) {
                this.rb.td(this.record.getIntField(i).getLocalName());
            }
            for (i = 0; i < this.record.getObjFieldCount(); ++i) {
                this.rb.td(this.record.getObjField(i).getLocalName());
            }
            if (this.contract.usesEventFlags()) {
                this.rb.td("EventFlags");
            }
        }

        public void append(RecordCursor cursor) {
            if (this.shownRows >= 10000) {
                return;
            }
            if (!this.allSymbols && (this.cipher == 0 ? !this.symbol.equals(cursor.getSymbol()) : this.cipher != cursor.getCipher())) {
                return;
            }
            if (!this.allRecords && this.record != cursor.getRecord()) {
                return;
            }
            ++this.totalRows;
            if (this.boundsOnly) {
                if (!this.hasLast || this.last.getRecord() != cursor.getRecord() || (this.last.getCipher() == 0 ? !this.last.getSymbol().equals(cursor.getSymbol()) : this.last.getCipher() != cursor.getCipher())) {
                    this.flushLast();
                    this.printDataRow(cursor);
                }
                if (this.last == null || this.last.getRecord() != cursor.getRecord()) {
                    this.lastOwner = RecordCursor.allocateOwner((DataRecord)cursor.getRecord(), (RecordMode)RecordMode.FLAGGED_DATA);
                    this.last = this.lastOwner.cursor();
                }
                this.lastOwner.setSymbol(cursor.getCipher(), cursor.getSymbol());
                this.last.copyFrom(cursor);
                this.hasLast = true;
            } else {
                this.printDataRow(cursor);
            }
        }

        private void flushLast() {
            if (this.hasLast) {
                this.printDataRow(this.last);
                this.hasLast = false;
            }
        }

        void end() {
            this.flushLast();
            this.rb.endTable();
            this.rb.message("Total rows: " + this.totalRows);
            if (this.contract == QDContract.HISTORY && this.boundsOnly) {
                this.rb.message("Shown rows: " + this.shownRows);
            }
        }

        private void printDataRow(RecordCursor cursor) {
            int i;
            ++this.shownRows;
            this.rb.newRow();
            DataRecord record = cursor.getRecord();
            this.rb.td(record.getName());
            this.rb.td(cursor.getDecodedSymbol());
            for (i = 0; i < record.getIntFieldCount(); ++i) {
                this.rb.td(record.getIntField(i).getString(cursor));
            }
            for (i = 0; i < record.getObjFieldCount(); ++i) {
                this.rb.td(record.getObjField(i).getString(cursor));
            }
            if (this.contract.usesEventFlags()) {
                this.rb.td(EventFlag.formatEventFlags((int)cursor.getEventFlags(), (MessageType)MessageType.forData((QDContract)this.contract)));
            }
        }
    }
}

