/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.impl;

import com.devexperts.qd.impl.matrix.management.impl.ReportBuilder;
import com.devexperts.util.TimeDistribution;

public class LockCounters {
    private final TimeDistribution wait;
    private final TimeDistribution lock;

    public LockCounters() {
        this.wait = new TimeDistribution(TimeDistribution.Precision.LOW);
        this.lock = new TimeDistribution(TimeDistribution.Precision.LOW);
    }

    public LockCounters(LockCounters other) {
        this.wait = new TimeDistribution(other.wait);
        this.lock = new TimeDistribution(other.lock);
    }

    public LockCounters(LockCounters cur, LockCounters old) {
        this.wait = new TimeDistribution(cur.wait, old.wait);
        this.lock = new TimeDistribution(cur.lock, old.lock);
    }

    public void add(LockCounters other) {
        this.wait.add(other.wait);
        this.lock.add(other.lock);
    }

    public TimeDistribution getWaitTimes() {
        return this.wait;
    }

    public TimeDistribution getLockTimes() {
        return this.lock;
    }

    public void countLock(long waitNanos, long lockNanos) {
        if (waitNanos > 0L && this.wait != null) {
            this.wait.addMeasurement(waitNanos);
        }
        if (this.lock != null) {
            this.lock.addMeasurement(lockNanos);
        }
    }

    public String fmtString(long millis) {
        return "{" + (this.wait.getCount() > 0L ? "wait " + LockCounters.fmtDistribution(this.wait, millis) + "; " : "") + "lock " + LockCounters.fmtDistribution(this.lock, millis) + "}";
    }

    public void reportDataTo(ReportBuilder rb, long millis) {
        LockCounters.reportDistributionDataTo(rb, this.wait, millis);
        LockCounters.reportDistributionDataTo(rb, this.lock, millis);
    }

    public static void reportHeaderTo(ReportBuilder rb) {
        LockCounters.reportDistributionHeaderTo(rb, "WAIT");
        LockCounters.reportDistributionHeaderTo(rb, "LOCK");
    }

    private static String fmtDistribution(TimeDistribution dist, long millis) {
        int percent = millis == 0L ? 0 : (int)(dist.getSumNanos() / ((double)millis * 10000.0));
        return (percent == 0 ? "" : percent + "% 1cpu, ") + dist.toString();
    }

    private static void reportDistributionDataTo(ReportBuilder rb, TimeDistribution dist, long millis) {
        int percent = millis == 0L ? 0 : (int)(dist.getSumNanos() / ((double)millis * 10000.0));
        rb.td(percent).td(dist.getCount());
        rb.td(TimeDistribution.formatNanos((long)dist.getAverageNanos()));
        rb.td(TimeDistribution.formatNanos((long)dist.getMinNanos()));
        rb.td(TimeDistribution.formatNanos((long)dist.getLowerNanos()));
        rb.td(TimeDistribution.formatNanos((long)dist.getMedianNanos()));
        rb.td(TimeDistribution.formatNanos((long)dist.getUpperNanos()));
        rb.td(TimeDistribution.formatNanos((long)dist.getMaxNanos()));
    }

    private static void reportDistributionHeaderTo(ReportBuilder rb, String type) {
        rb.td(type + "%").td("times");
        rb.td("avg");
        rb.td("min");
        rb.td("lower");
        rb.td("median");
        rb.td("upper");
        rb.td("max");
    }
}

