/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.logging.Logging;
import com.devexperts.mars.common.MARSNode;
import com.devexperts.mars.jvm.CpuCounter;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.monitoring.IOCounter;
import com.devexperts.qd.monitoring.IOCounterKey;
import com.devexperts.qd.monitoring.IOCounters;
import com.devexperts.qd.monitoring.MonitoringCounter;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimeFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class ConnectorsMonitoringTask
implements Runnable {
    private static final boolean DEFAULT_LOG_STRIPED_CONNECTORS = SystemProperties.getBooleanProperty((String)"com.devexperts.qd.logStripedConnectors", (boolean)false);
    private final String name;
    private final Logging log;
    private final MARSNode connectorsNode;
    private final MARSNode subscriptionNode;
    private final MARSNode storageNode;
    private final MARSNode bufferNode;
    private final MARSNode droppedNode;
    private final MARSNode droppedLogNode;
    private final MARSNode stickySubNode;
    private final Queue<String> queueDroppedLog = new ConcurrentLinkedQueue<String>();
    private long prevDropped;
    private boolean closed;
    private final MonitoringCounter time = new MonitoringCounter();
    private final List<QDStats> rootStats = new CopyOnWriteArrayList<QDStats>();
    private final List<MessageConnector> connectors = new CopyOnWriteArrayList<MessageConnector>();
    private final CpuCounter cpu = new CpuCounter();
    private final IOCounters rootCounters;
    private final Map<String, IOCounters> countersByName = new TreeMap<String, IOCounters>();
    private final Map<IOCounterKey, IOCounter> snapshot = new HashMap<IOCounterKey, IOCounter>();
    private final NumberFormat integerFormat = NumberFormat.getIntegerInstance(Locale.US);
    private final NumberFormat percentFormat = NumberFormat.getPercentInstance(Locale.US);
    private boolean logStripedConnectors;

    public ConnectorsMonitoringTask() {
        this(null, Logging.getLogging(ConnectorsMonitoringTask.class), null, MARSNode.getRoot(), null);
    }

    public ConnectorsMonitoringTask(QDStats rootStats) {
        this(null, Logging.getLogging(ConnectorsMonitoringTask.class), rootStats, MARSNode.getRoot(), null);
    }

    public ConnectorsMonitoringTask(QDStats rootStats, List<MessageConnector> connectors) {
        this(null, Logging.getLogging(ConnectorsMonitoringTask.class), rootStats, MARSNode.getRoot(), connectors);
    }

    public ConnectorsMonitoringTask(QDStats rootStats, MARSNode rootNode) {
        this(null, Logging.getLogging(ConnectorsMonitoringTask.class), rootStats, rootNode, null);
    }

    public ConnectorsMonitoringTask(String name, Logging log, QDStats rootStats, MARSNode rootNode, List<MessageConnector> connectors) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        this.logStripedConnectors = DEFAULT_LOG_STRIPED_CONNECTORS;
        this.name = name;
        this.log = log;
        MARSNode node = name == null ? rootNode.subNode("qd", "QD Stats") : rootNode.subNode("qd-" + name, "QD Stats for " + name + " endpoint");
        node.setValue(QDFactory.getVersion());
        this.connectorsNode = node.subNode("connectors", "All connectors");
        this.subscriptionNode = node.subNode("subscription", "Total subscription size");
        this.stickySubNode = node.subNode("sticky_subscription", "Total sticky subscription size");
        this.storageNode = node.subNode("storage", "Total storage size");
        this.bufferNode = node.subNode("buffer", "Total outgoing buffer size");
        this.droppedNode = node.subNode("dropped", "Total dropped records");
        this.droppedLogNode = node.subNode("dropped_log", "Last message about dropped records");
        this.rootCounters = new IOCounters(null, node);
        this.time.update(System.currentTimeMillis());
        if (connectors != null) {
            this.addConnectors(connectors);
        }
        if (rootStats != null) {
            this.addStats(rootStats);
        }
        if (log != null) {
            log.info("Log striped connectors: " + this.logStripedConnectors);
        }
    }

    public void close() {
        this.closed = true;
        this.cpu.close();
        this.queueDroppedLog.clear();
    }

    public synchronized void addStats(QDStats stats) {
        this.rootStats.add(stats);
    }

    public synchronized void addConnectors(Collection<MessageConnector> connectors) {
        this.connectors.addAll(connectors);
    }

    public synchronized void removeConnectors(Collection<MessageConnector> connectors) {
        this.connectors.removeAll(connectors);
    }

    public boolean isLogStripedConnectors() {
        return this.logStripedConnectors;
    }

    public void setLogStripedConnectors(boolean logStripedConnectors) {
        if (this.logStripedConnectors != logStripedConnectors) {
            this.logStripedConnectors = logStripedConnectors;
            if (this.log != null) {
                this.log.info("Log striped connectors: " + this.logStripedConnectors);
            }
        }
    }

    @Override
    public void run() {
        if (this.log != null) {
            this.log.info("\b" + this.report());
        } else {
            this.reportImpl(null);
        }
    }

    public String report() {
        StringBuilder sb = new StringBuilder();
        this.reportImpl(sb);
        return sb.toString();
    }

    private long elapsedTime() {
        long elapsedTime = this.time.update(System.currentTimeMillis());
        return elapsedTime <= 0L ? 1L : elapsedTime;
    }

    private synchronized void reportImpl(StringBuilder buff) {
        int n;
        Object s;
        long elapsedTime = this.elapsedTime();
        long subscription = 0L;
        long stickySub = 0L;
        long storage = 0L;
        long buffer = 0L;
        long totalDroppedRecords = 0L;
        for (QDStats stats : this.rootStats) {
            subscription += stats.getOrVoid(QDStats.SType.UNIQUE_SUB).getValue(QDStats.SValue.RID_SIZE);
            stickySub += stats.getOrVoid(QDStats.SType.STICKY_SUB).getValue(QDStats.SValue.RID_SIZE);
            storage += stats.getOrVoid(QDStats.SType.STORAGE_DATA).getValue(QDStats.SValue.RID_SIZE);
            buffer += stats.getOrVoid(QDStats.SType.AGENT_DATA).getValue(QDStats.SValue.RID_SIZE);
            totalDroppedRecords += stats.getOrVoid(QDStats.SType.DROPPED_DATA).getValue(QDStats.SValue.RID_SIZE);
        }
        long droppedByPeriod = totalDroppedRecords - this.prevDropped;
        this.prevDropped = totalDroppedRecords;
        this.subscriptionNode.setDoubleValue((double)subscription);
        this.stickySubNode.setDoubleValue((double)stickySub);
        this.storageNode.setDoubleValue((double)storage);
        this.bufferNode.setDoubleValue((double)buffer);
        this.droppedNode.setDoubleValue((double)droppedByPeriod);
        while ((s = this.queueDroppedLog.poll()) != null) {
            this.droppedLogNode.setValue(TimeFormat.GMT.withTimeZone().format(System.currentTimeMillis()) + " " + (String)s);
        }
        this.rootCounters.beforeAggregate();
        this.snapshot.values().forEach(IOCounter::resetUnused);
        this.countersByName.values().forEach(IOCounters::beforeAggregate);
        for (MessageConnector messageConnector : this.connectors) {
            List<QDStats> stripedQdStats = this.getStripedConnections(messageConnector.getStats().getOrVoid(QDStats.SType.CONNECTIONS));
            IOCounterKey key = new IOCounterKey(messageConnector, null);
            IOCounters counters = this.countersByName.computeIfAbsent(key.name, this::createSumStats);
            if (stripedQdStats.isEmpty()) {
                IOCounter stats = this.snapshot.computeIfAbsent(key, k -> new IOCounter(messageConnector, messageConnector.getStats()));
                stats.collect();
                this.rootCounters.aggregate(stats);
                counters.aggregate(stats);
                continue;
            }
            for (QDStats qdStats : stripedQdStats) {
                IOCounterKey stripeKey = new IOCounterKey(messageConnector, this.getStripeName(qdStats));
                IOCounter stats = this.snapshot.computeIfAbsent(stripeKey, k -> new IOCounter(messageConnector, qdStats));
                if (stats.getStats() != qdStats) {
                    stats = new IOCounter(messageConnector, qdStats);
                    this.snapshot.put(stripeKey, stats);
                }
                stats.collect();
                this.rootCounters.aggregate(stats);
                counters.aggregate(stats);
                this.countersByName.computeIfAbsent(stripeKey.name, this::createStripeSumStats).aggregate(stats);
            }
        }
        this.rootCounters.afterAggregate();
        this.countersByName.values().removeIf(IOCounters::afterAggregate);
        this.snapshot.values().removeIf(IOCounter::isUnused);
        List reportedCounters = this.countersByName.values().stream().filter(c -> this.logStripedConnectors || !c.isStripeNode()).collect(Collectors.toList());
        if (buff == null) {
            this.rootCounters.report(this.integerFormat, elapsedTime, null);
            for (IOCounters ios : reportedCounters) {
                ios.report(this.integerFormat, elapsedTime, null);
            }
            return;
        }
        if (this.name != null) {
            buff.append("{").append(this.name).append("} ");
        }
        buff.append("Subscription: ").append(this.integerFormat.format(subscription)).append("; Sticky: ").append(this.integerFormat.format(stickySub)).append("; Storage: ").append(this.integerFormat.format(storage)).append("; Buffer: ").append(this.integerFormat.format(buffer)).append("; Dropped: ").append(this.integerFormat.format(droppedByPeriod)).append("; ");
        this.rootCounters.report(this.integerFormat, elapsedTime, buff);
        buff.append("; CPU: ").append(this.percentFormat.format(this.cpu.getCpuUsage()));
        boolean bl = false;
        int maxAddressLen = 0;
        for (IOCounters ios : reportedCounters) {
            n = Math.max(n, ios.displayName.length());
            maxAddressLen = Math.max(maxAddressLen, ios.displayAddress.length());
        }
        for (IOCounters ios : reportedCounters) {
            buff.append("\n    ");
            ConnectorsMonitoringTask.padRight(buff, ios.displayName, n);
            buff.append(" ");
            ConnectorsMonitoringTask.padRight(buff, ios.displayAddress, maxAddressLen);
            buff.append(" [").append(ios.connectionsCount).append("] ");
            ios.report(this.integerFormat, elapsedTime, buff);
        }
    }

    private List<QDStats> getStripedConnections(QDStats stats) {
        return stats.getAll(QDStats.SType.CONNECTION).stream().filter(s -> s.getKeyProperties().startsWith("stripe=")).collect(Collectors.toList());
    }

    private String getStripeName(QDStats stats) {
        String striperProperty;
        int to = (striperProperty = stats.getKeyProperties().substring("stripe=".length())).indexOf(44);
        return striperProperty.substring(0, to > 0 ? to : striperProperty.length());
    }

    private IOCounters createSumStats(String name) {
        return new IOCounters(name, this.connectorsNode);
    }

    private IOCounters createStripeSumStats(String name) {
        return new IOCounters(name, this.connectorsNode, true);
    }

    private static void padRight(StringBuilder sb, String s, int len) {
        sb.append(s);
        for (int i = s.length(); i < len; ++i) {
            sb.append(' ');
        }
    }

    void droppedLogAccept(String message) {
        if (!this.closed) {
            this.queueDroppedLog.add(message);
        }
    }
}

