/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management.dump;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.HistoryBuffer;
import com.devexperts.qd.impl.matrix.HistoryBufferDebugSink;
import com.devexperts.qd.impl.matrix.management.dump.CollectorVisitor;
import com.devexperts.qd.impl.matrix.management.dump.DumpUtil;
import com.devexperts.qd.impl.matrix.management.dump.DumpVisitorBase;
import com.devexperts.qd.kit.VoidIntField;
import com.devexperts.qd.kit.VoidObjField;
import com.devexperts.qd.ng.AbstractRecordSink;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordSink;
import java.io.PrintStream;

class DumpDataVisitor
extends DumpVisitorBase
implements CollectorVisitor {
    DumpDataVisitor(PrintStream out, String filterSymbol, String filterRecord) {
        super(out, filterSymbol, filterRecord);
    }

    @Override
    public void visit(Collector collector) {
        this.out.println("--- Data from " + collector);
        collector.examineData((RecordSink)new DumpDataSink());
    }

    class DumpDataSink
    extends AbstractRecordSink
    implements HistoryBufferDebugSink {
        DumpDataSink() {
        }

        public void visitHistoryBuffer(DataRecord record, int cipher, String encodedSymbol, long timeTotalSub, HistoryBuffer hb) {
            String symbol = record.getScheme().getCodec().decode(cipher, encodedSymbol);
            if (!DumpDataVisitor.this.matches(record, symbol)) {
                return;
            }
            DumpDataVisitor.this.out.println("HistoryBuffer " + record + " " + symbol);
            DumpDataVisitor.this.out.println("\tisTx=" + hb.isTx());
            DumpDataVisitor.this.out.println("\tisSweepTx=" + hb.isSweepTx());
            DumpDataVisitor.this.out.println("\twasSnapshotBeginSeen=" + hb.wasSnapshotBeginSeen());
            DumpDataVisitor.this.out.println("\twasSnapshotEndSeen=" + hb.wasSnapshotEndSeen());
            DumpDataVisitor.this.out.println("\twasEverSnapshotMode=" + hb.wasEverSnapshotMode());
            DumpDataVisitor.this.out.println("\tisWaitingForSnapshotBegin=" + hb.isWaitingForSnapshotBegin());
            DumpDataVisitor.this.out.println("\tgetSnapshotTime=" + DumpUtil.timeString(record, hb.getSnapshotTime()));
            DumpDataVisitor.this.out.println("\tgetEverSnapshotTime=" + DumpUtil.timeString(record, hb.getEverSnapshotTime()));
            DumpDataVisitor.this.out.println("\tgetSnipSnapshotTime=" + DumpUtil.timeString(record, hb.getSnipSnapshotTime()));
            DumpDataVisitor.this.out.println("\ttimeTotalSub=" + DumpUtil.timeString(record, timeTotalSub));
        }

        public void append(RecordCursor cursor) {
            DataIntField field;
            int i;
            String symbol;
            DataRecord record = cursor.getRecord();
            if (!DumpDataVisitor.this.matches(record, symbol = cursor.getDecodedSymbol())) {
                return;
            }
            DumpDataVisitor.this.out.print(record.getName());
            DumpDataVisitor.this.out.print('\t');
            DumpDataVisitor.this.out.print(symbol);
            for (i = 0; i < cursor.getIntCount(); ++i) {
                field = record.getIntField(i);
                if (field instanceof VoidIntField) continue;
                DumpDataVisitor.this.out.print('\t');
                DumpDataVisitor.this.out.print(field.getString(cursor));
            }
            for (i = 0; i < cursor.getObjCount(); ++i) {
                field = record.getIntField(i);
                if (field instanceof VoidObjField) continue;
                DumpDataVisitor.this.out.print('\t');
                DumpDataVisitor.this.out.print(field.getString(cursor));
            }
            if (cursor.getEventFlags() != 0) {
                DumpDataVisitor.this.out.print('\t');
                DumpDataVisitor.this.out.print("EventFlags");
                DumpDataVisitor.this.out.print('=');
                DumpDataVisitor.this.out.print(EventFlag.formatEventFlags((int)cursor.getEventFlags()));
            }
            DumpDataVisitor.this.out.println();
        }

        public void visitDone(DataRecord record, int cipher, String encodedSymbol, int examineMethodResult) {
            String symbol = record.getScheme().getCodec().decode(cipher, encodedSymbol);
            if (!DumpDataVisitor.this.matches(record, symbol)) {
                return;
            }
            DumpDataVisitor.this.out.println("HistoryBuffer examined=" + examineMethodResult);
        }
    }
}

