package com.dxfeed.acs;

import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.promise.Promise;

import java.util.List;

/**
 * Provides access to historical {@link TimeAndSale} events in DXFeed Chart Server.
 */
public interface TickService {
    /**
     * Requests TimeAndSale's for passed symbol, from and to time. {@code from} and {@code to} time will be rounded to
     * second precision (millis part thrown away)
     *
     * @param symbol symbol to request
     * @param from   the time, inclusive, to request events from (see {@link TimeAndSale#getTime() TimeAndSale.getTime}).
     * @param to     the time, exclusive, to request events to (see {@link TimeAndSale#getTime() TimeAndSale.getTime}).
     * @return the promise for the result of request
     */
    public Promise<List<TimeAndSale>> getTicksPromise(String symbol, long from, long to);
}
