/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.acs.sample;

import com.devexperts.rmi.RMIEndpoint;
import com.dxfeed.acs.TickService;
import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.promise.Promise;
import java.util.List;

public class TicksPromiseSample {
    private TicksPromiseSample() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: 'java -cp acs-api\\lib\\* com.dxfeed.acs.sample.TicksPromiseSample <apiAddress> <symbol>'");
            System.out.println("\t<apiAddress> - API RMI address");
            System.out.println("\t<symbol>  - symbol to request");
            System.exit(0);
        }
        String apiAddress = args[0];
        String symbol = args[1];
        RMIEndpoint newEndpoint = RMIEndpoint.createEndpoint((RMIEndpoint.Side)RMIEndpoint.Side.CLIENT);
        newEndpoint.connect(apiAddress);
        TickService tickService = (TickService)newEndpoint.getClient().getProxy(TickService.class);
        long toTime = System.currentTimeMillis() - 60000L;
        long startTime = System.currentTimeMillis();
        long period = 600000L;
        Promise<List<TimeAndSale>> promise = tickService.getTicksPromise(symbol, toTime - period, toTime);
        TicksPromiseSample.processTicksPromise(startTime, promise);
        newEndpoint.close();
    }

    protected static void processTicksPromise(long startTime, Promise<List<TimeAndSale>> promise) {
        List ticks = (List)promise.await();
        System.out.println("Request has taken " + (System.currentTimeMillis() - startTime));
        System.out.printf("Received %d ticks, last = %s%n", ticks.size(), ticks.isEmpty() ? "none" : ticks.get(ticks.size() - 1));
    }
}

