/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.dxlink.blackbox.core;

import cloudprober.probes.external.CloudproberProbesExternal;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxProbeRequest;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxRequestProvider;
import com.dxfeed.dxlink.blackbox.core.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;

class DxLinkBlackboxInputStreamRequestProvider
implements DxLinkBlackboxRequestProvider {
    private final InputStream input;

    public DxLinkBlackboxInputStreamRequestProvider(InputStream input) {
        this.input = input;
    }

    @Override
    public DxLinkBlackboxProbeRequest getProbeRequest() throws IOException {
        byte[] protobufData;
        try {
            protobufData = Utils.readInputData(this.input);
        }
        catch (IOException e) {
            throw new IOException("Failed to read input data", e);
        }
        if (protobufData == null) {
            return null;
        }
        CloudproberProbesExternal.ProbeRequest request = Utils.parseProbeRequest(protobufData);
        if (request == null) {
            return new DxLinkBlackboxProbeRequest(-1, -1, null);
        }
        Map<String, String> optionsMap = request.getOptionsList().stream().collect(Collectors.toMap(CloudproberProbesExternal.ProbeRequest.Option::getName, CloudproberProbesExternal.ProbeRequest.Option::getValue));
        return new DxLinkBlackboxProbeRequest(request.getRequestId(), request.getTimeLimit(), optionsMap);
    }
}

