/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.dxlink.blackbox.core;

import cloudprober.probes.external.CloudproberProbesExternal;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxProbeResult;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxResultSink;
import com.dxfeed.dxlink.blackbox.core.Utils;
import com.dxfeed.dxlink.blackbox.core.metrics.DxLinkBlackboxPrometheusMetricSerializer;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

class DxLinkBlackboxOutputStreamResultSink
implements DxLinkBlackboxResultSink {
    private final BufferedOutputStream out;

    public DxLinkBlackboxOutputStreamResultSink(PrintStream out) {
        this.out = new BufferedOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void accept(int requestId, DxLinkBlackboxProbeResult result) {
        DxLinkBlackboxProbeResult dxLinkBlackboxProbeResult = result;
        Objects.requireNonNull(dxLinkBlackboxProbeResult);
        DxLinkBlackboxProbeResult dxLinkBlackboxProbeResult2 = dxLinkBlackboxProbeResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DxLinkBlackboxProbeResult.Error.class, DxLinkBlackboxProbeResult.Success.class}, (Object)dxLinkBlackboxProbeResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DxLinkBlackboxProbeResult.Error error = (DxLinkBlackboxProbeResult.Error)dxLinkBlackboxProbeResult2;
                String errorMessage = error.message();
                CloudproberProbesExternal.ProbeReply unsuccessfulReply = CloudproberProbesExternal.ProbeReply.newBuilder().setRequestId(requestId).setErrorMessage(errorMessage).build();
                try {
                    BufferedOutputStream bufferedOutputStream = this.out;
                    synchronized (bufferedOutputStream) {
                        Utils.sendProbeReply(unsuccessfulReply, this.out);
                        return;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to send error probe reply", e);
                }
            }
            case 1: {
                DxLinkBlackboxProbeResult.Success success = (DxLinkBlackboxProbeResult.Success)dxLinkBlackboxProbeResult2;
                DxLinkBlackboxPrometheusMetricSerializer serializer = new DxLinkBlackboxPrometheusMetricSerializer();
                String metrics = (String)serializer.serialize(success.metrics());
                CloudproberProbesExternal.ProbeReply successfulReply = CloudproberProbesExternal.ProbeReply.newBuilder().setRequestId(requestId).setPayload(metrics).build();
                try {
                    BufferedOutputStream bufferedOutputStream = this.out;
                    synchronized (bufferedOutputStream) {
                        Utils.sendProbeReply(successfulReply, this.out);
                        return;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to send success probe reply", e);
                }
            }
        }
    }
}

