/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.dxlink.blackbox.ws;

import com.dxfeed.dxlink.blackbox.ws.DxLinkMessageAdapterFactory;
import com.dxfeed.dxlink.blackbox.ws.DxLinkWsMessage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.net.http.WebSocket;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DxLinkWsListener
implements WebSocket.Listener {
    private static final Logger log = LoggerFactory.getLogger(DxLinkWsListener.class);
    private final CompletableFuture<Long> ackReceivedFuture = new CompletableFuture();
    private final CompletableFuture<Long> handshakeCompletedFuture = new CompletableFuture();
    private final CompletableFuture<Long> authCompletedFuture = new CompletableFuture();
    private final Gson gson = new GsonBuilder().registerTypeAdapter(DxLinkWsMessage.class, (Object)new DxLinkMessageAdapterFactory()).create();
    private int authMessagesCounter = 0;

    @Override
    public void onOpen(WebSocket webSocket) {
        this.handshakeCompletedFuture.complete(System.nanoTime());
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        try {
            DxLinkWsMessage message = (DxLinkWsMessage)this.gson.fromJson(data.toString(), DxLinkWsMessage.class);
            this.handleWebSocketMessage(message);
        }
        catch (Exception e) {
            log.error("Failed to parse websocket message", (Throwable)e);
        }
        return WebSocket.Listener.super.onText(webSocket, data, last);
    }

    CompletableFuture<Long> getAckReceivedFuture() {
        return this.ackReceivedFuture;
    }

    CompletableFuture<Long> getAuthCompletedFuture() {
        return this.authCompletedFuture;
    }

    CompletableFuture<Long> getHandshakeCompletedFuture() {
        return this.handshakeCompletedFuture;
    }

    private void handleWebSocketMessage(DxLinkWsMessage message) {
        DxLinkWsMessage dxLinkWsMessage = message;
        Objects.requireNonNull(dxLinkWsMessage);
        DxLinkWsMessage dxLinkWsMessage2 = dxLinkWsMessage;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DxLinkWsMessage.Setup.class, DxLinkWsMessage.AuthState.class, DxLinkWsMessage.Error.class}, (Object)dxLinkWsMessage2, n)) {
            case 0: {
                DxLinkWsMessage.Setup setupMessage = (DxLinkWsMessage.Setup)dxLinkWsMessage2;
                this.ackReceivedFuture.complete(System.nanoTime());
                break;
            }
            case 1: {
                DxLinkWsMessage.AuthState authStateMessage = (DxLinkWsMessage.AuthState)dxLinkWsMessage2;
                if ("AUTHORIZED".equals(authStateMessage.state())) {
                    this.authCompletedFuture.complete(System.nanoTime());
                } else if (this.authMessagesCounter > 1) {
                    this.authCompletedFuture.completeExceptionally(new RuntimeException("Authentication failed"));
                }
                ++this.authMessagesCounter;
                break;
            }
            case 2: {
                DxLinkWsMessage.Error errorMessage = (DxLinkWsMessage.Error)dxLinkWsMessage2;
                String errorMessageText = errorMessage.message();
                this.authCompletedFuture.completeExceptionally(new RuntimeException(errorMessageText));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(message));
            }
        }
    }
}

