package com.devexperts.mdd.news.event;

import com.devexperts.io.IOUtil;

import java.io.IOException;
import java.io.Serializable;

/**
 * Container for news full text body along with the summary.
 */
public class NewsBody implements Serializable
{
    private static final long serialVersionUID = 0L;

    public static final int MAX_BODY_LENGTH = 32700;

    private NewsSummary summary;
    private String body;

    /**
     * Creates news body.
     * @param summary news summary
     * @param body news body
     */
    public NewsBody(NewsSummary summary, String body) {
        if (summary == null)
            throw new NullPointerException("summary is null");
        if (body == null)
            throw new NullPointerException("body is null");

        this.summary = summary;
        this.body = (body.length() > MAX_BODY_LENGTH) ? body.substring(0, MAX_BODY_LENGTH) : body;
    }

    /**
     * Convenient method for {@code getSummary().getKey()}.
     * @return news key
     */
    public NewsKey getKey() {
        return getSummary().getKey();
    }

    /**
     * Returns news summary.
     * @return news summary
     */
    public NewsSummary getSummary() {
        return summary;
    }

    /**
     * Returns news body or empty string if the news contained only summary.
     * @return news body
     */
    public String getBody() {
        return body;
    }

    // Serializable interface methods

    private void writeObject(java.io.ObjectOutputStream out) throws IOException {
        IOUtil.writeObject(out, summary);
        IOUtil.writeUTFString(out, body);
    }

    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        summary = (NewsSummary)IOUtil.readObject(in);
        body = IOUtil.readUTFString(in);
    }

    public String toString() {
        return summary.toString() + "[" + body.length() + "]";
    }
}
