package com.devexperts.mdd.news.model;

import com.devexperts.mdd.news.event.NewsFilter;
import com.devexperts.mdd.news.event.NewsKey;
import com.devexperts.mdd.news.event.NewsSummary;

import java.io.Serializable;
import java.util.List;

/**
 * News list with the last available news key. Last news key is used to not receive duplicate news.
 * @see NewsService#findNewsForFilter(NewsFilter, NewsKey)
 */
public class NewsList implements Serializable
{
    private static final long serialVersionUID = 0L;

    private final List<NewsSummary> news;
    private final NewsKey lastKey;

    public NewsList(List<NewsSummary> news, NewsKey lastKey) {
        this.news = news;
        this.lastKey = lastKey;
    }

    /**
     * Returns list of news summaries.
     * @return list of summaries.
     */
    public List<NewsSummary> getNews() {
        return news;
    }

    /**
     * Returns last news key for which the news list is valid.
     * @return last news key
     */
    public NewsKey getLastKey() {
        return lastKey;
    }
}
