package com.devexperts.mdd.news.model;

import com.devexperts.mdd.news.event.NewsBody;
import com.devexperts.mdd.news.event.NewsFilter;
import com.devexperts.mdd.news.event.NewsKey;

/**
 * Service to provide synchronous access to news.
 */
//FIXME Will be changed to support new developments in dxFeed
//TODO Remove long-polling RMI
public interface NewsService
{
    /**
     * Returns {@link com.devexperts.mdd.news.event.NewsBody} object for the specified news key.
     *
     * @param newsKey news key to lookup news body for.
     * @return news body
     * @throws NewsNotFoundException if news is not found
     */
    public NewsBody getNewsBody(NewsKey newsKey) throws NewsNotFoundException;

    /**
     * Returns news contents for the specified news key.
     *
     * @param newsKey news key to lookup news body for.
     * @return news body contents
     * @throws NewsNotFoundException if news is not found
     */
    public String getNewsContents(NewsKey newsKey) throws NewsNotFoundException;

    /**
     * Long-polling method to find news updates since last known news for the specified filter.
     * If there are news available on the server side this method will return immediately,
     * otherwise it will be blocked until news updates arrive.
     *
     * @param filter news filter to filter news on the server-side.
     * @param lastKey last received news key, or {@link NewsKey#FIRST_KEY} for first time.
     * @return news list along with the last news key.
     */
    public NewsList findNewsForFilter(NewsFilter filter, NewsKey lastKey);
}
