/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.event;

import com.devexperts.io.IOUtil;
import com.devexperts.mdd.news.event.NewsKey;
import com.devexperts.mdd.news.event.NewsSummary;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class NewsBody
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int MAX_BODY_LENGTH = 32700;
    private NewsSummary summary;
    private String body;

    public NewsBody(NewsSummary summary, String body) {
        if (summary == null) {
            throw new NullPointerException("summary is null");
        }
        if (body == null) {
            throw new NullPointerException("body is null");
        }
        this.summary = summary;
        this.body = body.length() > 32700 ? body.substring(0, 32700) : body;
    }

    public NewsKey getKey() {
        return this.getSummary().getKey();
    }

    public NewsSummary getSummary() {
        return this.summary;
    }

    public String getBody() {
        return this.body;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        IOUtil.writeObject((DataOutput)out, (Object)this.summary);
        IOUtil.writeUTFString((DataOutput)out, (String)this.body);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.summary = (NewsSummary)IOUtil.readObject((DataInput)in);
        this.body = IOUtil.readUTFString((DataInput)in);
    }

    public String toString() {
        return this.summary.toString() + "[" + this.body.length() + "]";
    }
}

