/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.event;

import java.io.Serializable;

public class NewsFilter
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int DEFAULT_LIMIT = 100;
    public static final long DEFAULT_TIMEOUT = 3600000L;
    public static final NewsFilter EMPTY = new NewsFilter();
    private final String source;
    private final String symbol;
    private final int limit;
    private final long timeout;

    public NewsFilter() {
        this(null, null, 100, 3600000L);
    }

    public NewsFilter(String source, String symbol, int limit) {
        this(source, symbol, limit, 3600000L);
    }

    public NewsFilter(String source, String symbol, int limit, long timeout) {
        this.source = source;
        this.symbol = symbol;
        if (limit <= 0) {
            throw new IllegalArgumentException("Limit must be positive: " + limit);
        }
        this.limit = Math.min(limit, 100);
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be positive: " + timeout);
        }
        this.timeout = Math.min(timeout, 3600000L);
    }

    public String getSource() {
        return this.source;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static NewsFilter getEmptyFilter() {
        return EMPTY;
    }

    public static NewsFilter createSourceFilter(String source) {
        return new NewsFilter(source, null, 100, 3600000L);
    }

    public static NewsFilter createSymbolFilter(String symbol) {
        return new NewsFilter(null, symbol, 100, 3600000L);
    }

    public String toString() {
        return "NewsFilter{source=" + this.source + ", symbol=" + this.symbol + ", limit=" + this.limit + "}";
    }
}

