/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.event;

import com.devexperts.io.IOUtil;
import com.devexperts.mdd.news.event.NewsKey;
import com.devexperts.util.TimeFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NewsSummary
implements Serializable,
Comparable<NewsSummary> {
    private static final long serialVersionUID = 0L;
    public static final String MESSAGE_SYMBOL = "NEWS";
    public static final int MAX_TITLE_LENGTH = 32700;
    private NewsKey key;
    private String sourceId;
    private long time;
    private String title;
    private String source;
    private transient Map<String, Collection<String>> tags;

    public NewsSummary(NewsKey key, String sourceId, long time, String title, String source, Map<String, Collection<String>> tags) {
        this.key = key;
        this.sourceId = sourceId;
        this.time = time;
        if (title != null) {
            this.title = title.length() > 32700 ? title.substring(0, 32700) : title;
        }
        this.source = source;
        this.tags = tags;
    }

    public NewsSummary(NewsSummary summary, Collection<String> filterTags) {
        this(summary.key, summary.sourceId, summary.time, summary.title, summary.source, NewsSummary.cloneTags(summary, filterTags));
    }

    public NewsKey getKey() {
        return this.key;
    }

    public void assignKey(NewsKey key) {
        if (!this.key.equals(NewsKey.FIRST_KEY)) {
            throw new IllegalStateException("key is already assigned");
        }
        this.key = key;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public long getTime() {
        return this.time;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSource() {
        return this.source;
    }

    public Set<String> getTagNames() {
        return this.tags.keySet();
    }

    public Collection<String> getTagValues(String tag) {
        return this.tags.get(tag);
    }

    public Collection<String> getSymbols() {
        return this.getTagValues("Symbols");
    }

    private static Map<String, Collection<String>> cloneTags(NewsSummary summary, Collection<String> filterTags) {
        if (summary.getTagNames().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (String tag : filterTags) {
            Collection<String> tagValues = summary.getTagValues(tag);
            if (tagValues == null) continue;
            result.put(tag, tagValues);
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        IOUtil.writeCompactInt((DataOutput)out, (int)this.tags.size());
        for (String tag : this.getTagNames()) {
            IOUtil.writeUTFString((DataOutput)out, (String)tag);
            Collection<String> values = this.getTagValues(tag);
            IOUtil.writeCompactInt((DataOutput)out, (int)values.size());
            for (String value : values) {
                IOUtil.writeUTFString((DataOutput)out, (String)value);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = IOUtil.readCompactInt((DataInput)in);
        if (size == 0) {
            this.tags = Collections.emptyMap();
        } else {
            this.tags = new HashMap<String, Collection<String>>(size);
            for (int i = 0; i < size; ++i) {
                String tag = IOUtil.readUTFString((DataInput)in);
                int tagSize = IOUtil.readCompactInt((DataInput)in);
                if (tagSize == 0) {
                    this.tags.put(tag, Collections.emptySet());
                    continue;
                }
                if (tagSize == 1) {
                    String value = IOUtil.readUTFString((DataInput)in);
                    this.tags.put(tag, Collections.singleton(value));
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>(tagSize);
                for (int j = 0; j < tagSize; ++j) {
                    String value = IOUtil.readUTFString((DataInput)in);
                    values.add(value);
                }
                this.tags.put(tag, values);
            }
        }
    }

    @Override
    public int compareTo(NewsSummary o) {
        return this.getKey().getCode().compareTo(o.getKey().getCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NewsSummary) {
            NewsSummary that = (NewsSummary)o;
            return this.getKey().equals(that.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "NewsSummary{" + this.key.getCode() + "/" + this.getSourceId() + ", time=" + TimeFormat.DEFAULT.format(this.getTime()) + ", title=" + this.title + ", source=" + this.source + "}";
    }
}

