/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.model;

import com.devexperts.mdd.news.event.NewsSummary;
import com.dxfeed.model.ObservableListModel;
import com.dxfeed.model.ObservableListModelListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class ObservableNewsList
extends AbstractList<NewsSummary>
implements ObservableListModel<NewsSummary> {
    private static final Comparator<NewsSummary> REVERSE_COMPARATOR = Collections.reverseOrder();
    private List<ObservableListModelListener<? super NewsSummary>> listeners = new CopyOnWriteArrayList<ObservableListModelListener<? super NewsSummary>>();
    private int limit;
    private ArrayList<NewsSummary> news = new ArrayList(100);
    private boolean changed;

    ObservableNewsList() {
    }

    @Override
    public NewsSummary get(int index) {
        return this.news.get(index);
    }

    @Override
    public int size() {
        return this.news.size();
    }

    @Override
    public void clear() {
        this.changed = true;
        this.news.clear();
    }

    public void addListener(ObservableListModelListener<? super NewsSummary> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ObservableListModelListener<? super NewsSummary> listener) {
        this.listeners.remove(listener);
    }

    void setLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be positive: " + limit);
        }
        this.limit = limit;
        if (this.news.size() > limit) {
            while (this.news.size() > limit) {
                this.news.remove(this.news.size() - 1);
            }
            this.fireModelChanged();
        }
    }

    protected void beginChange() {
        this.changed = false;
    }

    protected boolean addChange(NewsSummary newsSummary) {
        if (newsSummary == null) {
            throw new NullPointerException("newsSummary");
        }
        int index = Collections.binarySearch(this.news, newsSummary, REVERSE_COMPARATOR);
        if (index >= 0) {
            return false;
        }
        this.news.add(-index - 1, newsSummary);
        while (this.news.size() > this.limit) {
            this.news.remove(this.news.size() - 1);
        }
        this.changed = true;
        return true;
    }

    protected void endChange() {
        if (this.changed) {
            this.fireModelChanged();
        }
    }

    protected void fireModelChanged() {
        ObservableListModelListener.Change change = new ObservableListModelListener.Change((ObservableListModel)this);
        for (ObservableListModelListener<? super NewsSummary> listener : this.listeners) {
            listener.modelChanged(change);
        }
    }
}

