package com.devexperts.mdd.news.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * Common news tags names.
 */
public class NewsTags {
    // Utility class only
    private NewsTags() {}

    // Required system tags

    /** Feed that generated the news. */
    public static final String NEWS_FEED = "feed";

    /** External ID assigned by news provider. */
    public static final String NEWS_SOURCE_ID = "sourceId";

    /** News source provider. */
    public static final String NEWS_SOURCE = "source";

    /** News time (UTC millis as long value). */
    public static final String NEWS_TIME = "time";

    /** News title. */
    public static final String NEWS_TITLE = "title";

    /** News body (article) optional. */
    public static final String NEWS_BODY = "body";

    public static final Set<String> SYSTEM_TAGS;
    static {
        Set<String> tags = new HashSet<>();
        tags.add(NEWS_FEED);
        tags.add(NEWS_SOURCE);
        tags.add(NEWS_SOURCE_ID);
        tags.add(NEWS_TIME);
        tags.add(NEWS_TITLE);
        tags.add(NEWS_BODY);
        SYSTEM_TAGS = Collections.unmodifiableSet(tags);
    }

    // Public optional tags
    //FIXME Tags should be lower-case but remained as-is for backward compatibility

    /** Optional tag for stock symbols related to the news. */
    public static final String SYMBOLS = "Symbols";

    /** Optional tag for boolean flag if the news were a correction. */
    public static final String CORRECTION = "Correction";

    public static final Set<String> OPTIONAL_TAGS;
    static {
        Set<String> tags = new HashSet<>();
        tags.add(SYMBOLS);
        tags.add(CORRECTION);
        OPTIONAL_TAGS = Collections.unmodifiableSet(tags);
    }

    // Internal tags

    /** Internal tag for news raw data (as seen by the feed). */
    public static final String CONTENT_NEWS = "_news";

    /** Internal optional tag for news raw meta information (if available). */
    public static final String CONTENT_META = "_meta";
}
