package com.devexperts.mdd.news.model;

import com.devexperts.mdd.news.event.NewsEvent;
import com.devexperts.mdd.news.event.NewsFilter;
import com.devexperts.mdd.news.event.NewsKey;

import java.io.Serializable;
import java.util.List;

/**
 * News list with the last available news key. Last news key is used to not receive duplicate news.
 * @see NewsService#findNewsForFilter(NewsFilter, NewsKey)
 */
public class NewsList implements Serializable {
    
    private static final long serialVersionUID = 1L;

    private final List<NewsEvent> news;
    private final NewsKey lastKey;

    public NewsList(List<NewsEvent> news, NewsKey lastKey) {
        this.news = news;
        this.lastKey = lastKey;
    }

    /**
     * Returns list of news.
     * @return list of news (summary with a news body).
     */
    public List<NewsEvent> getNews() {
        return news;
    }

    /**
     * Returns last news key for which the news list is valid.
     * @return last news key
     */
    public NewsKey getLastKey() {
        return lastKey;
    }
}
